/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import hct.BBoard;
import hct.HctPrms;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hct.ha.HAClientQueuePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import query.QueryPrms;

public class HACache {
    static ConfigHashtable conftab = TestConfig.tab();
    static LogWriter logger = Log.getLogWriter();
    static BBoard bb = BBoard.getInstance();
    static String regionName = conftab.stringAt(HctPrms.regionName);
    static GsRandom rand = new GsRandom();
    static int numClients = -1;
    static long killInterval = conftab.longAt(HctPrms.killInterval);

    public static synchronized void killStableServer() throws ClientVmNotFoundException {
        SharedCounters counters = HAClientQueueBB.getBB().getSharedCounters();
        Log.getLogWriter().info("Waiting for stable signal...");
        while (true) {
            MasterController.sleepForMs(3000);
            if (counters.decrementAndRead(HAClientQueueBB.stableSignal) >= 0L) break;
            counters.increment(HAClientQueueBB.stableSignal);
        }
        Log.getLogWriter().info("Got stable signal...");
        HACache.killServer();
        Log.getLogWriter().info("Setting stable signal...");
        counters.increment(HAClientQueueBB.stableSignal);
    }

    public static synchronized void killServer() throws ClientVmNotFoundException {
        Long lastKill;
        Region aRegion = null;
        if (TestConfig.tab().booleanAt(QueryPrms.regionForRemoteOQL, false)) {
            aRegion = RegionHelper.getRegion(regionName);
        } else {
            int numRegion = TestConfig.tab().intAt(HAClientQueuePrms.regionRange, 1) - 1;
            aRegion = RegionHelper.getRegion(regionName + numRegion);
        }
        Assert.assertNotNull((Object)aRegion);
        Set active = ClientHelper.getActiveServers(aRegion);
        int minServersRequiredAlive = TestConfig.tab().intAt(HAClientQueuePrms.minServersRequiredAlive, 3);
        if (active.size() < minServersRequiredAlive) {
            logger.info("No kill executed , a minimum of " + minServersRequiredAlive + " servers have to be kept alive");
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - (lastKill = (Long)bb.getSharedMap().get("lastKillTime"));
        if (diff < killInterval) {
            logger.info("No kill executed");
            return;
        }
        bb.getSharedMap().put("lastKillTime", new Long(now));
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        int index = rand.nextInt(endpoints.size() - 1);
        BridgeHelper.Endpoint endpoint = endpoints.get(index);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        target = ClientVmMgr.stop("Killing random cache server", -21, -31, target);
        Log.getLogWriter().info("Server Killed : " + target);
        long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerCrashedEvents, HACache.getNumClients());
        Log.getLogWriter().info("After incrementing, BBoard.expectedServerCrashedEvents = " + count);
        int sleepSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        logger.info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        active = ClientHelper.getActiveServers(aRegion);
        ServerLocation server = new ServerLocation(endpoint.getHost(), endpoint.getPort());
        if (active.contains(server)) {
            logger.info("ERROR: Killed server " + server + " found in Active Server List: " + active);
        }
        ClientVmMgr.start("Restarting the cache server", target);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerJoinedEvents, HACache.getNumClients());
        Log.getLogWriter().info("After incrementing, BBoard.expectedServerJoinedEvents = " + count);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientJoinedEvents, endpoints.size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientJoinedEvents = " + count);
        int sleepMs = ClientHelper.getRetryInterval(aRegion) + 1000;
        logger.info("Sleeping for " + sleepMs + " ms");
        MasterController.sleepForMs(sleepMs);
        active = ClientHelper.getActiveServers(aRegion);
        if (!active.contains(server)) {
            logger.info("ERROR: Restarted server " + server + " not in Active Server List: " + active);
        }
    }

    public static synchronized void killClient() {
        if (HAClientQueueBB.getBB().getSharedCounters().incrementAndRead(HAClientQueueBB.NUM_CLIENTS_KILL) <= (long)TestConfig.tab().intAt(HAClientQueuePrms.maxClientsCanKill, 1)) {
            if (DistributedSystemHelper.getDistributedSystem() != null) {
                CacheHelper.closeCache();
            }
            MasterController.sleepForMs(5000);
            HAClientQueue.initCacheClient();
            HAClientQueueBB.getBB().getSharedCounters().decrement(HAClientQueueBB.NUM_CLIENTS_KILL);
            logger.info("Restarted Client. No of clients down are " + HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_CLIENTS_KILL));
        } else {
            HAClientQueueBB.getBB().getSharedCounters().decrement(HAClientQueueBB.NUM_CLIENTS_KILL);
            logger.info("No of clients down are " + HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_CLIENTS_KILL));
        }
    }

    public static synchronized int getNumClients() {
        if (numClients == -1) {
            int totalVMs = TestConfig.getInstance().getTotalVMs();
            int bridgeVMs = BridgeHelper.getEndpoints().size();
            numClients = totalVMs - bridgeVMs;
            Log.getLogWriter().info("numBridgeServers = " + bridgeVMs);
            Log.getLogWriter().info("numEdgeClients = " + numClients);
        }
        return numClients;
    }
}

