/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hydra.DistributedSystemHelper;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import util.TestException;

public class Validator {
    public static long createCount = 0L;
    public static long updateCount = 0L;
    public static long invalidateCount = 0L;
    public static long destroyCount = 0L;

    public static void validateNumberOfInvalidatesReceived() {
        HAClientQueue.waitForLastKeyReceivedAtClient();
        Log.getLogWriter().info("going to validate...");
        long invalidatesRecordedByStats = HAClientQueue.mypool.getInvalidateCount();
        long putsByFeeder = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        if (putsByFeeder != invalidatesRecordedByStats) {
            throw new TestException("number of puts ( " + putsByFeeder + ") is greater than the number of invalidates ( " + invalidatesRecordedByStats + ")  received ");
        }
        Log.getLogWriter().info("successfully validated...");
    }

    public static void validateNumberOfInvalidatesReceivedWithoutFailover() {
        HAClientQueue.waitForLastKeyReceivedAtClient();
        long invalidatesRecordedByStats = HAClientQueue.mypool.getInvalidateCount();
        long putsByFeeder = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        if (putsByFeeder != invalidatesRecordedByStats) {
            throw new TestException("number of puts ( " + putsByFeeder + ") is not equal to the number of invalidates ( " + invalidatesRecordedByStats + ")  received ");
        }
        Log.getLogWriter().info("successfully validated...");
    }

    public static void validateInvalidatesConflationEnabledWithNoFailover() {
        PoolImpl proxy = HAClientQueue.mypool;
        ClientProxyMembershipID cpm = proxy.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        HashMap mp = (HashMap)HAClientQueueBB.getBB().getSharedMap().get(proxyIdStr);
        Long numOfPuts = (Long)mp.get("eventsPut");
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Long numOfMissRemovals = (Long)mp.get("numVoidRemovals");
        Long numOfRemovals = (Long)mp.get("eventsRemoved");
        long invalidatesRecordedByStats = HAClientQueue.mypool.getInvalidateCount();
        Log.getLogWriter().info("statsMap : " + mp.toString() + ", invalidates recvd=" + invalidatesRecordedByStats);
        Log.getLogWriter().info("value of numOfPuts : " + numOfPuts);
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        Log.getLogWriter().info("value of numOfmiss : " + numOfMissRemovals);
        Log.getLogWriter().info("no of invalidates : " + invalidatesRecordedByStats);
        Log.getLogWriter().info("value of numRemoved " + (Long)mp.get("eventsRemoved"));
        if ((long)numOfPuts.intValue() < invalidatesRecordedByStats) {
            throw new TestException("No of invalidates received by client VM is less than no. of puts on feeder : expected=" + numOfPuts + " ; received=" + invalidatesRecordedByStats);
        }
        if ((long)(numOfRemovals.intValue() + numOfMissRemovals.intValue()) != invalidatesRecordedByStats) {
            throw new TestException("No of events sent to client by server does not match the number received by client: expected=" + (numOfRemovals.intValue() + numOfMissRemovals.intValue()) + " ; received=" + invalidatesRecordedByStats);
        }
    }

    public static void validateInvalidatesConflationEnabledWithFailover() {
        HAClientQueue.waitForLastKeyReceivedAtClient();
        long numOfPuts = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        long invalidatesRecordedByStats = HAClientQueue.mypool.getInvalidateCount();
        Log.getLogWriter().info("value of numOfPuts : " + numOfPuts);
        Log.getLogWriter().info("no of invalidates : " + invalidatesRecordedByStats);
        if (numOfPuts < invalidatesRecordedByStats) {
            throw new TestException("No of invalidates received by client VM is more than no. of puts on feeder");
        }
    }

    public static String checkBlackBoardForException() {
        long exceptionCount = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_EXCEPTION);
        if (exceptionCount > 0L) {
            StringBuffer reason = new StringBuffer();
            reason.append("\n");
            int reasonCount = 0;
            Map reasonMap = HAClientQueueBB.getBB().getSharedMap().getMap();
            Set reasonEntrySet = reasonMap.entrySet();
            for (Map.Entry reasonEntry : reasonEntrySet) {
                Object reasonKey = reasonEntry.getKey();
                if (!(reasonKey instanceof String) || !((String)reasonKey).startsWith("CLIENT_")) continue;
                ArrayList reasonArray = (ArrayList)reasonEntry.getValue();
                reason.append(reasonKey + "\n");
                for (int i = 0; i < reasonArray.size(); ++i) {
                    reason.append("Reason for exception no. " + ++reasonCount + " : ");
                    reason.append(reasonArray.get(i));
                    reason.append("\n");
                }
            }
            return reason.toString();
        }
        return null;
    }

    public static void validateOpCountsForNoFailover() {
        long createCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_CREATE);
        long updateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        long invalidateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_INVALIDATE);
        long destroyCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_DESTROY);
        Log.getLogWriter().info(" createCountFromBB " + createCountFromBB + " createCount " + createCount);
        Log.getLogWriter().info(" updateCountFromBB " + updateCountFromBB + " updateCount " + updateCount);
        Log.getLogWriter().info(" invalidateCountFromBB " + invalidateCountFromBB + " invalidateCount " + invalidateCount);
        Log.getLogWriter().info(" destroyCountFromBB " + destroyCountFromBB + " destroyCount " + destroyCount);
        long diff = createCountFromBB - createCount;
        if (diff != 0L) {
            throw new TestException(diff + " creates not received by client");
        }
        diff = updateCountFromBB - updateCount;
        if (diff != 0L) {
            throw new TestException(diff + " updates not received by client");
        }
        diff = invalidateCountFromBB - invalidateCount;
        if (diff != 0L) {
            throw new TestException(diff + " invalidates not received by client");
        }
        diff = destroyCountFromBB - destroyCount;
        if (diff != 0L) {
            throw new TestException(diff + " destroys not received by client");
        }
    }

    public static void validateOpCountsForFailover() {
        long createCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_CREATE);
        long updateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        long invalidateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_INVALIDATE);
        long destroyCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_DESTROY);
        long diff = createCountFromBB - createCount;
        boolean validationFailed = false;
        StringBuffer failureMsg = new StringBuffer();
        if (diff != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " creates not received by client \n");
        }
        if ((diff = updateCountFromBB - updateCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " updates not received by client \n");
        }
        if ((diff = invalidateCountFromBB - invalidateCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " invalidates not received by client \n");
        }
        if ((diff = destroyCountFromBB - destroyCount) != 0L) {
            validationFailed = true;
            failureMsg.append(diff + " destroys not received by client \n");
        }
        if (validationFailed) {
            throw new TestException(failureMsg.toString());
        }
    }

    public static void validateOpCountsNoFailoverConflationEnabled() {
        long createCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_CREATE);
        long updateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE);
        long invalidateCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_INVALIDATE);
        long destroyCountFromBB = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_DESTROY);
        HAClientQueueBB.getBB().printSharedCounters();
        Log.getLogWriter().info(" createCountFromBB " + createCountFromBB + " createCount " + createCount);
        Log.getLogWriter().info(" updateCountFromBB " + updateCountFromBB + " updateCount " + updateCount);
        Log.getLogWriter().info(" invalidateCountFromBB " + invalidateCountFromBB + " invalidateCount " + invalidateCount);
        Log.getLogWriter().info(" destroyCountFromBB " + destroyCountFromBB + " destroyCount " + destroyCount);
        long diff = createCountFromBB - createCount;
        boolean validationFailed = false;
        StringBuffer failureMsg = new StringBuffer();
        if (diff < 0L) {
            validationFailed = true;
            failureMsg.append(diff + " creates not received by client" + " createCountFromBB = " + createCountFromBB + " createCount" + createCount + " \n");
        }
        if ((diff = updateCountFromBB - updateCount) < 0L) {
            validationFailed = true;
            failureMsg.append(diff + " updates not received by client \n");
        }
        if ((diff = invalidateCountFromBB - invalidateCount) < 0L) {
            validationFailed = true;
            failureMsg.append(diff + " invalidates not received by client \n");
        }
        if ((diff = destroyCountFromBB - destroyCount) < 0L) {
            validationFailed = true;
            failureMsg.append(diff + " destroys not received by client \n");
        }
        if (validationFailed) {
            throw new TestException(failureMsg.toString());
        }
    }

    public static void pauseBeforeValidation() {
        Log.getLogWriter().info("going to sleep before validating...");
        try {
            Thread.sleep(180000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkForConflation() {
        PoolImpl proxy = HAClientQueue.mypool;
        ClientProxyMembershipID cpm = proxy.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        if (DistributedSystemHelper.getGemFireDescription().getEnableNetworkPartitionDetection().booleanValue()) {
            proxyIdStr = proxyIdStr.substring(proxyIdStr.lastIndexOf("(") + 1, proxyIdStr.indexOf(":"));
        }
        HashMap mp = (HashMap)HAClientQueueBB.getBB().getSharedMap().get(proxyIdStr);
        Long numOfPuts = (Long)mp.get("eventsPut");
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Long numOfMissRemovals = (Long)mp.get("numVoidRemovals");
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        long totalConflation = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (totalConflation == 0L) {
            throw new TestException("No conflation done - Test Issue - needs tuning ");
        }
    }

    public static void checkClientConflation() {
        PoolImpl pool = HAClientQueue.mypool;
        ClientProxyMembershipID cpm = pool.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        HashMap mp = (HashMap)HAClientQueueBB.getBB().getSharedMap().get(proxyIdStr);
        Long numOfPuts = (Long)mp.get("eventsPut");
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Long numOfMissRemovals = (Long)mp.get("numVoidRemovals");
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        long totalConflation = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (numOfConflated.equals(new Long(0L))) {
            throw new TestException("No conflation done - Test Issue - needs tuning ");
        }
    }

    public static void verifyNoConflation() {
        PoolImpl pool = HAClientQueue.mypool;
        ClientProxyMembershipID cpm = pool.getProxyID();
        String proxyIdStr = cpm.toString();
        Log.getLogWriter().info("Proxy String : " + proxyIdStr);
        HashMap mp = (HashMap)HAClientQueueBB.getBB().getSharedMap().get(proxyIdStr);
        Long numOfPuts = (Long)mp.get("eventsPut");
        Long numOfConflated = (Long)mp.get("eventsConflated");
        Long numOfMissRemovals = (Long)mp.get("numVoidRemovals");
        Log.getLogWriter().info("value of numOfConflated : " + numOfConflated);
        long totalConflation = HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_GLOBAL_CONFLATE);
        Log.getLogWriter().info("Total Conflation : " + totalConflation);
        if (!numOfConflated.equals(new Long(0L))) {
            throw new TestException("Expected no conflation to happen but has " + numOfConflated + " events");
        }
    }

    public static void toggleHAOverflowFlag() {
        LocalRegionHelper.isHAOverflowFeaturedUsedInPrimaryPutOnShareBB();
    }

    public static void checkHAOverFlowUsedOnPrimary() {
        int status = (int)HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.HA_OVERFLOW_STATUS);
        if (status == 0) {
            throw new TestException("Test issue : Test need tuning - no overflow happened");
        }
    }
}

