/*
 * Decompiled with CFR 0.152.
 */
package hdfs.mapreduce;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred.GFInputFormat;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred.GFOutputFormat;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import hdfs.mapreduce.PEIWritable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import util.TestHelper;
import util.ValueHolder;

public class KnownKeysMRv1
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        String locatorHost = args[0];
        int locatorPort = Integer.parseInt(args[1]);
        String hdfsHomeDir = args[2];
        System.out.println("KnownKeysMRv1 invoked with args (locatorHost = " + locatorHost + " locatorPort = " + locatorPort + " hdfsHomeDir = " + hdfsHomeDir);
        Configuration conf = this.getConf();
        JobConf jobConf = new JobConf(conf, KnownKeysMRv1.class);
        jobConf.setJobName("knownKeysMRv1");
        jobConf.set("mapreduce.input.gfinputformat.inputregion", "partitionedRegion");
        jobConf.set("mapreduce.input.gfinputformat.homedir", hdfsHomeDir);
        jobConf.setBoolean("mapreduce.input.gfinputformat.checkpoint", false);
        jobConf.set("mapreduce.output.gfoutputformat.outputregion", "validationRegion");
        jobConf.set("mapreduce.output.gfoutputformat.locatorhost", locatorHost);
        jobConf.setInt("mapreduce.output.gfoutputformat.locatorport", locatorPort);
        jobConf.setMapperClass(KnownKeysMRv1Mapper.class);
        jobConf.setInputFormat(GFInputFormat.class);
        jobConf.setMapOutputKeyClass(GFKey.class);
        jobConf.setMapOutputValueClass(PEIWritable.class);
        jobConf.setReducerClass(KnownKeysMRv1Reducer.class);
        jobConf.setOutputFormat(GFOutputFormat.class);
        JobClient.runJob((JobConf)jobConf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("KnownKeysMRv1.main() invoked with " + args);
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new KnownKeysMRv1(), (String[])args);
        System.exit(rc);
    }

    public static class KnownKeysMRv1Reducer
    extends MapReduceBase
    implements Reducer<GFKey, PEIWritable, Object, Object> {
        public void reduce(GFKey key, Iterator<PEIWritable> values, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
            String keyStr = (String)key.getKey();
            ValueHolder updateValue = null;
            ValueHolder createValue = null;
            boolean destroyed = false;
            System.out.println("KnownKeysMRv1.reduce() invoked with " + keyStr);
            while (values.hasNext()) {
                PEIWritable peiWritable = values.next();
                PersistedEventImpl event = peiWritable.getEvent();
                Operation op = event.getOperation();
                ValueHolder vh = null;
                if (op.isDestroy()) {
                    destroyed = true;
                } else {
                    try {
                        vh = (ValueHolder)event.getDeserializedValue();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("KnownKeysMRv1.map() caught " + e + " : " + TestHelper.getStackTrace(e));
                    }
                    if (op.isUpdate()) {
                        updateValue = vh;
                    } else {
                        createValue = vh;
                    }
                }
                System.out.println("KnownKeysMRv1.reduce() record: " + op.toString() + ": key = " + keyStr + " and op " + op.toString());
            }
            if (!destroyed) {
                if (updateValue != null) {
                    output.collect((Object)keyStr, updateValue);
                } else {
                    output.collect((Object)keyStr, createValue);
                }
            }
        }
    }

    public static class KnownKeysMRv1Mapper
    extends MapReduceBase
    implements Mapper<GFKey, PersistedEventImpl, GFKey, PEIWritable> {
        public void map(GFKey key, PersistedEventImpl value, OutputCollector<GFKey, PEIWritable> output, Reporter reporter) throws IOException {
            String keyStr = (String)key.getKey();
            Operation op = value.getOperation();
            ValueHolder entryValue = null;
            System.out.println("map method invoked with " + keyStr + " " + op.toString());
            try {
                entryValue = (ValueHolder)value.getDeserializedValue();
            }
            catch (ClassNotFoundException e) {
                System.out.println("KnownKeysMRv1.map() caught " + e + " : " + TestHelper.getStackTrace(e));
            }
            output.collect((Object)key, (Object)new PEIWritable(value));
        }
    }
}

