/*
 * Decompiled with CFR 0.152.
 */
package hdfs.mapreduce;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFInputFormat;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFOutputFormat;
import hdfs.mapreduce.PEIWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import util.TestHelper;
import util.ValueHolder;

public class KnownKeysMRv2
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        String locatorHost = args[0];
        int locatorPort = Integer.parseInt(args[1]);
        String hdfsHomeDir = args[2];
        System.out.println("KnownKeysMRv2 invoked with args (locatorHost = " + locatorHost + " locatorPort = " + locatorPort + " hdfsHomeDir = " + hdfsHomeDir);
        Configuration conf = this.getConf();
        conf.set("mapreduce.input.gfinputformat.inputregion", "partitionedRegion");
        conf.set("mapreduce.input.gfinputformat.homedir", hdfsHomeDir);
        conf.setBoolean("mapreduce.input.gfinputformat.checkpoint", false);
        conf.set("mapreduce.output.gfoutputformat.outputregion", "validationRegion");
        conf.set("mapreduce.output.gfoutputformat.locatorhost", locatorHost);
        conf.setInt("mapreduce.output.gfoutputformat.locatorport", locatorPort);
        Job job = Job.getInstance((Configuration)conf, (String)"knownKeysMRv2");
        job.setInputFormatClass(GFInputFormat.class);
        job.setOutputFormatClass(GFOutputFormat.class);
        job.setMapperClass(KnownKeysMRv2Mapper.class);
        job.setMapOutputKeyClass(GFKey.class);
        job.setMapOutputValueClass(PEIWritable.class);
        job.setReducerClass(KnownKeysMRv2Reducer.class);
        return job.waitForCompletion(false) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new KnownKeysMRv2(), (String[])args);
        System.exit(rc);
    }

    public static class KnownKeysMRv2Reducer
    extends Reducer<GFKey, PEIWritable, Object, Object> {
        public void reduce(GFKey key, Iterable<PEIWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            String keyStr = (String)key.getKey();
            ValueHolder updateValue = null;
            ValueHolder createValue = null;
            boolean destroyed = false;
            System.out.println("KnownKeysMRv2.reduce() invoked with " + keyStr);
            for (PEIWritable value : values) {
                PersistedEventImpl event = value.getEvent();
                Operation op = event.getOperation();
                ValueHolder vh = null;
                if (op.isDestroy()) {
                    destroyed = true;
                } else {
                    try {
                        vh = (ValueHolder)event.getDeserializedValue();
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("KnownKeysMRv2.map() caught " + e + " : " + TestHelper.getStackTrace(e));
                    }
                    if (op.isUpdate()) {
                        updateValue = vh;
                    } else {
                        createValue = vh;
                    }
                }
                System.out.println("KnownKeysMRv2.reduce() record: " + op.toString() + ": key = " + keyStr + " and op " + op.toString());
            }
            if (!destroyed) {
                if (updateValue != null) {
                    context.write(key.getKey(), updateValue);
                } else {
                    context.write(key.getKey(), createValue);
                }
            }
        }
    }

    public static class KnownKeysMRv2Mapper
    extends Mapper<GFKey, PersistedEventImpl, GFKey, PEIWritable> {
        public void map(GFKey key, PersistedEventImpl value, Mapper.Context context) throws IOException, InterruptedException {
            String keyStr = (String)key.getKey();
            Operation op = value.getOperation();
            ValueHolder entryValue = null;
            System.out.println("map method invoked with " + keyStr + " " + op.toString());
            try {
                entryValue = (ValueHolder)value.getDeserializedValue();
            }
            catch (ClassNotFoundException e) {
                System.out.println("KnownKeysMRv2.map() caught " + e + " : " + TestHelper.getStackTrace(e));
            }
            context.write((Object)key, (Object)new PEIWritable(value));
        }
    }
}

