/*
 * Decompiled with CFR 0.152.
 */
package hdfs.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import util.TestHelper;

public class PEIWritable
implements Writable {
    private PersistedEventImpl event;

    public PEIWritable() {
    }

    public PersistedEventImpl getEvent() {
        return this.event;
    }

    public PEIWritable(PersistedEventImpl event) {
        this.event = event;
    }

    public void write(DataOutput out) throws IOException {
        boolean sorted = this.event instanceof SortedHoplogPersistedEvent;
        out.writeBoolean(sorted);
        this.event.toData(out);
    }

    public void readFields(DataInput in) throws IOException {
        try {
            boolean sorted = in.readBoolean();
            this.event = sorted ? new SortedHoplogPersistedEvent() : new UnsortedHoplogPersistedEvent();
            this.event.fromData(in);
        }
        catch (ClassNotFoundException e) {
            System.out.println("PEIWritable.readFields caught " + e + ": " + TestHelper.getStackTrace(e));
        }
    }
}

