/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.SSLDescription;
import hydra.SSLPrms;
import hydra.TestConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;

public abstract class AbstractDescription {
    public abstract SortedMap toSortedMap();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.toSortedMap();
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }

    protected Properties addProperties(Properties src, Properties dst) {
        if (src == null) {
            return dst;
        }
        if (dst == null) {
            String s = "Atttempt to add to null dst properties";
            throw new HydraInternalException(s);
        }
        for (String string : src.keySet()) {
            dst.setProperty(string, src.getProperty(string));
        }
        return dst;
    }

    protected static List asList(int[] ints) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < ints.length; ++i) {
            list.add(new Integer(ints[i]));
        }
        return list;
    }

    protected static Boolean getBooleanFor(String str, Long key) {
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    protected static Integer getIntegerFor(String str, Long key) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
            throw new HydraConfigException(s);
        }
    }

    protected static Class getClass(Long key, String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            String s = BasePrms.nameForKey(key) + " class not found: " + classname;
            throw new HydraConfigException(s);
        }
    }

    protected static String getClassname(Object obj) {
        return obj == null ? null : obj.getClass().getName();
    }

    private static String argTypesAsString(Class[] argTypes) {
        String s = "";
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i != 0) {
                    s = s + ", ";
                }
                s = s + argTypes[i].getName();
            }
        }
        return s;
    }

    private static Method getMethod(Long key, Class cls, String methodname, Class[] argTypes) {
        try {
            return cls.getDeclaredMethod(methodname, argTypes);
        }
        catch (NoSuchMethodException e) {
            String s = BasePrms.nameForKey(key) + " method not found: " + cls + "." + methodname + "(" + AbstractDescription.argTypesAsString(argTypes) + ")";
            throw new HydraConfigException(s);
        }
    }

    private static Method getMethod(Long key, Class cls, String methodname, Class[] argTypes, Class returnType) {
        Method method = AbstractDescription.getMethod(key, cls, methodname, argTypes);
        Class<?> actualReturnType = method.getReturnType();
        if (actualReturnType != returnType) {
            String s = BasePrms.nameForKey(key) + " method " + methodname + " in " + cls + " does not have expected return type " + returnType + ", instead returns: " + actualReturnType;
            throw new HydraConfigException(s);
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            String s = BasePrms.nameForKey(key) + " method " + methodname + " in " + cls + " is not public static";
            throw new HydraConfigException(s);
        }
        return method;
    }

    public static Object getInstance(Long key, String classname) {
        Class cls = AbstractDescription.getClass(key, classname);
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            String s = BasePrms.nameForKey(key) + " cannot instantiate class " + classname + " due to " + e.getClass().getName() + " (" + e.getMessage() + ")";
            throw new HydraConfigException(s);
        }
    }

    protected static Integer getNonnegativeIntegerFor(Integer i, Long key) {
        if (i >= 0) {
            return i;
        }
        String s = BasePrms.nameForKey(key) + " has negative value: " + i;
        throw new HydraConfigException(s);
    }

    protected static Map getParametersAndDefaults(Long key, Class cls) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String def;
            Long pkey;
            block6: {
                Field field = fields[i];
                int m = field.getModifiers();
                if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || Modifier.isFinal(m) || field.getType() != Long.class) continue;
                String fieldName = field.getName();
                pkey = BasePrms.keyForName(cls.getName() + BasePrms.DASH + fieldName);
                def = "";
                String defName = AbstractDescription.convertPrmDefault(fieldName);
                try {
                    Field defField = cls.getDeclaredField(defName);
                    if (defField == null) break block6;
                    int d = defField.getModifiers();
                    if (Modifier.isPublic(d) && Modifier.isStatic(d) && Modifier.isFinal(d) && defField.getType() == String.class) {
                        def = (String)defField.get(null);
                        break block6;
                    }
                    String s = "For " + BasePrms.nameForKey(key) + "=" + cls.getName() + ", field " + defName + " for the default value of field " + fieldName + " is not a public static final String";
                    throw new HydraConfigException(s);
                }
                catch (IllegalAccessException e) {
                    String s = "For " + BasePrms.nameForKey(key) + "=" + cls.getName() + ", unable to access field " + defName;
                    throw new HydraConfigException(s);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            map.put(pkey, def);
        }
        if (map.size() == 0) {
            String s = BasePrms.nameForKey(key) + "=" + cls.getName() + " contains no public static Long fields";
            throw new HydraConfigException(s);
        }
        return map;
    }

    protected String convertPrm(Long key) {
        String name = BasePrms.nameForKey(key);
        name = name.substring(name.indexOf("-") + 1, name.length());
        StringBuffer buf = new StringBuffer();
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i])) {
                if (i != 0) {
                    buf.append("-");
                }
                buf.append(Character.toLowerCase(chars[i]));
                continue;
            }
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    protected static String convertPrmDefault(String prm) {
        StringBuffer buf = new StringBuffer();
        char[] chars = prm.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i])) {
                if (i != 0) {
                    buf.append("_");
                }
                buf.append(chars[i]);
                continue;
            }
            buf.append(Character.toUpperCase(chars[i]));
        }
        return "DEFAULT_" + buf;
    }

    protected static String getPath(Long key, String val) {
        HostDescription hd = null;
        String clientName = System.getProperty("clientName");
        hd = clientName == null ? TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription() : TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
        String path = EnvHelper.expandEnvVars(val, hd);
        if (!FileUtil.exists(path)) {
            String s = "File " + BasePrms.nameForKey(key) + " not found: " + path;
            throw new HydraConfigException(s);
        }
        return path;
    }

    protected static Class loadClass(String classname) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(classname, true, cl);
        }
        catch (ClassNotFoundException e) {
            String s = "Class not found: " + classname;
            throw new HydraRuntimeException(s);
        }
    }

    protected static String parseMethod(Long key, String val, Class[] argTypes, Class returnType) {
        if (val != null && val.length() != 0) {
            int last = val.lastIndexOf(".");
            String classname = val.substring(0, last);
            Class cls = AbstractDescription.getClass(key, classname);
            String methodname = val.substring(last + 1, val.length());
            Method method = AbstractDescription.getMethod(key, cls, methodname, argTypes, returnType);
        }
        return val;
    }

    protected static SSLDescription getSSLDescription(String str, Long key, TestConfig config) {
        SSLDescription sd = config.getSSLDescription(str);
        if (sd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(SSLPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return sd;
    }
}

