/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import hydra.AbstractDescription;
import hydra.AdminDescription;
import hydra.AdminPrms;
import hydra.AgentPrms;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.SSLDescription;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;

public class AgentDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String adminName;
    private AdminDescription adminDescription;
    private Boolean httpEnabled;
    private Boolean rmiEnabled;
    private Boolean rmiRegistryEnabled;
    private String sslName;
    private SSLDescription sslDescription;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public String getAdminName() {
        return this.adminName;
    }

    private void setAdminName(String str) {
        this.adminName = str;
    }

    protected AdminDescription getAdminDescription() {
        return this.adminDescription;
    }

    private void setAdminDescription(AdminDescription ad) {
        this.adminDescription = ad;
    }

    public Boolean getHttpEnabled() {
        return this.httpEnabled;
    }

    private void setHttpEnabled(Boolean b) {
        this.httpEnabled = b;
    }

    public Boolean getRmiEnabled() {
        return this.rmiEnabled;
    }

    private void setRmiEnabled(Boolean b) {
        this.rmiEnabled = b;
    }

    public Boolean getRmiRegistryEnabled() {
        return this.rmiRegistryEnabled;
    }

    private void setRmiRegistryEnabled(Boolean b) {
        this.rmiRegistryEnabled = b;
    }

    public String getSSLName() {
        return this.sslName;
    }

    private void setSSLName(String str) {
        this.sslName = str;
    }

    private SSLDescription getSSLDescription() {
        return this.sslDescription;
    }

    private void setSSLDescription(SSLDescription sd) {
        this.sslDescription = sd;
    }

    public void configure(AgentConfig a, int port) {
        this.getAdminDescription().configure((DistributedSystemConfig)a);
        a.setAutoConnect(false);
        a.setEmailNotificationEnabled(this.getAdminDescription().getEmailNotificationEnabled().booleanValue());
        a.setEmailNotificationFrom(this.getAdminDescription().getEmailNotificationFrom());
        a.setEmailNotificationHost(this.getAdminDescription().getEmailNotificationHost());
        a.setEmailNotificationToList(this.getAdminDescription().getEmailNotificationToList());
        a.setHttpEnabled(this.getHttpEnabled().booleanValue());
        a.setRmiEnabled(this.getRmiEnabled().booleanValue());
        a.setRmiPort(port);
        a.setRmiRegistryEnabled(this.getRmiRegistryEnabled().booleanValue());
        SSLDescription sd = this.getSSLDescription();
        if (sd != null && sd.getSSLEnabled().booleanValue()) {
            a.setAgentSSLCiphers(sd.getSSLCiphers());
            a.setAgentSSLEnabled(sd.getSSLEnabled().booleanValue());
            a.setAgentSSLProtocols(sd.getSSLProtocols());
            a.setAgentSSLRequireAuth(sd.getSSLRequireAuthentication().booleanValue());
            String s = "gemfire.";
            System.setProperty(s + "ssl-ciphers", sd.getSSLCiphers());
            System.setProperty(s + "ssl-enabled", sd.getSSLEnabled().toString());
            System.setProperty(s + "ssl-protocols", sd.getSSLProtocols());
            System.setProperty(s + "ssl-require-authentication", sd.getSSLRequireAuthentication().toString());
        }
    }

    protected static synchronized String agentToString(AgentConfig a) {
        StringBuffer buf = new StringBuffer();
        buf.append(AdminDescription.adminToString((DistributedSystemConfig)a));
        buf.append("\n  httpEnabled: " + a.isHttpEnabled());
        buf.append("\n  rmiEnabled: " + a.isRmiEnabled());
        buf.append("\n  rmiPort: " + a.getRmiPort());
        buf.append("\n  rmiRegistryEnabled: " + a.isRmiRegistryEnabled());
        buf.append("\n  sslEnabled: " + a.isAgentSSLEnabled());
        buf.append("\n  sslCiphers: " + a.getAgentSSLCiphers());
        buf.append("\n  sslProtocols: " + a.getAgentSSLProtocols());
        buf.append("\n  sslRequireAuthentication: " + a.isAgentSSLRequireAuth());
        buf.append("\n  emailNotificationEnabled: " + a.isEmailNotificationEnabled());
        buf.append("\n  emailNotificationFrom: " + a.getEmailNotificationFrom());
        buf.append("\n  emailNotificationHost: " + a.getEmailNotificationHost());
        buf.append("\n  emailNotificationToList: " + a.isAgentSSLRequireAuth());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "adminName", this.getAdminName());
        map.put(header + "httpEnabled", this.getHttpEnabled());
        map.put(header + "rmiEnabled", this.getRmiEnabled());
        map.put(header + "rmiPort", "autogenerated");
        map.put(header + "rmiRegistryEnabled", this.getRmiRegistryEnabled());
        map.put(header + "sslName", this.getSSLName());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(AgentPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            AgentDescription ad = AgentDescription.createAgentDescription(name, config, i);
            config.addAgentDescription(ad);
        }
    }

    private static AgentDescription createAgentDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        AgentDescription ad = new AgentDescription();
        ad.setName(name);
        Long key = AgentPrms.adminName;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(key) + " is a required field and has no default value";
            throw new HydraConfigException(s);
        }
        ad.setAdminName(str);
        AdminDescription admind = AgentDescription.getAdminDescription(str, key, config);
        ad.setAdminDescription(admind);
        key = AgentPrms.httpEnabled;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        ad.setHttpEnabled(bool);
        key = AgentPrms.rmiEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        ad.setRmiEnabled(bool);
        key = AgentPrms.rmiRegistryEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        ad.setRmiRegistryEnabled(bool);
        key = AdminPrms.sslName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            ad.setSSLName("SSLDescription." + str);
            ad.setSSLDescription(AgentDescription.getSSLDescription(str, key, config));
        }
        return ad;
    }

    private static AdminDescription getAdminDescription(String str, Long key, TestConfig config) {
        AdminDescription admind = config.getAdminDescription(str);
        if (admind == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(AdminPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return admind;
    }
}

