/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.AgentFactory;
import hydra.AgentBlackboard;
import hydra.AgentDescription;
import hydra.AgentPrms;
import hydra.BasePrms;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;

public class AgentHelper {
    private static String TheAgentConfig;
    private static Agent TheAgent;
    private static LogWriter log;

    public static synchronized Agent startConnectedAgent(String agentConfig) {
        Agent agent = AgentHelper.createAgent(agentConfig);
        AgentHelper.startAgent();
        AgentHelper.connectAgent();
        return agent;
    }

    public static synchronized Agent createAgent(String agentConfig) {
        Agent agent = AgentHelper.getAgent();
        if (agent == null) {
            AgentHelper.log("Creating agent from config: " + agentConfig);
            AgentDescription ad = AgentHelper.getAgentDescription(agentConfig);
            AgentHelper.log("Configuring agent from config: " + agentConfig);
            AgentConfig agConfig = AgentFactory.defineAgent();
            String ds = ad.getAdminDescription().getDistributedSystem();
            Endpoint endpoint = AgentHelper.getEndpoint(ds);
            ad.configure(agConfig, endpoint.getPort());
            if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
                String addr = HostHelper.getHostAddress();
                agConfig.setRmiBindAddress(addr);
            }
            AgentHelper.log("Configured agent: " + AgentDescription.agentToString(agConfig));
            try {
                agent = AgentFactory.getAgent((AgentConfig)agConfig);
            }
            catch (AdminException e) {
                String s = "Unable to create agent: " + agentConfig;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
            TheAgent = agent;
            TheAgentConfig = agentConfig;
            AgentHelper.log("Created agent: " + agent);
        } else if (!TheAgentConfig.equals(agentConfig)) {
            String s = "Agent already exists using logical agent configuration named " + TheAgentConfig + ", cannot also use " + agentConfig;
            throw new HydraRuntimeException(s);
        }
        return agent;
    }

    public static synchronized Agent getAgent() {
        return TheAgent;
    }

    public static synchronized Agent startAgent() {
        Agent agent = AgentHelper.getAgent();
        if (agent == null) {
            String s = "Agent has not been created yet";
            throw new HydraRuntimeException(s);
        }
        AgentHelper.log("Starting agent:" + agent);
        agent.start();
        AgentHelper.log("Started agent: " + agent);
        return agent;
    }

    public static synchronized void stopAgent() {
        Agent agent = AgentHelper.getAgent();
        if (agent == null) {
            String s = "Agent has not been created yet";
            throw new HydraRuntimeException(s);
        }
        AgentHelper.log("Stopping agent: " + AgentHelper.agentToString(agent));
        agent.stop();
        AgentHelper.log("Stopped agent: " + AgentHelper.agentToString(agent));
        TheAgentConfig = null;
        TheAgent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Agent connectAgent() {
        Agent agent = AgentHelper.getAgent();
        if (agent == null) {
            String s = "Agent has not been created yet";
            throw new HydraRuntimeException(s);
        }
        AdminDistributedSystem ads = agent.getDistributedSystem();
        if (ads == null) {
            AgentHelper.log("Connecting agent to admin distributed system: " + agent);
            try {
                agent.connectToSystem();
            }
            catch (AdminException e) {
                try {
                    ProcessMgr.logNetworkStatistics();
                }
                finally {
                    String s = "Unable to connect agent: " + agent;
                    throw new HydraRuntimeException(s, (Exception)((Object)e));
                }
            }
            catch (MalformedObjectNameException e) {
                String s = "Unable to connect agent: " + agent;
                throw new HydraRuntimeException(s, e);
            }
            ads = agent.getDistributedSystem();
            AgentHelper.log("Connected agent: " + agent + " to " + DistributedSystemHelper.adminToString(ads));
        }
        return agent;
    }

    public static synchronized void disconnectAgent() {
        Agent agent = AgentHelper.getAgent();
        if (agent == null) {
            String s = "Agent has not been created yet";
            throw new HydraRuntimeException(s);
        }
        if (agent.isConnected()) {
            AgentHelper.log("Disconnecting agent: " + agent);
            agent.disconnectFromSystem();
            AgentHelper.log("Disconnected agent");
        }
    }

    public static String agentToString(Agent agent) {
        if (agent == null) {
            String s = "agent cannot be null";
            throw new IllegalArgumentException(s);
        }
        return AgentDescription.agentToString(agent.getConfig());
    }

    public static AgentDescription getAgentDescription(String agentConfig) {
        if (agentConfig == null) {
            throw new IllegalArgumentException("agentConfig cannot be null");
        }
        AgentHelper.log("Looking up agent config: " + agentConfig);
        AgentDescription ad = TestConfig.getInstance().getAgentDescription(agentConfig);
        if (ad == null) {
            String s = agentConfig + " not found in " + BasePrms.nameForKey(AgentPrms.names);
            throw new HydraRuntimeException(s);
        }
        AgentHelper.log("Looked up agent config:\n" + ad);
        return ad;
    }

    public static synchronized List getEndpoints() {
        return new ArrayList(AgentBlackboard.getInstance().getSharedMap().getMap().values());
    }

    private static synchronized Endpoint getEndpoint(String ds) {
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        Endpoint endpoint = (Endpoint)AgentBlackboard.getInstance().getSharedMap().get(vmid);
        if (endpoint == null) {
            String name = RemoteTestModule.getMyClientName();
            String host = RemoteTestModule.getMyHost();
            String addr = HostHelper.getHostAddress();
            int port = PortHelper.getRandomPort();
            endpoint = new Endpoint(name, vmid, host, addr, port, ds);
            AgentHelper.log("Generated agent endpoint: " + endpoint + " in ds: " + ds);
            AgentBlackboard.getInstance().getSharedMap().put(vmid, endpoint);
            try {
                RemoteTestModule.Master.recordAgent(endpoint);
            }
            catch (RemoteException e) {
                String s = "While recording agent endpoint";
                throw new HydraRuntimeException(s, e);
            }
        }
        return endpoint;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    public static class Endpoint
    implements Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;

        public Endpoint(String name, int vmid, String host, String addr, int port, String ds) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.ds = ds;
            this.id = "vm_" + this.vmid + "_" + this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        public String getHost() {
            return this.host;
        }

        public String getAddr() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddr().equals(this.getAddr()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName() == this.getDistributedSystemName();
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public Properties toProperty() {
            Properties p = new Properties();
            p.setProperty(String.valueOf(this.vmid), this.toString());
            return p;
        }

        public void record() {
            String data = this.id + "," + this.ds + "," + this.host + "," + this.addr + "," + this.port;
            FileUtil.appendToFile("agents.dat", data + "\n");
        }

        public String toString() {
            return "vmid=" + this.vmid + ",name=" + this.name + ",host=" + this.host + ",addr=" + this.addr + ",port=" + this.port + ",ds=" + this.ds;
        }
    }
}

