/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import hydra.AbstractDescription;
import hydra.AsyncEventQueuePrms;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;

public class AsyncEventQueueDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String asyncEventListener;
    private Boolean batchConflationEnabled;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private Gateway.OrderPolicy orderPolicy;
    private Boolean parallel;
    private Boolean persistent;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private String getAsyncEventListener() {
        return this.asyncEventListener;
    }

    private void setAsyncEventListener(String classname) {
        this.asyncEventListener = classname;
    }

    private Boolean getBatchConflationEnabled() {
        return this.batchConflationEnabled;
    }

    private void setBatchConflationEnabled(Boolean bool) {
        this.batchConflationEnabled = bool;
    }

    private Integer getBatchSize() {
        return this.batchSize;
    }

    private void setBatchSize(Integer i) {
        this.batchSize = i;
    }

    private Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    private String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    private Integer getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    private void setDispatcherThreads(Integer i) {
        this.dispatcherThreads = i;
    }

    private Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    private void setMaximumQueueMemory(Integer i) {
        this.maximumQueueMemory = i;
    }

    private Gateway.OrderPolicy getOrderPolicy() {
        return this.orderPolicy;
    }

    private void setOrderPolicy(Gateway.OrderPolicy p) {
        this.orderPolicy = p;
    }

    public Boolean getParallel() {
        return this.parallel;
    }

    private void setParallel(Boolean bool) {
        this.parallel = bool;
    }

    private Boolean getPersistent() {
        return this.persistent;
    }

    private void setPersistent(Boolean bool) {
        this.persistent = bool;
    }

    protected void configure(AsyncEventQueueFactory f) {
        f.setBatchConflationEnabled(this.getBatchConflationEnabled().booleanValue());
        f.setBatchSize(this.getBatchSize().intValue());
        f.setBatchTimeInterval(this.getBatchTimeInterval().intValue());
        if (this.getDiskStoreDescription() != null) {
            f.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        f.setDiskSynchronous(this.getDiskSynchronous().booleanValue());
        f.setDispatcherThreads(this.getDispatcherThreads().intValue());
        f.setMaximumQueueMemory(this.getMaximumQueueMemory().intValue());
        if (this.getOrderPolicy() != null) {
            f.setOrderPolicy(this.getOrderPolicy());
        }
        f.setParallel(this.getParallel().booleanValue());
        f.setPersistent(this.getPersistent().booleanValue());
    }

    protected static synchronized String asyncEventQueueToString(AsyncEventQueue q) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  id: " + q.getId());
        buf.append("\n  asyncEventListener: " + AsyncEventQueueDescription.asyncEventListenerFor(q.getAsyncEventListener()));
        buf.append("\n  batchConflationEnabled: " + q.isBatchConflationEnabled());
        buf.append("\n  batchSize: " + q.getBatchSize());
        buf.append("\n  batchTimeInterval: " + q.getBatchTimeInterval());
        buf.append("\n  diskStoreName: " + q.getDiskStoreName());
        buf.append("\n  diskSynchronous: " + q.isDiskSynchronous());
        buf.append("\n  dispatcherThreads: " + q.getDispatcherThreads());
        buf.append("\n  maximumQueueMemory: " + q.getMaximumQueueMemory());
        buf.append("\n  orderPolicy: " + q.getOrderPolicy());
        buf.append("\n  parallel: " + q.isParallel());
        buf.append("\n  persistent: " + q.isPersistent());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "asyncEventListener", this.getAsyncEventListener());
        map.put(header + "batchConflationEnabled", this.getBatchConflationEnabled());
        map.put(header + "batchSize", this.getBatchSize());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "dispatcherThreads", this.getDispatcherThreads());
        map.put(header + "maximumQueueMemory", this.getMaximumQueueMemory());
        map.put(header + "orderPolicy", this.getOrderPolicy());
        map.put(header + "parallel", this.getParallel());
        map.put(header + "persistent", this.getPersistent());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(AsyncEventQueuePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            AsyncEventQueueDescription aeqd = AsyncEventQueueDescription.createAsyncEventQueueDescription(name, config, i);
            config.addAsyncEventQueueDescription(aeqd);
        }
    }

    private static AsyncEventQueueDescription createAsyncEventQueueDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        AsyncEventQueueDescription aeqd = new AsyncEventQueueDescription();
        aeqd.setName(name);
        Long key = AsyncEventQueuePrms.asyncEventListener;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(AsyncEventQueuePrms.names) + " (" + aeqd.getName() + ") requires a " + BasePrms.nameForKey(AsyncEventQueuePrms.asyncEventListener);
            throw new HydraRuntimeException(s);
        }
        aeqd.setAsyncEventListener(str);
        key = AsyncEventQueuePrms.batchConflationEnabled;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        aeqd.setBatchConflationEnabled(bool);
        key = AsyncEventQueuePrms.batchSize;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        aeqd.setBatchSize(i);
        key = AsyncEventQueuePrms.batchTimeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1000;
        }
        aeqd.setBatchTimeInterval(i);
        key = AsyncEventQueuePrms.diskStoreName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            aeqd.setDiskStoreDescription(AsyncEventQueueDescription.getDiskStoreDescription(str, key, config));
            aeqd.setDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = AsyncEventQueuePrms.diskSynchronous, tab.getWild(key, index, null))) == null) {
            bool = true;
        }
        aeqd.setDiskSynchronous(bool);
        key = AsyncEventQueuePrms.dispatcherThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1;
        }
        aeqd.setDispatcherThreads(i);
        key = AsyncEventQueuePrms.maximumQueueMemory;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        aeqd.setMaximumQueueMemory(i);
        key = AsyncEventQueuePrms.orderPolicy;
        str = tab.getString(key, tab.getWild(key, index, null));
        aeqd.setOrderPolicy(AsyncEventQueueDescription.getOrderPolicy(str, key, aeqd.getDispatcherThreads()));
        key = AsyncEventQueuePrms.parallel;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        aeqd.setParallel(bool);
        key = AsyncEventQueuePrms.persistent;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        aeqd.setPersistent(bool);
        if (aeqd.getDiskStoreName() == null) {
            String s = BasePrms.nameForKey(AsyncEventQueuePrms.names) + " (" + aeqd.getName() + ") requires a " + BasePrms.nameForKey(AsyncEventQueuePrms.diskStoreName);
            throw new HydraRuntimeException(s);
        }
        return aeqd;
    }

    private static String asyncEventListenerFor(AsyncEventListener ael) {
        return ael.getClass().getName();
    }

    protected AsyncEventListener getAsyncEventListenerInstance() {
        String classname = this.getAsyncEventListener();
        if (classname == null) {
            return null;
        }
        Long key = AsyncEventQueuePrms.asyncEventListener;
        try {
            return (AsyncEventListener)AsyncEventQueueDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement AsyncEventListener: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static Gateway.OrderPolicy getOrderPolicy(String str, Long key, int threads) {
        if (str == null) {
            return threads <= 1 ? null : GatewaySender.DEFAULT_ORDER_POLICY;
        }
        if (str.equalsIgnoreCase("key")) {
            return Gateway.OrderPolicy.KEY;
        }
        if (str.equalsIgnoreCase("partition")) {
            return Gateway.OrderPolicy.PARTITION;
        }
        if (str.equalsIgnoreCase("thread")) {
            return Gateway.OrderPolicy.THREAD;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.asyncEventListener = (String)in.readObject();
        this.batchConflationEnabled = (Boolean)in.readObject();
        this.batchSize = (Integer)in.readObject();
        this.batchTimeInterval = (Integer)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskStoreName = (String)in.readObject();
        this.diskSynchronous = (Boolean)in.readObject();
        this.dispatcherThreads = (Integer)in.readObject();
        this.maximumQueueMemory = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.orderPolicy = AsyncEventQueueDescription.getOrderPolicy((String)in.readObject(), AsyncEventQueuePrms.orderPolicy, this.dispatcherThreads);
        this.parallel = (Boolean)in.readObject();
        this.persistent = (Boolean)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.asyncEventListener);
        out.writeObject(this.batchConflationEnabled);
        out.writeObject(this.batchSize);
        out.writeObject(this.batchTimeInterval);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskStoreName);
        out.writeObject(this.diskSynchronous);
        out.writeObject(this.dispatcherThreads);
        out.writeObject(this.maximumQueueMemory);
        out.writeObject(this.name);
        if (this.orderPolicy == null) {
            out.writeObject(this.orderPolicy);
        } else {
            out.writeObject(this.orderPolicy.toString());
        }
        out.writeObject(this.parallel);
        out.writeObject(this.persistent);
    }
}

