/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BootstrapperProxy;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RmiRegistryHelper;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;

public class Bootstrapper {
    public static final String RMI_NAME = "bootstrapper";

    public static void main(String[] args) throws NumberFormatException {
        if (args.length != 1) {
            System.out.println("Usage: hydra.Bootstrapper <port>");
            System.exit(1);
        }
        int port = Integer.valueOf(args[0]);
        int pid = ProcessMgr.getProcessId();
        Log.createLogWriter(RMI_NAME, "bootstrapper_" + port + "_" + pid, "all", false);
        Bootstrapper.bootstrap(port);
    }

    private static void bootstrap(int port) {
        BootstrapperProxy bootstrapper;
        Log.getLogWriter().info("Starting the bootstrapper.");
        Registry registry = RmiRegistryHelper.startRegistry(RMI_NAME, port);
        Log.getLogWriter().info("Creating the bootstrapper proxy");
        try {
            bootstrapper = new BootstrapperProxy();
        }
        catch (RemoteException e) {
            String s = "Bootstrapper proxy could not be created";
            throw new HydraRuntimeException(s, e);
        }
        Log.getLogWriter().info("Registering the bootstrapper proxy");
        RmiRegistryHelper.bind(registry, RMI_NAME, bootstrapper);
        Log.getLogWriter().info("Ready to roll");
    }
}

