/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.pdx.PdxSerializer;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.CachePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.ResourceManagerDescription;
import hydra.ResourceManagerPrms;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class CacheDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean copyOnRead;
    private String gatewayConflictResolver;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private DiskStoreDescription pdxDiskStoreDescription;
    private String pdxDiskStoreName;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private String pdxSerializerClass;
    private String pdxSerializerMethod;
    private ResourceManagerDescription resourceManagerDescription;
    private String resourceManagerDescriptionName;
    private Integer searchTimeout;
    private transient GatewayConflictResolver gatewayConflictResolverInstance;
    private transient PdxSerializer pdxSerializerInstance;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    private void setCopyOnRead(Boolean bool) {
        this.copyOnRead = bool;
    }

    private String getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    private void setGatewayConflictResolver(String str) {
        this.gatewayConflictResolver = str;
    }

    private synchronized GatewayConflictResolver getGatewayConflictResolverInstance() {
        if (this.gatewayConflictResolverInstance == null) {
            this.gatewayConflictResolverInstance = this.createGatewayConflictResolverInstance();
        }
        return this.gatewayConflictResolverInstance;
    }

    private Integer getLockLease() {
        return this.lockLease;
    }

    private void setLockLease(Integer i) {
        this.lockLease = i;
    }

    private Integer getLockTimeout() {
        return this.lockTimeout;
    }

    private void setLockTimeout(Integer i) {
        this.lockTimeout = i;
    }

    private Integer getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    private void setMessageSyncInterval(Integer i) {
        this.messageSyncInterval = i;
    }

    private String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    private void setPdxDiskStoreName(String str) {
        this.pdxDiskStoreName = str;
    }

    public DiskStoreDescription getPdxDiskStoreDescription() {
        return this.pdxDiskStoreDescription;
    }

    private void setPdxDiskStoreDescription(DiskStoreDescription dsd) {
        this.pdxDiskStoreDescription = dsd;
    }

    private Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    private void setPdxIgnoreUnreadFields(Boolean bool) {
        this.pdxIgnoreUnreadFields = bool;
    }

    private Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    private void setPdxPersistent(Boolean bool) {
        this.pdxPersistent = bool;
    }

    private Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    private void setPdxReadSerialized(Boolean bool) {
        this.pdxReadSerialized = bool;
    }

    private String getPdxSerializerClass() {
        return this.pdxSerializerClass;
    }

    private void setPdxSerializerClass(String str) {
        this.pdxSerializerClass = str;
    }

    private String getPdxSerializerMethod() {
        return this.pdxSerializerMethod;
    }

    private void setPdxSerializerMethod(String str) {
        this.pdxSerializerMethod = str;
    }

    private synchronized PdxSerializer getPdxSerializerInstance() {
        if (this.pdxSerializerInstance == null) {
            this.pdxSerializerInstance = this.createPdxSerializerInstance();
        }
        return this.pdxSerializerInstance;
    }

    private String getResourceManagerDescriptionName() {
        return this.resourceManagerDescriptionName;
    }

    private void setResourceManagerDescriptionName(String str) {
        this.resourceManagerDescriptionName = str;
    }

    protected ResourceManagerDescription getResourceManagerDescription() {
        return this.resourceManagerDescription;
    }

    private void setResourceManagerDescription(ResourceManagerDescription rmd) {
        this.resourceManagerDescription = rmd;
    }

    private Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    private void setSearchTimeout(Integer i) {
        this.searchTimeout = i;
    }

    public void configure(CacheFactory f) {
        if (this.getPdxDiskStoreDescription() != null) {
            f.setPdxDiskStore(this.getPdxDiskStoreDescription().getName());
        }
        f.setPdxIgnoreUnreadFields(this.getPdxIgnoreUnreadFields().booleanValue());
        f.setPdxPersistent(this.getPdxPersistent().booleanValue());
        f.setPdxReadSerialized(this.getPdxReadSerialized().booleanValue());
        if (this.getPdxSerializerClass() != null) {
            f.setPdxSerializer(this.getPdxSerializerInstance());
        }
    }

    public void configure(Cache c) {
        c.setCopyOnRead(this.getCopyOnRead().booleanValue());
        if (this.getGatewayConflictResolver() != null) {
            c.setGatewayConflictResolver(this.getGatewayConflictResolverInstance());
        }
        c.setLockLease(this.getLockLease().intValue());
        c.setLockTimeout(this.getLockTimeout().intValue());
        c.setMessageSyncInterval(this.getMessageSyncInterval().intValue());
        if (this.getResourceManagerDescription() != null) {
            this.getResourceManagerDescription().configure(c.getResourceManager());
        }
        c.setSearchTimeout(this.getSearchTimeout().intValue());
    }

    public void configureDummy(CacheCreation c) {
        this.configure((Cache)c);
        if (this.getPdxDiskStoreDescription() != null) {
            c.setPdxDiskStore(this.getPdxDiskStoreDescription().getName());
        }
        c.setPdxIgnoreUnreadFields(this.getPdxIgnoreUnreadFields().booleanValue());
        c.setPdxPersistent(this.getPdxPersistent().booleanValue());
        c.setPdxReadSerialized(this.getPdxReadSerialized().booleanValue());
        if (this.getPdxSerializerClass() != null) {
            c.setPdxSerializer(this.getPdxSerializerInstance());
        }
    }

    protected static synchronized String cacheToString(Cache c) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  copyOnRead: " + c.getCopyOnRead());
        buf.append("\n  gatewayConflictResolver: " + c.getGatewayConflictResolver());
        buf.append("\n  lockLease: " + c.getLockLease());
        buf.append("\n  lockTimeout: " + c.getLockTimeout());
        buf.append("\n  messageSyncInterval: " + c.getMessageSyncInterval());
        buf.append("\n  pdxDiskStoreName: " + c.getPdxDiskStore());
        buf.append("\n  pdxIgnoreUnreadFields: " + c.getPdxIgnoreUnreadFields());
        buf.append("\n  pdxPersistent: " + c.getPdxPersistent());
        buf.append("\n  pdxReadSerialized: " + c.getPdxReadSerialized());
        buf.append("\n  pdxSerializer: " + c.getPdxSerializer());
        buf.append("\n  resourceManager: " + c.getResourceManager());
        buf.append("\n  searchTimeout: " + c.getSearchTimeout());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "copyOnRead", this.getCopyOnRead());
        map.put(header + "gatewayConflictResolver", this.getGatewayConflictResolver());
        map.put(header + "lockLease", this.getLockLease());
        map.put(header + "lockTimeout", this.getLockTimeout());
        map.put(header + "messageSyncInterval", this.getMessageSyncInterval());
        map.put(header + "pdxDiskStoreName", this.getPdxDiskStoreName());
        map.put(header + "pdxIgnoreUnreadFields", this.getPdxIgnoreUnreadFields());
        map.put(header + "pdxPersistent", this.getPdxPersistent());
        map.put(header + "pdxReadSerialized", this.getPdxReadSerialized());
        map.put(header + "pdxSerializer", this.getPdxSerializerClass() + "." + this.getPdxSerializerMethod());
        map.put(header + "resourceManagerName", this.getResourceManagerDescriptionName());
        map.put(header + "searchTimeout", this.getSearchTimeout());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(CachePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            CacheDescription cd = CacheDescription.createCacheDescription(name, config, i);
            config.addCacheDescription(cd);
        }
    }

    private static CacheDescription createCacheDescription(String name, TestConfig config, int index) {
        Integer i;
        ConfigHashtable tab = config.getParameters();
        CacheDescription cd = new CacheDescription();
        cd.setName(name);
        Long key = CachePrms.copyOnRead;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            cd.setCopyOnRead(false);
        } else {
            cd.setCopyOnRead(bool);
        }
        key = CachePrms.gatewayConflictResolver;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            cd.setGatewayConflictResolver(str);
        }
        if ((i = tab.getInteger(key = CachePrms.lockLease, tab.getWild(key, index, null))) == null) {
            cd.setLockLease(new Integer(GemFireCacheImpl.DEFAULT_LOCK_LEASE));
        } else {
            cd.setLockLease(i);
        }
        key = CachePrms.lockTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            cd.setLockTimeout(new Integer(GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT));
        } else {
            cd.setLockTimeout(i);
        }
        key = CachePrms.messageSyncInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            cd.setMessageSyncInterval(new Integer(1));
        } else {
            cd.setMessageSyncInterval(i);
        }
        key = CachePrms.pdxDiskStoreName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            cd.setPdxDiskStoreDescription(CacheDescription.getPdxDiskStoreDescription(str, key, config));
            cd.setPdxDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = CachePrms.pdxIgnoreUnreadFields, tab.getWild(key, index, null))) == null) {
            cd.setPdxIgnoreUnreadFields(CacheConfig.DEFAULT_PDX_IGNORE_UNREAD_FIELDS);
        } else {
            cd.setPdxIgnoreUnreadFields(bool);
        }
        key = CachePrms.pdxPersistent;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            cd.setPdxPersistent(CacheConfig.DEFAULT_PDX_PERSISTENT);
        } else {
            cd.setPdxPersistent(bool);
        }
        key = CachePrms.pdxReadSerialized;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            cd.setPdxReadSerialized(CacheConfig.DEFAULT_PDX_READ_SERIALIZED);
        } else {
            cd.setPdxReadSerialized(bool);
        }
        key = CachePrms.pdxSerializerInstantiator;
        HydraVector strs = tab.vecAtWild(key, index, null);
        cd.setPdxSerializerClass(CacheDescription.getPdxSerializerClass(strs, key));
        cd.setPdxSerializerMethod(CacheDescription.getPdxSerializerMethod(strs, key));
        key = CachePrms.resourceManagerName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            cd.setResourceManagerDescription(CacheDescription.getResourceManagerDescription(str, key, config));
            cd.setResourceManagerDescriptionName("ResourceManagerDescription." + str);
        }
        if ((i = tab.getInteger(key = CachePrms.searchTimeout, tab.getWild(key, index, null))) == null) {
            cd.setSearchTimeout(new Integer(GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT));
        } else {
            cd.setSearchTimeout(i);
        }
        return cd;
    }

    private GatewayConflictResolver createGatewayConflictResolverInstance() {
        String classname = this.getGatewayConflictResolver();
        if (classname == null) {
            return null;
        }
        Long key = CachePrms.gatewayConflictResolver;
        try {
            return (GatewayConflictResolver)CacheDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement GatewayConflictResolver: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static DiskStoreDescription getPdxDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static String getPdxSerializerClass(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return null;
        }
        if (strs.size() == 2) {
            return (String)strs.get(0);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static String getPdxSerializerMethod(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return null;
        }
        if (strs.size() == 2) {
            return (String)strs.get(1);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private PdxSerializer createPdxSerializerInstance() {
        String methodname;
        Long key = CachePrms.pdxSerializerInstantiator;
        String classname = this.getPdxSerializerClass();
        MethExecutorResult result = MethExecutor.execute(classname, methodname = this.getPdxSerializerMethod());
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        Object obj = result.getResult();
        Log.getLogWriter().info("Instantiated  " + obj);
        try {
            return (PdxSerializer)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + "=" + this.getPdxSerializerClass() + "." + this.getPdxSerializerMethod() + " returned an instance of " + obj.getClass().getName() + " instead of a PdxSerializer";
            throw new HydraConfigException(s);
        }
    }

    private static ResourceManagerDescription getResourceManagerDescription(String str, Long key, TestConfig config) {
        ResourceManagerDescription rmd = config.getResourceManagerDescription(str);
        if (rmd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(ResourceManagerPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return rmd;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.copyOnRead = (Boolean)in.readObject();
        this.gatewayConflictResolver = (String)in.readObject();
        this.lockLease = (Integer)in.readObject();
        this.lockTimeout = (Integer)in.readObject();
        this.messageSyncInterval = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.pdxDiskStoreName = (String)in.readObject();
        this.pdxDiskStoreDescription = (DiskStoreDescription)in.readObject();
        this.pdxIgnoreUnreadFields = (Boolean)in.readObject();
        this.pdxPersistent = (Boolean)in.readObject();
        this.pdxReadSerialized = (Boolean)in.readObject();
        this.pdxSerializerClass = (String)in.readObject();
        this.pdxSerializerMethod = (String)in.readObject();
        this.resourceManagerDescription = (ResourceManagerDescription)in.readObject();
        this.resourceManagerDescriptionName = (String)in.readObject();
        this.searchTimeout = (Integer)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.copyOnRead);
        out.writeObject(this.gatewayConflictResolver);
        out.writeObject(this.lockLease);
        out.writeObject(this.lockTimeout);
        out.writeObject(this.messageSyncInterval);
        out.writeObject(this.name);
        out.writeObject(this.pdxDiskStoreName);
        out.writeObject(this.pdxDiskStoreDescription);
        out.writeObject(this.pdxIgnoreUnreadFields);
        out.writeObject(this.pdxPersistent);
        out.writeObject(this.pdxReadSerialized);
        out.writeObject(this.pdxSerializerClass);
        out.writeObject(this.pdxSerializerMethod);
        out.writeObject(this.resourceManagerDescription);
        out.writeObject(this.resourceManagerDescriptionName);
        out.writeObject(this.searchTimeout);
    }
}

