/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.xmlcache.BridgeServerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import com.gemstone.gemfire.internal.cache.xmlcache.FunctionServiceCreation;
import hydra.BasePrms;
import hydra.BridgeDescription;
import hydra.BridgeHelper;
import hydra.CacheDescription;
import hydra.CachePrms;
import hydra.CacheVersionHelper;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GatewayDescription;
import hydra.GatewayHelper;
import hydra.GatewayHubDescription;
import hydra.GatewayHubHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.PortHelper;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheHelper {
    public static String CACHE_SERVER_PORT_TAG = "%CACHE_SERVER_PORT%";
    protected static String TheCacheConfig;
    private static Map XmlCacheConfigs;
    private static Map XmlGatewayHubConfigs;
    private static Map XmlGatewayConfigs;
    private static Map XmlRegionConfigs;
    private static Map XmlBridgeConfigs;
    private static Map XmlPoolConfigs;
    private static Map XmlFunctionConfigs;
    private static Map XmlDiskStoreConfigs;
    private static Map XmlGatewaySenderConfigs;
    private static Map XmlGatewayReceiverConfigs;
    private static Map XmlAsyncEventQueueConfigs;
    private static LogWriter log;

    public static synchronized Cache createCache(String cacheConfig) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            CacheDescription cd = CacheHelper.getCacheDescription(cacheConfig);
            DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
            if (ds == null) {
                ds = DistributedSystemHelper.connect();
            }
            try {
                cache = CacheVersionHelper.configureAndCreateCache(cacheConfig, cd, ds);
            }
            catch (CacheException e) {
                String s = "Unable to create cache using: " + ds;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
            CacheHelper.log("Configuring cache from config: " + cacheConfig);
            cd.configure(cache);
            CacheHelper.log("Configured cache: " + CacheHelper.cacheToString(cache));
            TheCacheConfig = cacheConfig;
        } else {
            if (TheCacheConfig == null) {
                String s = "Cache was already created without CacheHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheCacheConfig.equals(cacheConfig)) {
                String s = "Cache already exists using cache configuration " + TheCacheConfig + ", cannot also use " + cacheConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return cache;
    }

    public static synchronized Cache createCacheFromXml(String cacheXmlFile) {
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                String text = FileUtil.getText(fn);
                if (text.indexOf(CACHE_SERVER_PORT_TAG) != -1) {
                    int port = PortHelper.getRandomPort();
                    String txt = FileUtil.getText(fn);
                    txt = txt.replaceAll(CACHE_SERVER_PORT_TAG, String.valueOf(port));
                    fn = System.getProperty("user.dir") + File.separator + new File(fn).getName();
                    FileUtil.writeToFile(fn, txt);
                    CacheHelper.log("Switching to cache XML file: " + fn + " with autogenerated bridge server port: " + port);
                    FileInputStream fis = new FileInputStream(new File(fn));
                    CacheXmlParser parser = CacheXmlParser.parse((InputStream)fis);
                    CacheCreation dummyCache = parser.getCacheCreation();
                    List dummyCacheServers = dummyCache.getBridgeServers();
                    if (dummyCacheServers != null) {
                        if (dummyCacheServers.size() > 1) {
                            String s = "Multiple bridge servers in single JVM not supported";
                            throw new UnsupportedOperationException();
                        }
                        for (BridgeServerCreation dummyCacheServer : dummyCacheServers) {
                            String[] groups = dummyCacheServer.getGroups();
                            port = dummyCacheServer.getPort();
                            BridgeHelper.getEndpoint(port, groups);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new HydraRuntimeException(fn, e);
            }
            DistributedSystem ds = DistributedSystemHelper.connectWithXml(fn);
            CacheHelper.log("Creating cache from XML: " + fn);
            try {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
            catch (CacheException e) {
                String s = "Unable to create cache using: " + ds;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
            CacheHelper.log("Created cache from XML");
            TheCacheConfig = fn;
        } else {
            if (TheCacheConfig == null) {
                String s = "Cache was already created without CacheHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheCacheConfig.equals(fn)) {
                String s = "Cache already exists using cache configuration " + TheCacheConfig + ", cannot also use " + fn;
                throw new HydraRuntimeException(s);
            }
        }
        return cache;
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, null, null, null, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, List regionNames, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, regionNames, null, null, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, String bridgeConfig, String poolConfig, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, null, bridgeConfig, poolConfig, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, List regionNames, String bridgeConfig, String poolConfig, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, regionNames, bridgeConfig, poolConfig, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String regionConfig, List regionNames, String bridgeConfig, String poolConfig, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, dynamicRegionConfig, regionConfig, regionNames, bridgeConfig, poolConfig, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String regionConfig, List regionNames, String bridgeConfig, String poolConfig, String diskStoreConfig, List functions, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFile(cacheConfig, dynamicRegionConfig, regionConfig, regionNames, bridgeConfig, poolConfig, diskStoreConfig, null, null, null, functions, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String regionConfig, List regionNames, String bridgeConfig, String poolConfig, String diskStoreConfig, String gatewaySenderConfig, String gatewayReceiverConfig, String asyncEventQueueConfig, List functions, String cacheXmlFile) {
        CacheCreation dummyCache;
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        if (!FileUtil.exists(fn)) {
            StringBuilder buf = new StringBuilder("Generating XML file: ").append(fn).append(" from");
            if (cacheConfig != null) {
                buf.append("\ncache config: " + cacheConfig);
            }
            if (dynamicRegionConfig != null) {
                buf.append("\ndynamic region config: " + dynamicRegionConfig);
            }
            if (regionConfig != null) {
                buf.append("\nregion config: " + regionConfig);
            }
            if (regionNames != null) {
                buf.append("\nregion names: " + regionNames);
            }
            if (bridgeConfig != null) {
                buf.append("\nbridge config: " + bridgeConfig);
            }
            if (poolConfig != null) {
                buf.append("\npool config: " + poolConfig);
            }
            if (diskStoreConfig != null) {
                buf.append("\ndisk store config: " + diskStoreConfig);
            }
            if (gatewaySenderConfig != null) {
                buf.append("\ngateway sender config: " + gatewaySenderConfig);
            }
            if (gatewayReceiverConfig != null) {
                buf.append("\ngateway receiver config: " + gatewayReceiverConfig);
            }
            if (asyncEventQueueConfig != null) {
                buf.append("\nasync event queue config: " + asyncEventQueueConfig);
            }
            if (functions != null) {
                buf.append("\nfunctions: " + functions);
            }
            CacheHelper.log(buf.toString());
            dummyCache = CacheHelper.generateDummyCache(cacheConfig, dynamicRegionConfig, fn);
            CacheHelper.generateDummyFunctions((Cache)dummyCache, functions, fn);
            CacheHelper.generateDummyPool((Cache)dummyCache, poolConfig, fn);
            CacheHelper.generateDummyDiskStore((Cache)dummyCache, diskStoreConfig, fn);
            CacheHelper.generateDummyGatewaySender((Cache)dummyCache, gatewaySenderConfig, fn);
            CacheHelper.generateDummyGatewayReceiver((Cache)dummyCache, gatewayReceiverConfig, fn);
            CacheHelper.generateDummyAsyncEventQueue((Cache)dummyCache, asyncEventQueueConfig, fn);
            CacheHelper.generateDummyBridge((Cache)dummyCache, bridgeConfig, fn);
            if (regionNames != null && regionNames.size() > 0) {
                for (String regionName : regionNames) {
                    CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, regionName, fn);
                }
            } else {
                CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, null, fn);
            }
        } else {
            if (XmlCacheConfigs.get(fn) == null) {
                String s = "Cache XML file was already created without CacheHelper or from a different VM using an unknown, and possibly different, configuration: " + fn;
                throw new HydraRuntimeException(s);
            }
            String cc = (String)XmlCacheConfigs.get(fn);
            if (!cc.equals(cacheConfig)) {
                String s = "Cache XML file already exists using cache configuration " + cc + ", cannot also use " + cacheConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String rc = (String)XmlRegionConfigs.get(fn);
            if (rc == null && regionConfig != null || rc != null && regionConfig == null || rc != null && regionConfig != null && !rc.equals(regionConfig)) {
                String s = "Cache XML file already exists using region configuration " + rc + ", cannot also use " + regionConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String bc = (String)XmlBridgeConfigs.get(fn);
            if (bc == null && bridgeConfig != null || bc != null && bridgeConfig == null || bc != null && bridgeConfig != null && !bc.equals(bridgeConfig)) {
                String s = "Cache XML file already exists using bridge configuration " + bc + ", cannot also use " + bridgeConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String cpc = (String)XmlPoolConfigs.get(fn);
            if (cpc == null && poolConfig != null || cpc != null && poolConfig == null || cpc != null && poolConfig != null && !cpc.equals(poolConfig)) {
                String s = "Cache XML file already exists using pool configuration " + cpc + ", cannot also use " + poolConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String dsc = (String)XmlDiskStoreConfigs.get(fn);
            if (dsc == null && diskStoreConfig != null || dsc != null && diskStoreConfig == null || dsc != null && diskStoreConfig != null && !dsc.equals(diskStoreConfig)) {
                String s = "Cache XML file already exists using disk store configuration " + dsc + ", cannot also use " + diskStoreConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String c = (String)XmlGatewaySenderConfigs.get(fn);
            if (c == null && gatewaySenderConfig != null || c != null && gatewaySenderConfig == null || c != null && gatewaySenderConfig != null && !c.equals(gatewaySenderConfig)) {
                String s = "Cache XML file already exists using gateway sender configuration " + c + ", cannot also use " + gatewaySenderConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            c = (String)XmlGatewayReceiverConfigs.get(fn);
            if (c == null && gatewayReceiverConfig != null || c != null && gatewayReceiverConfig == null || c != null && gatewayReceiverConfig != null && !c.equals(gatewayReceiverConfig)) {
                String s = "Cache XML file already exists using gateway receiver configuration " + c + ", cannot also use " + gatewayReceiverConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            c = (String)XmlAsyncEventQueueConfigs.get(fn);
            if (c == null && asyncEventQueueConfig != null || c != null && asyncEventQueueConfig == null || c != null && asyncEventQueueConfig != null && !c.equals(asyncEventQueueConfig)) {
                String s = "Cache XML file already exists using async event queue configuration " + c + ", cannot also use " + asyncEventQueueConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            List fc = (List)XmlFunctionConfigs.get(fn);
            List functionNames = CacheHelper.classnamesFor(functions);
            if (fc == null && functionNames != null || fc != null && functionNames == null || fc != null && functionNames != null && (!fc.containsAll(functionNames) || !functionNames.containsAll(fc))) {
                String s = "Cache XML file already exists using functions " + fc + ", cannot also use " + functions + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            return;
        }
        CacheHelper.generateCacheXmlFile(fn, (Cache)dummyCache);
    }

    public static synchronized Cache startCacheXmlGenerationForGateway(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String gatewayHubConfig, String cacheXmlFile) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        if (gatewayHubConfig == null) {
            throw new IllegalArgumentException("gatewayHubConfig cannot be null");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        CacheCreation dummyCache = CacheHelper.generateDummyCache(cacheConfig, dynamicRegionConfig, fn);
        CacheHelper.generateDummyGatewayHub((Cache)dummyCache, gatewayHubConfig, fn);
        return dummyCache;
    }

    public static synchronized void finishCacheXmlGenerationForGateway(Cache cache, String cacheConfig, String gatewayHubConfig, String gatewayConfig, String regionConfig, List regionNames, String bridgeConfig, String poolConfig, String diskStoreConfig, List functions, String cacheXmlFile) {
        CacheCreation dummyCache;
        if (!(cache instanceof CacheCreation)) {
            throw new IllegalArgumentException("cache must be a CacheCreation object");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        if (!FileUtil.exists(fn)) {
            CacheHelper.log("Generating XML file: " + fn + " from gateway config: " + gatewayConfig + " and region config " + regionConfig + " and bridge config " + bridgeConfig + " and pool config " + poolConfig);
            dummyCache = (CacheCreation)cache;
            CacheHelper.generateDummyGateways((Cache)dummyCache, gatewayConfig, fn);
            CacheHelper.generateDummyFunctions((Cache)dummyCache, functions, fn);
            CacheHelper.generateDummyPool((Cache)dummyCache, poolConfig, fn);
            CacheHelper.generateDummyDiskStore((Cache)dummyCache, diskStoreConfig, fn);
            CacheHelper.generateDummyBridge((Cache)dummyCache, bridgeConfig, fn);
            if (regionNames != null && regionNames.size() > 0) {
                for (String regionName : regionNames) {
                    CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, regionName, fn);
                }
            } else {
                CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, null, fn);
            }
        } else {
            if (XmlCacheConfigs.get(fn) == null) {
                String s = "Cache XML file was already created without CacheHelper or from a different VM using an unknown, and possibly different, configuration: " + fn;
                throw new HydraRuntimeException(s);
            }
            String cc = (String)XmlCacheConfigs.get(fn);
            if (!cc.equals(cacheConfig)) {
                String s = "Cache XML file already exists using cache configuration " + cc + ", cannot also use " + cacheConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String ghc = (String)XmlGatewayHubConfigs.get(fn);
            if (ghc == null && gatewayHubConfig != null || ghc != null && gatewayHubConfig == null || ghc != null && gatewayHubConfig != null && !ghc.equals(gatewayHubConfig)) {
                String s = "Cache XML file already exists using gatewayHub configuration " + ghc + ", cannot also use " + gatewayHubConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String gc = (String)XmlGatewayConfigs.get(fn);
            if (gc == null && gatewayConfig != null || gc != null && gatewayConfig == null || gc != null && gatewayConfig != null && !gc.equals(gatewayConfig)) {
                String s = "Cache XML file already exists using gateway configuration " + gc + ", cannot also use " + gatewayConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String rc = (String)XmlRegionConfigs.get(fn);
            if (rc == null && regionConfig != null || rc != null && regionConfig == null || rc != null && regionConfig != null && !rc.equals(regionConfig)) {
                String s = "Cache XML file already exists using region configuration " + rc + ", cannot also use " + regionConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String bc = (String)XmlBridgeConfigs.get(fn);
            if (bc == null && bridgeConfig != null || bc != null && bridgeConfig == null || bc != null && bridgeConfig != null && !bc.equals(bridgeConfig)) {
                String s = "Cache XML file already exists using bridge configuration " + bc + ", cannot also use " + bridgeConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String cpc = (String)XmlPoolConfigs.get(fn);
            if (cpc == null && poolConfig != null || cpc != null && poolConfig == null || cpc != null && poolConfig != null && !cpc.equals(poolConfig)) {
                String s = "Cache XML file already exists using pool configuration " + cpc + ", cannot also use " + poolConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String dsc = (String)XmlDiskStoreConfigs.get(fn);
            if (dsc == null && diskStoreConfig != null || dsc != null && diskStoreConfig == null || dsc != null && diskStoreConfig != null && !dsc.equals(diskStoreConfig)) {
                String s = "Cache XML file already exists using disk store configuration " + dsc + ", cannot also use " + diskStoreConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            List fc = (List)XmlFunctionConfigs.get(fn);
            List functionNames = CacheHelper.classnamesFor(functions);
            if (fc == null && functionNames != null || fc != null && functionNames == null || fc != null && functionNames != null && (!fc.containsAll(functionNames) || !functionNames.containsAll(fc))) {
                String s = "Cache XML file already exists using functions " + fc + ", cannot also use " + functions + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            return;
        }
        CacheHelper.generateCacheXmlFile(fn, (Cache)dummyCache);
    }

    public static synchronized void generateCacheXmlFileNoCheck(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, List regionConfigs, List regionNames, String bridgeConfig, List poolConfigs, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFileNoCheck(cacheConfig, dynamicRegionConfig, regionConfigs, regionNames, bridgeConfig, poolConfigs, null, null, null, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFileNoCheck(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, List regionConfigs, List regionNames, String bridgeConfig, List poolConfigs, List diskStoreConfigs, List functions, String cacheXmlFile) {
        CacheHelper.generateCacheXmlFileNoCheck(cacheConfig, dynamicRegionConfig, regionConfigs, regionNames, bridgeConfig, poolConfigs, diskStoreConfigs, null, null, null, functions, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFileNoCheck(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, List regionConfigs, List regionNames, String bridgeConfig, List poolConfigs, List diskStoreConfigs, String gatewaySenderConfig, String gatewayReceiverConfig, String asyncEventQueueConfig, List functions, String cacheXmlFile) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        CacheHelper.log("Generating XML file: " + fn + " from cache config: " + cacheConfig + " and region configs " + regionConfigs + " and bridge config " + bridgeConfig + " and pool configs " + poolConfigs);
        if (FileUtil.exists(fn)) {
            CacheHelper.log("Overwriting XML file: " + fn + " with possibly different configuration");
        }
        CacheCreation dummyCache = CacheHelper.generateDummyCache(cacheConfig, dynamicRegionConfig, fn);
        if (poolConfigs != null) {
            for (String poolConfig : poolConfigs) {
                CacheHelper.generateDummyPool((Cache)dummyCache, poolConfig, fn);
            }
        }
        if (diskStoreConfigs != null) {
            for (String diskStoreConfig : diskStoreConfigs) {
                CacheHelper.generateDummyDiskStore((Cache)dummyCache, diskStoreConfig, fn);
            }
        }
        if (gatewaySenderConfig != null) {
            CacheHelper.generateDummyGatewaySender((Cache)dummyCache, gatewaySenderConfig, fn);
        }
        if (gatewayReceiverConfig != null) {
            CacheHelper.generateDummyGatewayReceiver((Cache)dummyCache, gatewayReceiverConfig, fn);
        }
        if (asyncEventQueueConfig != null) {
            CacheHelper.generateDummyAsyncEventQueue((Cache)dummyCache, asyncEventQueueConfig, fn);
        }
        CacheHelper.generateDummyFunctions((Cache)dummyCache, functions, fn);
        CacheHelper.generateDummyBridge((Cache)dummyCache, bridgeConfig, fn);
        if (regionNames != null && regionNames.size() > 0) {
            if (regionConfigs == null || regionConfigs.size() != regionNames.size()) {
                String s = "Number of regionConfigs (" + regionConfigs + ") != number of regionNames (" + regionNames + ")";
                throw new HydraRuntimeException(s);
            }
            for (int i = 0; i < regionConfigs.size(); ++i) {
                String regionConfig = (String)regionConfigs.get(i);
                String regionName = (String)regionNames.get(i);
                CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, regionName, fn);
            }
        } else {
            for (String regionConfig : regionConfigs) {
                CacheHelper.generateDummyRegion((Cache)dummyCache, regionConfig, null, fn);
            }
        }
        CacheHelper.generateCacheXmlFile(fn, (Cache)dummyCache);
    }

    private static CacheCreation generateDummyCache(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String fn) {
        if (dynamicRegionConfig != null) {
            CacheHelper.log("Opening the configured DynamicRegionFactory");
            DynamicRegionFactory.get().open(dynamicRegionConfig);
        }
        CacheHelper.log("Creating dummy cache from config: " + cacheConfig);
        CacheDescription cd = CacheHelper.getCacheDescription(cacheConfig);
        CacheCreation dummyCache = new CacheCreation();
        CacheVersionHelper.generateDummyResourceManager(cd, dummyCache);
        cd.configureDummy(dummyCache);
        if (dynamicRegionConfig != null) {
            dummyCache.setDynamicRegionFactoryConfig(dynamicRegionConfig);
        }
        XmlCacheConfigs.put(fn, cacheConfig);
        CacheHelper.log("Created dummy cache: " + CacheHelper.cacheToString((Cache)dummyCache));
        return dummyCache;
    }

    private static void generateDummyGatewayHub(Cache dummyCache, String gatewayHubConfig, String fn) {
        if (gatewayHubConfig != null) {
            CacheHelper.log("Adding dummy gateway hub from config: " + gatewayHubConfig);
            GatewayHubDescription ghd = GatewayHubHelper.getGatewayHubDescription(gatewayHubConfig);
            String id = GatewayHubHelper.getId(ghd);
            int port = GatewayHubHelper.getPort(ghd, id);
            GatewayHub dummyGatewayHub = dummyCache.addGatewayHub(id, port);
            ghd.configure(dummyGatewayHub);
            CacheHelper.log("Added dummy gateway hub: " + GatewayHubHelper.gatewayHubToString(dummyGatewayHub));
            XmlGatewayHubConfigs.put(fn, gatewayHubConfig);
        }
    }

    private static void generateDummyGateways(Cache dummyCache, String gatewayConfig, String fn) {
        for (GatewayHub dummyGatewayHub : dummyCache.getGatewayHubs()) {
            GatewayDescription gd = GatewayHelper.getGatewayDescription(gatewayConfig);
            List endpoints = GatewayHubHelper.getEndpoints();
            String ownds = DistributedSystemHelper.getDistributedSystemName();
            Set dsnames = GatewayHubHelper.getDistributedSystemNames(endpoints);
            for (String dsname : dsnames) {
                if (dsname.equals(ownds)) continue;
                int vmid = RemoteTestModule.getMyVmid();
                String gid = dsname;
                CacheHelper.log("Configuring gateway with id: " + gid);
                CacheHelper.log("Adding dummy gateway from config: " + gatewayConfig);
                Gateway dummyGateway = dummyGatewayHub.addGateway(gid);
                gd.configure(dummyGateway, dsname, endpoints, true);
                XmlGatewayConfigs.put(fn, gatewayConfig);
                CacheHelper.log("Configured gateway: " + GatewayHelper.gatewayToString(dummyGateway));
            }
        }
    }

    private static void generateDummyPool(Cache dummyCache, String poolConfig, String fn) {
        if (poolConfig != null) {
            CacheHelper.log("Adding dummy pool from config: " + poolConfig);
            PoolDescription pd = PoolHelper.getPoolDescription(poolConfig);
            PoolFactory dummyFactory = ((CacheCreation)dummyCache).createPoolFactory();
            pd.configure(dummyFactory);
            String poolName = pd.getName();
            Pool dummyPool = null;
            try {
                dummyPool = dummyFactory.create(poolName);
            }
            catch (IllegalStateException e) {
                String msg = "A pool named \"" + poolName + "\" already exists.";
                if (e.getMessage().equals(msg)) {
                    if (!XmlPoolConfigs.values().contains(poolConfig)) {
                        String s = "Pool with configuration " + poolConfig + " named " + poolName + " was already created without CacheHelper XML using" + " an unknown, and possibly different, configuration";
                        throw new HydraRuntimeException(s);
                    }
                }
                throw e;
            }
            CacheHelper.log("Added dummy pool: " + PoolHelper.poolToString(dummyPool));
            XmlPoolConfigs.put(fn, poolConfig);
        }
    }

    private static void generateDummyDiskStore(Cache dummyCache, String diskStoreConfig, String fn) {
        if (diskStoreConfig != null) {
            CacheHelper.log("Adding dummy disk store from config: " + diskStoreConfig);
            CacheVersionHelper.generateDummyDiskStore(dummyCache, diskStoreConfig, fn, XmlDiskStoreConfigs);
        }
    }

    private static void generateDummyGatewaySender(Cache dummyCache, String gatewaySenderConfig, String fn) {
        if (gatewaySenderConfig != null) {
            CacheHelper.log("Adding dummy gateway sender from config: " + gatewaySenderConfig);
            CacheVersionHelper.generateDummyGatewaySender(dummyCache, gatewaySenderConfig, fn, XmlGatewaySenderConfigs);
        }
    }

    private static void generateDummyGatewayReceiver(Cache dummyCache, String gatewayReceiverConfig, String fn) {
        if (gatewayReceiverConfig != null) {
            CacheHelper.log("Adding dummy gateway receiver from config: " + gatewayReceiverConfig);
            CacheVersionHelper.generateDummyGatewayReceiver(dummyCache, gatewayReceiverConfig, fn, XmlGatewayReceiverConfigs);
        }
    }

    private static void generateDummyAsyncEventQueue(Cache dummyCache, String asyncEventQueueConfig, String fn) {
        if (asyncEventQueueConfig != null) {
            CacheHelper.log("Adding dummy async event queue from config: " + asyncEventQueueConfig);
            CacheVersionHelper.generateDummyAsyncEventQueue(dummyCache, asyncEventQueueConfig, fn, XmlAsyncEventQueueConfigs);
        }
    }

    private static void generateDummyBridge(Cache dummyCache, String bridgeConfig, String fn) {
        if (bridgeConfig != null) {
            CacheHelper.log("Adding dummy bridge server from config: " + bridgeConfig);
            BridgeDescription bd = BridgeHelper.getBridgeDescription(bridgeConfig);
            CacheServer dummyCacheServer = dummyCache.addCacheServer();
            bd.configure(dummyCacheServer, BridgeHelper.getEndpoint(bd.getGroups()).getPort());
            CacheHelper.log("Added dummy bridge server: " + BridgeHelper.bridgeServerToString(dummyCacheServer));
            XmlBridgeConfigs.put(fn, bridgeConfig);
        }
    }

    private static void generateDummyRegion(Cache dummyCache, String regionConfig, String regionName, String fn) {
        if (regionConfig != null) {
            CacheHelper.log("Creating dummy region attributes from config: " + regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            AttributesFactory regFactory = new AttributesFactory();
            rd.configure(regionName, regFactory, false);
            RegionAttributes dummyRatts = CacheVersionHelper.getDummyRegionAttributes(dummyCache, regFactory.create());
            String rName = regionName;
            if (rName == null) {
                rName = RegionHelper.getRegionDescription(regionConfig).getRegionName();
            }
            CacheHelper.log("Creating dummy region named: " + rName + " with attributes: " + RegionHelper.regionAttributesToString(dummyRatts));
            try {
                Region region = dummyCache.createRegion(rName, dummyRatts);
                CacheHelper.log("Created dummy region named: " + rName);
            }
            catch (RegionExistsException e) {
                throw new HydraInternalException("Should not happen", (Exception)((Object)e));
            }
            XmlRegionConfigs.put(fn, regionConfig);
        }
    }

    private static void generateDummyFunctions(Cache dummyCache, List functions, String fn) {
        if (functions != null) {
            CacheHelper.log("Adding dummy functions: " + functions);
            FunctionServiceCreation fsc = new FunctionServiceCreation();
            for (Function function : functions) {
                fsc.registerFunction(function);
            }
            ((CacheCreation)dummyCache).setFunctionServiceCreation(fsc);
            CacheHelper.log("Added dummy functions: " + fsc.getFunctions());
            XmlFunctionConfigs.put(fn, CacheHelper.classnamesFor(functions));
        }
    }

    private static List classnamesFor(List objs) {
        ArrayList<String> classnames = null;
        if (objs != null) {
            classnames = new ArrayList<String>();
            for (Object obj : objs) {
                classnames.add(obj.getClass().getName());
            }
        }
        return classnames;
    }

    private static void generateCacheXmlFile(String fn, Cache dummyCache) {
        CacheHelper.log("Generating XML file: " + fn);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(fn)));
        }
        catch (IOException e) {
            String s = "Unable to open file: " + fn;
            throw new HydraRuntimeException(s, e);
        }
        CacheXmlGenerator.generate((Cache)dummyCache, (PrintWriter)pw);
        CacheHelper.log("Generated XML file: " + fn);
    }

    public static synchronized Cache getCache() {
        return CacheVersionHelper.getCache();
    }

    public static synchronized void closeCache() {
        Cache cache = CacheHelper.getCache();
        if (cache != null) {
            CacheHelper.log("Closing cache: " + CacheHelper.cacheToString(cache));
            cache.close();
            CacheHelper.log("Closed cache");
            TheCacheConfig = null;
        }
    }

    public static String cacheToString(Cache cache) {
        return CacheDescription.cacheToString(cache);
    }

    public static CacheDescription getCacheDescription(String cacheConfig) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        CacheHelper.log("Looking up cache config: " + cacheConfig);
        CacheDescription cd = TestConfig.getInstance().getCacheDescription(cacheConfig);
        if (cd == null) {
            String s = cacheConfig + " not found in " + BasePrms.nameForKey(CachePrms.names);
            throw new HydraRuntimeException(s);
        }
        CacheHelper.log("Looked up cache config:\n" + cd);
        return cd;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    static {
        XmlCacheConfigs = new HashMap();
        XmlGatewayHubConfigs = new HashMap();
        XmlGatewayConfigs = new HashMap();
        XmlRegionConfigs = new HashMap();
        XmlBridgeConfigs = new HashMap();
        XmlPoolConfigs = new HashMap();
        XmlFunctionConfigs = new HashMap();
        XmlDiskStoreConfigs = new HashMap();
        XmlGatewaySenderConfigs = new HashMap();
        XmlGatewayReceiverConfigs = new HashMap();
        XmlAsyncEventQueueConfigs = new HashMap();
    }
}

