/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.CacheServerBlackboard;
import hydra.ClientDescription;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.VmDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CacheServerHelper {
    private static LogWriter log;

    public static void startCacheServer(String name, String cacheXmlFile) {
        CacheServerHelper.startCacheServer(name, cacheXmlFile, null);
    }

    public static void startCacheServer(String name, String cacheXmlFile, String[] extraArgs) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        CacheServerHelper.log("Starting cache server: " + name);
        String clientName = RemoteTestModule.getMyClientName();
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        String cmd = CacheServerHelper.getStartCommand(name, cd, cacheXmlFile, extraArgs);
        String result = ProcessMgr.fgexec(cmd, 300);
        CacheServerHelper.log(result);
        int pid = CacheServerHelper.verifyStart(name, result);
        Record record = CacheServerHelper.putRecord(name, cd.getVmDescription().getHostDescription(), pid);
        CacheServerHelper.recordPID(record);
        CacheServerHelper.log("Started cache server: " + record);
    }

    public static void killCacheServer(String name) {
        Record record = CacheServerHelper.getRecord(name);
        CacheServerHelper.log("Killing cache server: " + record);
        if (!ProcessMgr.killProcessWait(record.getHost(), record.getPID(), 300)) {
            String s = "Timed out killing cache server: " + record;
            throw new HydraTimeoutException(s);
        }
        CacheServerHelper.removeRecord(name);
        CacheServerHelper.removePID(record);
        CacheServerHelper.log("Killed cache server: " + name);
    }

    public static void stopCacheServer(String name) {
        String clientName = RemoteTestModule.getMyClientName();
        HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
        Record record = CacheServerHelper.getRecord(name);
        CacheServerHelper.log("Stopping cache server: " + record);
        String cmd = CacheServerHelper.getStopCommand(name, hd);
        String result = ProcessMgr.fgexec(cmd, 300);
        CacheServerHelper.log(result);
        CacheServerHelper.verifyStop(name, result);
        CacheServerHelper.removeRecord(name);
        CacheServerHelper.removePID(record);
        CacheServerHelper.log("Stopped cache server: " + name);
    }

    public static String getStartCommand(String name, ClientDescription cd, String cacheXmlFile, String[] extraArgs) {
        VmDescription vmd = cd.getVmDescription();
        HostDescription hd = vmd.getHostDescription();
        String cmd = CacheServerHelper.getCacheServerCommand(hd) + " start";
        cmd = cmd + " -J-DrmiHost=" + System.getProperty("rmiHost") + " -J-D" + "rmiPort" + "=" + System.getProperty("rmiPort");
        if (extraArgs != null) {
            for (int i = 0; i < extraArgs.length; ++i) {
                cmd = cmd + " " + extraArgs[i];
            }
        }
        cmd = cmd + " cache-xml-file=" + FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        GemFireDescription gfd = cd.getGemFireDescription();
        String ds = gfd.getDistributedSystem();
        cmd = cmd + " locators=" + CacheServerHelper.getLocators(ds);
        cmd = cmd + " mcast-port=" + gfd.getMcastPort();
        cmd = cmd + " mcast-address=" + gfd.getMcastAddress();
        String dir = CacheServerHelper.getSystemDirectory(name, hd);
        cmd = cmd + " log-file=" + dir + "/system.log";
        cmd = cmd + " statistic-archive-file=" + dir + "/" + gfd.getStatisticArchiveFile();
        cmd = cmd + " statistic-sampling-enabled=" + gfd.getStatisticSamplingEnabled();
        cmd = cmd + " -dir=" + dir;
        cmd = cmd + " -classpath=" + vmd.getClassPath();
        return cmd;
    }

    private static String getLocators(String ds) {
        if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            return TestConfig.getInstance().getMasterDescription().getLocator(ds);
        }
        List endpoints = DistributedSystemHelper.getEndpoints(ds);
        return DistributedSystemHelper.endpointsToString(endpoints);
    }

    public static String getStopCommand(String name, HostDescription hd) {
        return CacheServerHelper.getCacheServerCommand(hd) + " stop -dir=" + CacheServerHelper.getSystemDirectory(name, hd);
    }

    private static String getCacheServerCommand(HostDescription hd) {
        String cmd = null;
        char sep = hd.getFileSep();
        switch (hd.getOSType()) {
            case windows: {
                cmd = "cmd /c set GF_JAVA=" + hd.getJavaHome() + sep + "bin" + sep + "java.exe" + " && cmd /c " + hd.getGemFireHome() + sep + "bin" + sep + "cacheserver.bat";
                break;
            }
            case unix: {
                cmd = "env GF_JAVA=" + hd.getJavaHome() + sep + "bin" + sep + "java " + hd.getGemFireHome() + sep + "bin" + sep + "cacheserver";
            }
        }
        return cmd;
    }

    private static String getSystemDirectory(String name, HostDescription hd) {
        String sysdir = hd.getUserDir() + hd.getFileSep() + name;
        FileUtil.mkdir(new File(sysdir));
        try {
            RemoteTestModule.Master.recordDir(hd, name, sysdir);
        }
        catch (RemoteException e) {
            String s = "Unable to record system directory with master: " + sysdir;
            throw new HydraRuntimeException(s, e);
        }
        return sysdir;
    }

    private static int verifyStart(String name, String result) {
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            boolean running = false;
            int pid = -1;
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer t = new StringTokenizer(line, " ", false);
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (token.equals("status:")) {
                        try {
                            token = t.nextToken();
                            if (token.equals("running")) {
                                running = true;
                                continue;
                            }
                            String s = "Cache server " + name + " did not start: " + token;
                            throw new HydraRuntimeException(s);
                        }
                        catch (NoSuchElementException e) {
                            String s = "Missing value for cache server status: " + name;
                            throw new HydraRuntimeException(s, e);
                        }
                    }
                    if (!token.equals("pid:")) continue;
                    try {
                        token = t.nextToken();
                        pid = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {
                        String s = "Cache server " + name + " has invalid PID: " + token;
                        throw new HydraRuntimeException(s, e);
                    }
                    catch (NoSuchElementException e) {
                        String s = "Cache server " + name + " missing PID";
                        throw new HydraRuntimeException(s, e);
                    }
                }
            }
            if (!running || pid == -1) {
                String s = "Cache server " + name + " did not start properly";
                throw new HydraRuntimeException(s);
            }
            int n = pid;
            return n;
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Problem with reader", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void verifyStop(String name, String result) {
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            boolean stopped = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer t = new StringTokenizer(line, " ", false);
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (!token.startsWith("stopped")) continue;
                    stopped = true;
                }
            }
            if (!stopped) {
                String s = "Cache server " + name + " did not stop";
                throw new HydraRuntimeException(s);
            }
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Problem with reader", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Record putRecord(String name, HostDescription hd, int pid) {
        Record record = new Record(hd, pid);
        CacheServerBlackboard.getInstance().getSharedMap().put(name, record);
        return record;
    }

    private static Record getRecord(String name) {
        Record record = (Record)CacheServerBlackboard.getInstance().getSharedMap().get(name);
        if (record == null) {
            String s = "Cache server record not found: " + name;
            throw new HydraRuntimeException(s);
        }
        return record;
    }

    private static void removeRecord(String name) {
        CacheServerBlackboard.getInstance().getSharedMap().remove(name);
    }

    private static void recordPID(Record record) {
        try {
            RemoteTestModule.Master.recordPID(record.getHostDescription(), record.getPID());
        }
        catch (RemoteException e) {
            String s = "Failed to remove PID from nukerun script: " + record;
            throw new HydraRuntimeException(s);
        }
    }

    private static void removePID(Record record) {
        try {
            RemoteTestModule.Master.removePID(record.getHostDescription(), record.getPID());
        }
        catch (RemoteException e) {
            String s = "Failed to remove PID from nukerun script: " + record;
            throw new HydraRuntimeException(s);
        }
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    public static class Record
    implements Serializable {
        HostDescription hd;
        int pid;

        public Record(HostDescription hd, int pid) {
            this.hd = hd;
            this.pid = pid;
        }

        public HostDescription getHostDescription() {
            return this.hd;
        }

        public String getHost() {
            return this.hd.getHostName();
        }

        public HostHelper.OSType getOSType() {
            return this.hd.getOSType();
        }

        public int getPID() {
            return this.pid;
        }

        public String toString() {
            return this.getHost() + ":" + this.pid + "(" + (Object)((Object)this.getOSType()) + ")";
        }
    }
}

