/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import hydra.AsyncEventQueueDescription;
import hydra.AsyncEventQueueHelper;
import hydra.CacheDescription;
import hydra.DiskStoreDescription;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewayReceiverDescription;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderDescription;
import hydra.GatewaySenderHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.util.Map;
import java.util.Set;

public class CacheVersionHelper {
    protected static Cache configureAndCreateCache(String cacheConfig, CacheDescription cd, DistributedSystem ds) {
        CacheFactory f = new CacheFactory();
        Log.getLogWriter().info("Configuring cache factory from config: " + cacheConfig);
        cd.configure(f);
        Log.getLogWriter().info("Creating cache");
        return f.create();
    }

    protected static void generateDummyDiskStore(Cache dummyCache, String diskStoreConfig, String fn, Map XmlDiskStoreConfigs) {
        DiskStoreDescription dsd = DiskStoreHelper.getDiskStoreDescription(diskStoreConfig);
        DiskStoreFactory dummyFactory = ((CacheCreation)dummyCache).createDiskStoreFactory();
        dsd.configure(dummyFactory);
        String diskStoreName = dsd.getName();
        DiskStore dummyDiskStore = null;
        try {
            dummyDiskStore = dummyFactory.create(diskStoreName);
        }
        catch (IllegalStateException e) {
            String msg = "A disk store named \"" + diskStoreName + "\" already exists.";
            if (e.getMessage().equals(msg)) {
                if (!XmlDiskStoreConfigs.values().contains(diskStoreConfig)) {
                    String s = "DiskStore with configuration " + diskStoreConfig + " named " + diskStoreName + " was already created without CacheHelper XML using" + " an unknown, and possibly different, configuration";
                    throw new HydraRuntimeException(s);
                }
            }
            throw e;
        }
        if (Log.getLogWriter().infoEnabled()) {
            Log.getLogWriter().info("Added dummy disk store: " + DiskStoreHelper.diskStoreToString(dummyDiskStore));
        }
        XmlDiskStoreConfigs.put(fn, diskStoreConfig);
    }

    protected static void generateDummyGatewaySender(Cache dummyCache, String gatewaySenderConfig, String fn, Map XmlGatewaySenderConfigs) {
        String localds = DistributedSystemHelper.getDistributedSystemName();
        GatewaySenderDescription gsd = GatewaySenderHelper.getGatewaySenderDescription(gatewaySenderConfig);
        Set<String> remoteDistributedSystems = gsd.getRemoteDistributedSystems();
        if (remoteDistributedSystems.size() > 0) {
            GatewaySenderFactory dummyFactory = ((CacheCreation)dummyCache).createGatewaySenderFactory();
            gsd.configure(dummyFactory);
            for (String remoteds : remoteDistributedSystems) {
                String id = gsd.getName() + "_" + localds + "_to_" + remoteds;
                int remoteid = DistributedSystemHelper.getDistributedSystemId(remoteds);
                GatewaySender dummyGatewaySender = null;
                try {
                    dummyGatewaySender = dummyFactory.create(id, remoteid);
                    GatewaySenderHelper.saveGatewaySenderId(gsd.getName(), gsd.getParallel(), id);
                }
                catch (IllegalStateException e) {
                    String msg = "A gateway sender named \"" + id + "\" already exists.";
                    if (e.getMessage().equals(msg)) {
                        if (!XmlGatewaySenderConfigs.values().contains(gatewaySenderConfig)) {
                            String s = "GatewaySender with configuration " + gatewaySenderConfig + " named " + id + " was already created without CacheHelper XML using" + " an unknown, and possibly different, configuration";
                            throw new HydraRuntimeException(s);
                        }
                    }
                    throw e;
                }
                if (!Log.getLogWriter().infoEnabled()) continue;
                Log.getLogWriter().info("Added dummy gateway sender: " + GatewaySenderHelper.gatewaySenderToString(dummyGatewaySender));
            }
            XmlGatewaySenderConfigs.put(fn, gatewaySenderConfig);
        } else {
            Log.getLogWriter().info("No remote distributed systems found");
        }
    }

    protected static void generateDummyGatewayReceiver(Cache dummyCache, String gatewayReceiverConfig, String fn, Map XmlGatewayReceiverConfigs) {
        GatewayReceiverDescription grd = GatewayReceiverHelper.getGatewayReceiverDescription(gatewayReceiverConfig);
        int numInstances = grd.getNumInstances();
        Log.getLogWriter().info("Creating " + numInstances + " dummy gateway receivers for " + grd.getName());
        GatewayReceiverFactory dummyFactory = ((CacheCreation)dummyCache).createGatewayReceiverFactory();
        grd.configure(dummyFactory);
        for (int i = 0; i < numInstances; ++i) {
            GatewayReceiver dummyGatewayReceiver = dummyFactory.create();
            if (!Log.getLogWriter().infoEnabled()) continue;
            Log.getLogWriter().info("Added dummy gateway receiver: " + GatewayReceiverHelper.gatewayReceiverToString(dummyGatewayReceiver));
        }
        XmlGatewayReceiverConfigs.put(fn, gatewayReceiverConfig);
    }

    protected static void generateDummyAsyncEventQueue(Cache dummyCache, String asyncEventQueueConfig, String fn, Map XmlAsyncEventQueueConfigs) {
        AsyncEventQueueDescription aeqd = AsyncEventQueueHelper.getAsyncEventQueueDescription(asyncEventQueueConfig);
        Log.getLogWriter().info("Creating dummy async event queue for " + aeqd.getName());
        AsyncEventQueueFactory dummyFactory = ((CacheCreation)dummyCache).createAsyncEventQueueFactory();
        aeqd.configure(dummyFactory);
        AsyncEventQueue dummyAsyncEventQueue = dummyFactory.create(aeqd.getName(), aeqd.getAsyncEventListenerInstance());
        if (Log.getLogWriter().infoEnabled()) {
            Log.getLogWriter().info("Added dummy async event queue: " + AsyncEventQueueHelper.asyncEventQueueToString(dummyAsyncEventQueue));
        }
        XmlAsyncEventQueueConfigs.put(fn, asyncEventQueueConfig);
    }

    protected static synchronized Cache getCache() {
        try {
            return CacheFactory.getAnyInstance();
        }
        catch (CancelException e) {
            return null;
        }
    }

    protected static void generateDummyResourceManager(CacheDescription cd, CacheCreation dummyCache) {
        if (cd.getResourceManagerDescription() != null) {
            ResourceManagerCreation dummyResourceManager = new ResourceManagerCreation();
            dummyCache.setResourceManagerCreation(dummyResourceManager);
        }
    }

    protected static RegionAttributes getDummyRegionAttributes(Cache dummyCache, RegionAttributes ratts) {
        return new RegionAttributesCreation((CacheCreation)dummyCache, ratts, false);
    }
}

