/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.pdx.PdxSerializer;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.CachePrms;
import hydra.ClientCachePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.PoolDescription;
import hydra.PoolPrms;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class ClientCacheDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private DiskStoreDescription defaultDiskStoreDescription;
    private String defaultDiskStoreDescriptionName;
    private PoolDescription defaultPoolDescription;
    private String defaultPoolDescriptionName;
    private DiskStoreDescription pdxDiskStoreDescription;
    private String pdxDiskStoreName;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private String pdxSerializerClass;
    private String pdxSerializerMethod;
    private transient PdxSerializer pdxSerializerInstance;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    protected String getDefaultDiskStoreDescriptionName() {
        return this.defaultDiskStoreDescriptionName;
    }

    private void setDefaultDiskStoreDescriptionName(String str) {
        this.defaultDiskStoreDescriptionName = str;
    }

    public DiskStoreDescription getDefaultDiskStoreDescription() {
        return this.defaultDiskStoreDescription;
    }

    private void setDefaultDiskStoreDescription(DiskStoreDescription dsd) {
        this.defaultDiskStoreDescription = dsd;
    }

    private String getDefaultPoolDescriptionName() {
        return this.defaultPoolDescriptionName;
    }

    private void setDefaultPoolDescriptionName(String str) {
        this.defaultPoolDescriptionName = str;
    }

    public PoolDescription getDefaultPoolDescription() {
        return this.defaultPoolDescription;
    }

    private void setDefaultPoolDescription(PoolDescription pd) {
        this.defaultPoolDescription = pd;
    }

    private String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    private void setPdxDiskStoreName(String str) {
        this.pdxDiskStoreName = str;
    }

    public DiskStoreDescription getPdxDiskStoreDescription() {
        return this.pdxDiskStoreDescription;
    }

    private void setPdxDiskStoreDescription(DiskStoreDescription dsd) {
        this.pdxDiskStoreDescription = dsd;
    }

    private Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    private void setPdxIgnoreUnreadFields(Boolean bool) {
        this.pdxIgnoreUnreadFields = bool;
    }

    private Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    private void setPdxPersistent(Boolean bool) {
        this.pdxPersistent = bool;
    }

    private Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    private void setPdxReadSerialized(Boolean bool) {
        this.pdxReadSerialized = bool;
    }

    private String getPdxSerializerClass() {
        return this.pdxSerializerClass;
    }

    private void setPdxSerializerClass(String str) {
        this.pdxSerializerClass = str;
    }

    private String getPdxSerializerMethod() {
        return this.pdxSerializerMethod;
    }

    private void setPdxSerializerMethod(String str) {
        this.pdxSerializerMethod = str;
    }

    private synchronized PdxSerializer getPdxSerializerInstance() {
        if (this.pdxSerializerInstance == null) {
            this.pdxSerializerInstance = this.createPdxSerializerInstance();
        }
        return this.pdxSerializerInstance;
    }

    public void configure(ClientCacheFactory f) {
        PoolDescription pd = this.getDefaultPoolDescription();
        if (pd != null) {
            pd.configure(f);
        }
        if (this.getPdxDiskStoreDescription() != null) {
            f.setPdxDiskStore(this.getPdxDiskStoreDescription().getName());
        }
        f.setPdxIgnoreUnreadFields(this.getPdxIgnoreUnreadFields().booleanValue());
        f.setPdxPersistent(this.getPdxPersistent().booleanValue());
        f.setPdxReadSerialized(this.getPdxReadSerialized().booleanValue());
        if (this.getPdxSerializerClass() != null) {
            f.setPdxSerializer(this.getPdxSerializerInstance());
        }
    }

    public void configureDummy(ClientCacheCreation c) {
        if (this.getPdxDiskStoreDescription() != null) {
            c.setPdxDiskStore(this.getPdxDiskStoreDescription().getName());
        }
        c.setPdxIgnoreUnreadFields(this.getPdxIgnoreUnreadFields().booleanValue());
        c.setPdxPersistent(this.getPdxPersistent().booleanValue());
        c.setPdxReadSerialized(this.getPdxReadSerialized().booleanValue());
        if (this.getPdxSerializerClass() != null) {
            c.setPdxSerializer(this.getPdxSerializerInstance());
        }
    }

    protected static synchronized String cacheToString(ClientCache c) {
        StringBuffer buf = new StringBuffer();
        Pool p = null;
        if (c instanceof ClientCacheCreation) {
            String pname = ((ClientCacheCreation)c).getDefaultPoolName();
            if (pname != null) {
                p = (Pool)((ClientCacheCreation)c).getPools().get(pname);
            }
        } else {
            p = ((GemFireCacheImpl)c).getDefaultPool();
        }
        if (p == null) {
            buf.append("\n defaultPool: null");
        } else {
            buf.append("\n defaultPool: " + p.getName() + " with attributes:");
            buf.append(PoolDescription.poolToString(p));
            buf.append("\n --------------------");
        }
        buf.append("\n  pdxDiskStoreName: " + c.getPdxDiskStore());
        buf.append("\n  pdxIgnoreUnreadFields: " + c.getPdxIgnoreUnreadFields());
        buf.append("\n  pdxPersistent: " + c.getPdxPersistent());
        buf.append("\n  pdxReadSerialized: " + c.getPdxReadSerialized());
        buf.append("\n  pdxSerializer: " + c.getPdxSerializer());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "defaultDiskStoreName", this.getDefaultDiskStoreDescriptionName());
        map.put(header + "defaultPoolName", this.getDefaultPoolDescriptionName());
        map.put(header + "pdxDiskStoreName", this.getPdxDiskStoreName());
        map.put(header + "pdxIgnoreUnreadFields", this.getPdxIgnoreUnreadFields());
        map.put(header + "pdxPersistent", this.getPdxPersistent());
        map.put(header + "pdxReadSerialized", this.getPdxReadSerialized());
        map.put(header + "pdxSerializer", this.getPdxSerializerClass() + "." + this.getPdxSerializerMethod());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(ClientCachePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            ClientCacheDescription ccd = ClientCacheDescription.createClientCacheDescription(name, config, i);
            config.addClientCacheDescription(ccd);
        }
    }

    private static ClientCacheDescription createClientCacheDescription(String name, TestConfig config, int index) {
        Boolean bool;
        ConfigHashtable tab = config.getParameters();
        ClientCacheDescription ccd = new ClientCacheDescription();
        ccd.setName(name);
        Long key = ClientCachePrms.defaultDiskStoreName;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            ccd.setDefaultDiskStoreDescription(ClientCacheDescription.getDiskStoreDescription(str, key, config));
            ccd.setDefaultDiskStoreDescriptionName("DiskStoreDescription." + str);
        }
        if ((str = tab.getString(key = ClientCachePrms.defaultPoolName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            ccd.setDefaultPoolDescription(ClientCacheDescription.getPoolDescription(str, key, config));
            ccd.setDefaultPoolDescriptionName("PoolDescription." + str);
        }
        if ((str = tab.getString(key = CachePrms.pdxDiskStoreName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            ccd.setPdxDiskStoreDescription(ClientCacheDescription.getPdxDiskStoreDescription(str, key, config));
            ccd.setPdxDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = CachePrms.pdxIgnoreUnreadFields, tab.getWild(key, index, null))) == null) {
            ccd.setPdxIgnoreUnreadFields(CacheConfig.DEFAULT_PDX_IGNORE_UNREAD_FIELDS);
        } else {
            ccd.setPdxIgnoreUnreadFields(bool);
        }
        key = CachePrms.pdxPersistent;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            ccd.setPdxPersistent(CacheConfig.DEFAULT_PDX_PERSISTENT);
        } else {
            ccd.setPdxPersistent(bool);
        }
        key = CachePrms.pdxReadSerialized;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            ccd.setPdxReadSerialized(CacheConfig.DEFAULT_PDX_READ_SERIALIZED);
        } else {
            ccd.setPdxReadSerialized(bool);
        }
        key = CachePrms.pdxSerializerInstantiator;
        HydraVector strs = tab.vecAtWild(key, index, null);
        ccd.setPdxSerializerClass(ClientCacheDescription.getPdxSerializerClass(strs, key));
        ccd.setPdxSerializerMethod(ClientCacheDescription.getPdxSerializerMethod(strs, key));
        return ccd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static PoolDescription getPoolDescription(String str, Long key, TestConfig config) {
        PoolDescription pd = config.getPoolDescription(str);
        if (pd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(PoolPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return pd;
    }

    private static DiskStoreDescription getPdxDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static String getPdxSerializerClass(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return null;
        }
        if (strs.size() == 2) {
            return (String)strs.get(0);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static String getPdxSerializerMethod(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return null;
        }
        if (strs.size() == 2) {
            return (String)strs.get(1);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private PdxSerializer createPdxSerializerInstance() {
        String methodname;
        Long key = CachePrms.pdxSerializerInstantiator;
        String classname = this.getPdxSerializerClass();
        MethExecutorResult result = MethExecutor.execute(classname, methodname = this.getPdxSerializerMethod());
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        Object obj = result.getResult();
        Log.getLogWriter().info("Instantiated  " + obj);
        try {
            return (PdxSerializer)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + "=" + this.getPdxSerializerClass() + "." + this.getPdxSerializerMethod() + " returned an instance of " + obj.getClass().getName() + " instead of a PdxSerializer";
            throw new HydraConfigException(s);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.defaultDiskStoreDescription = (DiskStoreDescription)in.readObject();
        this.defaultDiskStoreDescriptionName = (String)in.readObject();
        this.defaultPoolDescription = (PoolDescription)in.readObject();
        this.defaultPoolDescriptionName = (String)in.readObject();
        this.pdxDiskStoreName = (String)in.readObject();
        this.pdxDiskStoreDescription = (DiskStoreDescription)in.readObject();
        this.pdxIgnoreUnreadFields = (Boolean)in.readObject();
        this.pdxPersistent = (Boolean)in.readObject();
        this.pdxReadSerialized = (Boolean)in.readObject();
        this.pdxSerializerClass = (String)in.readObject();
        this.pdxSerializerMethod = (String)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.defaultDiskStoreDescription);
        out.writeObject(this.defaultDiskStoreDescriptionName);
        out.writeObject(this.defaultPoolDescription);
        out.writeObject(this.defaultPoolDescriptionName);
        out.writeObject(this.pdxDiskStoreName);
        out.writeObject(this.pdxDiskStoreDescription);
        out.writeObject(this.pdxIgnoreUnreadFields);
        out.writeObject(this.pdxPersistent);
        out.writeObject(this.pdxReadSerialized);
        out.writeObject(this.pdxSerializerClass);
        out.writeObject(this.pdxSerializerMethod);
    }
}

