/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadSubgroup;
import hydra.Log;
import hydra.PermutationGenerator;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClientMapper {
    private Map threadGroups;
    private Vector threadSubgroups;

    public ClientMapper(Map threadGroups) {
        this.threadGroups = threadGroups;
        this.threadSubgroups = this.subgroupsFromGroups(threadGroups);
    }

    public void mapClients(Map cvmrs) {
        if (ClientMapper.log().finestEnabled()) {
            ClientMapper.log().finest("Mapping clients: " + cvmrs);
            ClientMapper.log().finest("Using groups: " + this.threadGroups);
        }
        this.mapClientsToGroups(cvmrs);
        this.assignThreadGroupIds(cvmrs);
    }

    private void assignThreadGroupIds(Map cvmrs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (ClientVmRecord cvmr : cvmrs.values()) {
            for (ClientRecord cr : cvmr.getClients().values()) {
                String tgname = cr.getThreadGroup().getName();
                Integer index = (Integer)map.get(tgname);
                if (index == null) {
                    index = new Integer(0);
                    map.put(tgname, index);
                }
                int tgid = index;
                cr.setThreadGroupName(tgname);
                cr.setThreadGroupId(tgid);
                map.put(tgname, new Integer(tgid + 1));
            }
        }
    }

    public String getMappingAsString(Map cvmrs) {
        StringBuffer buf = new StringBuffer();
        buf.append("\nCLIENT MAPPING:");
        for (ClientVmRecord cvmr : cvmrs.values()) {
            for (ClientRecord cr : cvmr.getClients().values()) {
                buf.append("\n    " + cr.getThreadGroupName() + "\t" + cr);
            }
        }
        return buf.toString();
    }

    public List<List<String>> getMappingAsList(Map cvmrs) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (ClientVmRecord cvmr : cvmrs.values()) {
            for (ClientRecord cr : cvmr.getClients().values()) {
                ArrayList<String> sublist = new ArrayList<String>();
                sublist.add(cr.getThreadGroupName());
                sublist.add(cr.toString());
                list.add(sublist);
            }
        }
        return list;
    }

    private void mapClientsToGroups(Map cvmrs) {
        Vector subgroups = this.sortSubgroups(this.threadSubgroups);
        boolean containsDefault = this.containsDefault(subgroups);
        PermutationGenerator pgen = null;
        pgen = containsDefault ? (subgroups.size() == 1 ? new PermutationGenerator(subgroups.size()) : new PermutationGenerator(subgroups.size() - 1)) : new PermutationGenerator(subgroups.size());
        while (pgen.hasMore()) {
            HashMap namemap = this.sortClientsByNameAndVmid(cvmrs);
            if (ClientMapper.log().finestEnabled()) {
                ClientMapper.log().finest("Using buckets:\n" + ClientMapper.nameMapToString(namemap));
            }
            Vector permutation = new Vector();
            int[] indices = pgen.getNext();
            for (int i = 0; i < indices.length; ++i) {
                permutation.add(subgroups.elementAt(indices[i]));
            }
            if (containsDefault && subgroups.size() > 1) {
                permutation.add(subgroups.elementAt(subgroups.size() - 1));
            }
            if (ClientMapper.log().finestEnabled()) {
                ClientMapper.log().finest("Trying subgroup permutation: " + permutation);
            }
            try {
                this.mapClientsToGroups(namemap, permutation);
                return;
            }
            catch (HydraConfigException e) {
                if (ClientMapper.log().fineEnabled()) {
                    ClientMapper.log().fine("Unable to map clients:\n" + cvmrs + "\nto thread groups:\n" + permutation + "\nbecause: " + e.getMessage());
                }
                for (ClientVmRecord cvmr : cvmrs.values()) {
                    Iterator<ClientRecord> j = cvmr.getClients().values().iterator();
                    while (j.hasNext()) {
                        j.next().setThreadGroup(null);
                    }
                }
            }
        }
        throw new HydraConfigException("Failed to map clients:\n" + cvmrs + "\nto thread groups:\n" + this.threadGroups);
    }

    private boolean containsDefault(Vector subgroups) {
        for (int i = 0; i < subgroups.size(); ++i) {
            HydraThreadSubgroup subgroup = (HydraThreadSubgroup)subgroups.elementAt(i);
            if (!subgroup.getName().equals("default")) continue;
            if (i != subgroups.size() - 1) {
                throw new HydraInternalException("Default thread subgroup is present but not last in list: " + subgroups);
            }
            return true;
        }
        return false;
    }

    private Vector sortSubgroups(Vector subgroups) {
        Vector<HydraThreadSubgroup> sorted = new Vector<HydraThreadSubgroup>();
        for (HydraThreadSubgroup subgroup : subgroups) {
            if (subgroup.getClientNames() == null || subgroup.getTotalVMs() <= 0 || subgroup.getName().equals("default")) continue;
            sorted.add(subgroup);
        }
        for (HydraThreadSubgroup subgroup : subgroups) {
            if (subgroup.getClientNames() == null || subgroup.getTotalVMs() != 0 || subgroup.getName().equals("default")) continue;
            sorted.add(subgroup);
        }
        for (HydraThreadSubgroup subgroup : subgroups) {
            if (subgroup.getClientNames() != null || subgroup.getTotalVMs() <= 0 || subgroup.getName().equals("default")) continue;
            sorted.add(subgroup);
        }
        for (HydraThreadSubgroup subgroup : subgroups) {
            if (subgroup.getClientNames() != null || subgroup.getTotalVMs() != 0 || subgroup.getTotalThreads() <= 0 || subgroup.getName().equals("default")) continue;
            sorted.add(subgroup);
        }
        HydraThreadGroup defaultGroup = (HydraThreadGroup)this.threadGroups.get("default");
        if (defaultGroup != null) {
            HydraThreadSubgroup defaultSubgroup = defaultGroup.getSubgroup(0);
            sorted.add(defaultSubgroup);
        }
        if (sorted.size() != subgroups.size()) {
            throw new HydraInternalException("Failed to sort all subgroups:\nsorted --> " + sorted + "\nsubgroups --> " + subgroups);
        }
        if (ClientMapper.log().fineEnabled()) {
            ClientMapper.log().fine("\nINITIAL SORT FOR SUBGROUPS:\n" + subgroups + "\n\n");
        }
        return sorted;
    }

    private void mapClientsToGroups(HashMap namemap, Vector subgroups) {
        if (ClientMapper.log().finestEnabled()) {
            ClientMapper.log().finest("Mapping clients to subgroups permutation: " + subgroups);
        }
        int mapped = 0;
        for (HydraThreadSubgroup subgroup : subgroups) {
            int needed;
            int remaining = this.numRemainingClients(namemap, subgroup.getClientNames());
            if (remaining < (needed = subgroup.getTotalThreads())) {
                throw new HydraInternalException("Not enough clients (" + remaining + ") to map to: " + subgroup);
            }
            if (ClientMapper.log().finestEnabled()) {
                ClientMapper.log().finest("Mapping clients to subgroup: " + subgroup);
            }
            if (subgroup.getClientNames() != null && subgroup.getTotalVMs() > 0 && !subgroup.getName().equals("default")) {
                this.mapClientsToSubgroupNamedExact(namemap, subgroup);
            } else if (subgroup.getClientNames() != null && subgroup.getTotalVMs() == 0 && !subgroup.getName().equals("default")) {
                this.mapClientsToSubgroupNamed(namemap, subgroup);
            } else if (subgroup.getTotalVMs() > 0 && !subgroup.getName().equals("default")) {
                this.mapClientsToSubgroupExact(namemap, subgroup);
            } else if (subgroup.getTotalVMs() == 0 && subgroup.getTotalThreads() > 0 && !subgroup.getName().equals("default")) {
                this.mapClientsToSubgroupRandom(namemap, subgroup);
            } else if (subgroup.getName().equals("default")) {
                this.mapClientsToSubgroupRemaining(namemap, subgroup);
            } else {
                throw new HydraInternalException("Unexpected case: " + subgroup);
            }
            ++mapped;
        }
        if (mapped != subgroups.size()) {
            throw new HydraInternalException("Client mapping skipped one or more subgroups");
        }
        if (this.numRemainingClients(namemap) != 0) {
            throw new HydraInternalException("Client mapping skipped " + this.numRemainingClients(namemap) + " clients: " + ClientMapper.nameMapToString(namemap));
        }
    }

    private void mapClientsToSubgroupNamedExact(HashMap namemap, HydraThreadSubgroup subgroup) {
        int totalThreads = subgroup.getTotalThreads();
        int totalVMs = subgroup.getTotalVMs();
        Vector clientNames = subgroup.getClientNames();
        int lowNumThreads = totalThreads / totalVMs;
        int highNumThreads = lowNumThreads + 1;
        int numHighVMs = totalThreads % totalVMs;
        int numLowVMs = totalVMs - numHighVMs;
        int mapped = 0;
        for (String clientName : subgroup.getClientNames()) {
            HashMap vmidmap = (HashMap)namemap.get(clientName);
            if (vmidmap == null) {
                throw new HydraInternalException("No clients with name " + clientName);
            }
            for (Collection crs : vmidmap.values()) {
                int i;
                if (numHighVMs > 0 && crs.size() >= highNumThreads) {
                    for (i = 0; i < highNumThreads; ++i) {
                        this.mapRandomClientWithVmid(crs, subgroup);
                        ++mapped;
                    }
                    --numHighVMs;
                    continue;
                }
                if (numLowVMs <= 0 || crs.size() < lowNumThreads) continue;
                for (i = 0; i < lowNumThreads; ++i) {
                    this.mapRandomClientWithVmid(crs, subgroup);
                    ++mapped;
                }
                --numLowVMs;
            }
        }
        if (mapped != totalThreads) {
            throw new HydraConfigException("Unable to evenly distribute " + totalThreads + " threads across " + totalVMs + " vms for: " + subgroup);
        }
    }

    private void mapClientsToSubgroupNamed(HashMap namemap, HydraThreadSubgroup subgroup) {
        for (int totalThreads = subgroup.getTotalThreads(); totalThreads > 0; --totalThreads) {
            this.mapRandomClientWithNames(namemap, subgroup);
        }
    }

    private void mapClientsToSubgroupExact(HashMap namemap, HydraThreadSubgroup subgroup) {
        int totalThreads = subgroup.getTotalThreads();
        int totalVMs = subgroup.getTotalVMs();
        int lowNumThreads = totalThreads / totalVMs;
        int highNumThreads = lowNumThreads + 1;
        int numHighVMs = totalThreads % totalVMs;
        int numLowVMs = totalVMs - numHighVMs;
        int mapped = 0;
        for (HashMap vmidmap : namemap.values()) {
            for (Collection crs : vmidmap.values()) {
                int i;
                if (numHighVMs > 0 && crs.size() >= highNumThreads) {
                    for (i = 0; i < highNumThreads; ++i) {
                        this.mapRandomClientWithVmid(crs, subgroup);
                        ++mapped;
                    }
                    --numHighVMs;
                    continue;
                }
                if (numLowVMs <= 0 || crs.size() < lowNumThreads) continue;
                for (i = 0; i < lowNumThreads; ++i) {
                    this.mapRandomClientWithVmid(crs, subgroup);
                    ++mapped;
                }
                --numLowVMs;
            }
        }
        if (mapped != totalThreads) {
            throw new HydraConfigException("Unable to evenly distribute " + totalThreads + " threads across " + totalVMs + " vms for: " + subgroup);
        }
    }

    private void mapClientsToSubgroupRandom(HashMap namemap, HydraThreadSubgroup subgroup) {
        for (int totalThreads = subgroup.getTotalThreads(); totalThreads > 0; --totalThreads) {
            this.mapRandomClient(namemap, subgroup);
        }
    }

    private void mapClientsToSubgroupRemaining(HashMap namemap, HydraThreadSubgroup subgroup) {
        for (HashMap vmidmap : namemap.values()) {
            for (Collection bucket : vmidmap.values()) {
                Iterator k = bucket.iterator();
                while (k.hasNext()) {
                    ClientRecord cr = (ClientRecord)k.next();
                    if (ClientMapper.log().finestEnabled()) {
                        ClientMapper.log().finest("Mapping remaining " + cr + " to " + subgroup);
                    }
                    this.mapClient(cr, subgroup, k);
                }
            }
        }
    }

    private void mapRandomClientWithNames(HashMap namemap, HydraThreadSubgroup subgroup) {
        Vector clientBucketsWithName = new Vector();
        for (String clientName : subgroup.getClientNames()) {
            HashMap vmidmap = (HashMap)namemap.get(clientName);
            clientBucketsWithName.addAll(vmidmap.values());
        }
        int numRemaining = 0;
        for (Collection crs : clientBucketsWithName) {
            numRemaining += crs.size();
        }
        GsRandom rng = TestConfig.tab().getRandGen();
        int currentIndex = 0;
        int randomIndex = rng.nextInt(0, numRemaining - 1);
        Iterator i = clientBucketsWithName.iterator();
        while (i.hasNext()) {
            Collection crs = (Collection)i.next();
            for (ClientRecord cr : crs) {
                if (currentIndex == randomIndex) {
                    if (ClientMapper.log().finestEnabled()) {
                        ClientMapper.log().finest("Mapping client named " + cr + " to " + subgroup);
                    }
                    this.mapClient(cr, subgroup, i);
                    if (ClientMapper.log().finestEnabled()) {
                        ClientMapper.log().finest("Removing client " + cr + " in thread group " + cr.getThreadGroupName() + " from namemap");
                    }
                    HashMap vmidmap = (HashMap)namemap.get(cr.vm().getClientName());
                    Collection bucket = (Collection)vmidmap.get(cr.vm().getVmid());
                    bucket.remove(cr);
                    return;
                }
                ++currentIndex;
            }
        }
    }

    private void mapRandomClientWithVmid(Collection crs, HydraThreadSubgroup subgroup) {
        GsRandom rng = TestConfig.tab().getRandGen();
        int currentIndex = 0;
        int randomIndex = rng.nextInt(0, crs.size() - 1);
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ClientRecord cr = (ClientRecord)i.next();
            if (currentIndex == randomIndex) {
                if (ClientMapper.log().finestEnabled()) {
                    ClientMapper.log().finest("Mapping exact " + cr + " to " + subgroup);
                }
                this.mapClient(cr, subgroup, i);
                return;
            }
            ++currentIndex;
        }
    }

    private void mapRandomClient(HashMap namemap, HydraThreadSubgroup subgroup) {
        GsRandom rng = TestConfig.tab().getRandGen();
        int randomIndex = rng.nextInt(1, this.numRemainingClients(namemap) - 1);
        int currentIndex = 0;
        for (HashMap vmidmap : namemap.values()) {
            for (Collection crs : vmidmap.values()) {
                Iterator k = crs.iterator();
                while (k.hasNext()) {
                    ClientRecord cr = (ClientRecord)k.next();
                    if (currentIndex == randomIndex) {
                        if (ClientMapper.log().finestEnabled()) {
                            ClientMapper.log().finest("Mapping random " + cr + " to " + subgroup);
                        }
                        this.mapClient(cr, subgroup, k);
                        return;
                    }
                    ++currentIndex;
                }
            }
        }
    }

    private void mapClient(ClientRecord cr, HydraThreadSubgroup subgroup, Iterator bucket) {
        String name = cr.getThreadGroupName();
        if (name != null) {
            throw new HydraInternalException("Already mapped " + cr + " to " + name + " -- can't map it to " + subgroup.getName());
        }
        HydraThreadGroup group = (HydraThreadGroup)this.threadGroups.get(subgroup.getName());
        cr.setThreadGroup(group);
        bucket.remove();
        if (ClientMapper.log().finestEnabled()) {
            ClientMapper.log().finest("Removing client " + cr + " in thread group " + cr.getThreadGroupName() + " from bucket");
        }
    }

    private HashMap sortClientsByNameAndVmid(Map cvmrs) {
        HashMap<String, HashMap<Integer, Collection>> namemap = new HashMap<String, HashMap<Integer, Collection>>();
        for (ClientVmRecord cvmr : cvmrs.values()) {
            String clientName = cvmr.getClientName();
            HashMap<Integer, Collection> vmidmap = (HashMap<Integer, Collection>)namemap.get(clientName);
            if (vmidmap == null) {
                vmidmap = new HashMap<Integer, Collection>();
                namemap.put(clientName, vmidmap);
            }
            vmidmap.put(cvmr.getVmid(), cvmr.getCopyOfClientCollection());
        }
        return namemap;
    }

    private static String nameMapToString(Map namemap) {
        StringBuffer sb = new StringBuffer("Name map:\n");
        for (String clientName : namemap.keySet()) {
            sb.append("  ClientName ");
            sb.append(clientName);
            sb.append("\n");
            Map vmidmap = (Map)namemap.get(clientName);
            for (Integer vmid : vmidmap.keySet()) {
                sb.append("    vm_");
                sb.append(vmid);
                sb.append(" -> ");
                Collection crs = (Collection)vmidmap.get(vmid);
                Iterator iter = crs.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    sb.append(" ");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private int numRemainingClients(HashMap namemap, Vector clientNames) {
        if (clientNames == null) {
            return this.numRemainingClients(namemap);
        }
        int count = 0;
        for (String clientName : clientNames) {
            HashMap vmidmap = (HashMap)namemap.get(clientName);
            if (vmidmap == null) {
                throw new HydraInternalException("No clients with name " + clientName);
            }
            for (Collection crs : vmidmap.values()) {
                count += crs.size();
            }
        }
        return count;
    }

    private int numRemainingClients(HashMap namemap) {
        int count = 0;
        for (HashMap vmidmap : namemap.values()) {
            for (Collection crs : vmidmap.values()) {
                count += crs.size();
            }
        }
        return count;
    }

    private Vector subgroupsFromGroups(Map groups) {
        Vector<HydraThreadSubgroup> subgroups = new Vector<HydraThreadSubgroup>();
        for (HydraThreadGroup tg : groups.values()) {
            for (HydraThreadSubgroup tsg : tg.getSubgroups()) {
                subgroups.add(tsg);
            }
        }
        if (ClientMapper.log().fineEnabled()) {
            ClientMapper.log().fine("\nSUBGROUPS:\n" + subgroups + "\n\n");
        }
        return subgroups;
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

