/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.BaseTaskScheduler;
import hydra.ClientDescription;
import hydra.ClientInfo;
import hydra.ClientMapper;
import hydra.ClientRecord;
import hydra.ClientVmInfo;
import hydra.ClientVmNotFoundException;
import hydra.ClientVmRecord;
import hydra.ConfigHashtable;
import hydra.DynamicActionException;
import hydra.DynamicConcurrentTaskScheduler;
import hydra.DynamicSerialTaskScheduler;
import hydra.HadoopInfo;
import hydra.HadoopMgr;
import hydra.HostAgentMgr;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroupInfo;
import hydra.HydraTimeoutException;
import hydra.Java;
import hydra.Log;
import hydra.MasterController;
import hydra.Nuker;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RebootBlackboard;
import hydra.RebootHostNotFoundException;
import hydra.RebootInfo;
import hydra.RebootPrms;
import hydra.RebootUtil;
import hydra.RemoteTestModuleIF;
import hydra.ResourceOperation;
import hydra.SimpleTaskScheduler;
import hydra.TestConfig;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ClientMgr {
    private static Map<Integer, ClientVmRecord> ClientVms;
    private static List<List<String>> ClientMapping;
    private static int nextVmid;
    private static int nextBaseThreadId;
    private static Object DynamicActionLock;
    private static boolean RefuseDynamicActions;
    private static int DynamicActionCount;

    protected static ClientVmRecord getClientVm(int vmid) {
        return ClientVms.get(new Integer(vmid));
    }

    public static Map getClientVms() {
        return ClientVms;
    }

    public static List<List<String>> getClientMapping() {
        return ClientMapping;
    }

    protected static Map createClients(Collection cds, Map tgs) {
        ClientMgr.log().info("Creating vm and client records");
        ClientVms = new HashMap<Integer, ClientVmRecord>();
        int count = 0;
        for (ClientDescription cd : cds) {
            String host = cd.getVmDescription().getHostDescription().getHostName();
            int numVms = cd.getVmQuantity();
            int numThreads = cd.getVmThreads();
            for (int j = 0; j < numVms; ++j) {
                int vmid = ClientMgr.nextVmid();
                int basetid = ClientMgr.nextBaseThreadId(numThreads);
                ClientVmRecord vm = new ClientVmRecord(vmid, basetid, cd);
                for (int tid = basetid; tid < basetid + numThreads; ++tid) {
                    ClientRecord cr = new ClientRecord(tid, vm);
                    vm.addClient(cr);
                    ++count;
                }
                ClientVms.put(new Integer(vmid), vm);
                ClientMgr.log().info("Created vm and client records: " + vm.toClientString());
            }
        }
        ClientMgr.log().info("Created " + ClientVms.size() + " total client VMs with " + count + " total client threads");
        if (tgs == null) {
            ClientMapping = null;
        } else {
            ClientMapper mapper = new ClientMapper(tgs);
            mapper.mapClients(ClientVms);
            ClientMapping = mapper.getMappingAsList(ClientVms);
            ClientMgr.log().info(mapper.getMappingAsString(ClientVms));
        }
        return ClientVms;
    }

    private static int nextVmid() {
        return ++nextVmid;
    }

    private static int nextBaseThreadId(int batchsize) {
        int base = nextBaseThreadId;
        nextBaseThreadId += batchsize;
        return base;
    }

    protected static void startClients(String purpose, Map vms) {
        ClientMgr.log().info("Starting " + vms.size() + " client VMs");
        for (ClientVmRecord vm : vms.values()) {
            ClientMgr.startClient(vm, purpose);
        }
        ClientMgr.log().info("Started " + vms.size() + " client VMs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startClient(ClientVmRecord vm, String purpose) {
        ClientMgr.log().info("Starting " + vm.toInfoString());
        ClientVmRecord clientVmRecord = vm;
        synchronized (clientVmRecord) {
            int state = vm.getState();
            if (state != 0) {
                throw new HydraInternalException("wrong vm state: " + state);
            }
            String masterHost = HostHelper.getCanonicalHostName();
            int masterPid = ProcessMgr.getProcessId();
            int pid = Java.javaRemoteTestModule(masterHost, masterPid, vm, purpose);
            vm.setPid(pid);
            vm.setState(1);
            vm.bumpVersion();
            vm.bumpJavaHome();
        }
        ClientMgr.log().info("Started " + vm.toInfoString());
    }

    protected static void waitForClientsToRegister(Map vms) {
        int waitSec = ClientMgr.tab().intAt(Prms.maxClientStartupWaitSec);
        ClientMgr.log().info("Waiting " + waitSec + " seconds for " + vms.size() + " client vms to register.");
        long timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        for (ClientVmRecord vm : vms.values()) {
            if (ClientMgr.waitForPendingClient(vm, timeoutMs)) continue;
            String s = "Failed to register client vms within " + waitSec + " seconds, such as " + vm;
            throw new HydraTimeoutException(s);
        }
        ClientMgr.log().info("Within " + waitSec + " seconds, all " + vms.size() + " client vms have registered.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForPendingClient(ClientVmRecord vm, long timeoutMs) {
        while (System.currentTimeMillis() < timeoutMs) {
            ClientVmRecord clientVmRecord = vm;
            synchronized (clientVmRecord) {
                if (vm.getState() == 2) {
                    return true;
                }
            }
            MasterController.sleepForMs(250);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer getVmid(String host, int pid) {
        boolean fine = Log.getLogWriter().fineEnabled();
        Iterator<ClientVmRecord> i = ClientVms.values().iterator();
        while (i.hasNext()) {
            ClientVmRecord vm;
            ClientVmRecord clientVmRecord = vm = i.next();
            synchronized (clientVmRecord) {
                if (fine) {
                    Log.getLogWriter().fine("Comparing " + host + ":" + pid + " to " + vm.getHost() + ":" + vm.getPid());
                }
                if (vm.getPid() == pid && HostHelper.compareHosts(host, vm.getHost())) {
                    if (fine) {
                        Log.getLogWriter().fine("Matched " + host + ":" + pid + " to " + vm.getHost() + ":" + vm.getPid());
                    }
                    return vm.getVmid();
                }
            }
        }
        if (fine) {
            Log.getLogWriter().fine("No match found for " + host + ":" + pid);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer getVmid(int pid) {
        Iterator<ClientVmRecord> i = ClientVms.values().iterator();
        while (i.hasNext()) {
            ClientVmRecord vm;
            ClientVmRecord clientVmRecord = vm = i.next();
            synchronized (clientVmRecord) {
                if (vm.getPid() == pid) {
                    return vm.getVmid();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getPid(int vmid) {
        ClientVmRecord vm;
        ClientVmRecord clientVmRecord = vm = ClientVms.get(new Integer(vmid));
        synchronized (clientVmRecord) {
            return vm.getPid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HydraThreadGroupInfo registerClient(int vmid, int tid, RemoteTestModuleIF mod) {
        ClientRecord cr;
        ClientVmRecord vm = ClientVms.get(new Integer(vmid));
        Serializable serializable = cr = vm.getClient(tid);
        synchronized (serializable) {
            cr.setTestModule(mod);
        }
        serializable = vm;
        synchronized (serializable) {
            vm.registerClient();
            if (vm.fullyRegistered()) {
                vm.setState(2);
            }
        }
        return new HydraThreadGroupInfo(cr.getThreadGroupName(), cr.getThreadGroupId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientDisconnect(int vmid) {
        ClientVmRecord vm;
        ClientVmRecord clientVmRecord = vm = ClientMgr.getClientVm(vmid);
        synchronized (clientVmRecord) {
            vm.registerDisconnect();
        }
    }

    protected static void stopClients(Map vms, boolean closeConnection, boolean runShutdownHook) {
        ClientMgr.log().info("Issuing stop request to " + vms.size() + " client VMs");
        for (ClientVmRecord vm : vms.values()) {
            ClientMgr.stopClient(vm, closeConnection, runShutdownHook);
        }
        ClientMgr.log().info("Issued stop request to " + vms.size() + " client VMs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopClient(ClientVmRecord vm, boolean closeConnection, boolean runShutdownHook) {
        ClientMgr.log().info("Issuing stop request to " + vm.toInfoString());
        ClientVmRecord clientVmRecord = vm;
        synchronized (clientVmRecord) {
            if (vm.getPid() == ClientVmRecord.NO_PID) {
                ClientMgr.log().info(vm.toInfoString() + " is already stopped");
                return;
            }
            ClientRecord cr = vm.getRepresentativeClient();
            try {
                cr.getTestModule().shutDownVM(closeConnection, runShutdownHook);
            }
            catch (UnmarshalException unmarshalException) {
            }
            catch (RemoteException e) {
                String reason = "Unable to reach client " + cr + " in " + vm;
                throw new HydraRuntimeException(reason, e);
            }
        }
        ClientMgr.log().info("Issued stop request to " + vm.toInfoString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disconnectClient(ClientVmRecord vm) {
        ClientMgr.log().info("Issuing disconnect request to " + vm.toInfoString());
        ClientVmRecord clientVmRecord = vm;
        synchronized (clientVmRecord) {
            if (vm.getState() == 3) {
                ClientMgr.log().info(vm.toInfoString() + " is dead and cannot disconnect");
                return;
            }
            if (vm.getState() == 4) {
                ClientMgr.log().info(vm.toInfoString() + " is already disconnected");
                return;
            }
            ClientRecord cr = vm.getRepresentativeClient();
            try {
                cr.getTestModule().disconnectVM();
            }
            catch (RemoteException e) {
                String reason = "Unable to reach client " + cr + " in " + vm;
                throw new HydraRuntimeException(reason, e);
            }
        }
        ClientMgr.log().info("Issued disconnect request to " + vm.toInfoString());
    }

    protected static void runClientShutdownHooks(Map vms) {
        if (ClientMgr.tab().get(Prms.clientShutdownHook) != null) {
            ClientMgr.log().info("Printing process stacks in " + vms.size() + " client VMs prior to running client shutdown hooks");
            MasterController.dumpStacks(2);
            ClientMgr.log().info("Running client shutdown hooks in " + vms.size() + " client VMs");
            int waitSec = ClientMgr.tab().intAt(Prms.maxClientShutdownWaitSec);
            Vector<1> ops = new Vector<1>();
            Vector<String> records = new Vector<String>();
            for (final ClientVmRecord vm : vms.values()) {
                Runnable op = new Runnable(){

                    @Override
                    public void run() {
                        ClientMgr.runClientShutdownHook(vm);
                    }
                };
                ops.add(op);
                records.add("");
            }
            ResourceOperation.doOps(ops, "runShutdownHook", "client", records, waitSec * 1000, true, 0, true);
            ClientMgr.log().info("Ran client shutdown hooks in " + vms.size() + " client VMs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runClientShutdownHook(ClientVmRecord vm) {
        ClientMgr.log().info("Running client shutdown hook in " + vm.toInfoString());
        ClientRecord cr = null;
        ClientVmRecord clientVmRecord = vm;
        synchronized (clientVmRecord) {
            if (vm.getPid() == ClientVmRecord.NO_PID) {
                ClientMgr.log().info(vm.toInfoString() + " is stopped: can't run client shutdown hook");
                return;
            }
            cr = vm.getRepresentativeClient();
        }
        try {
            cr.getTestModule().runShutdownHook();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (RemoteException e) {
            String reason = "Unable to reach client " + cr + " in " + vm;
            ClientMgr.log().severe(reason, (Throwable)e);
        }
        ClientMgr.log().info("Ran client shutdown hook in " + vm.toInfoString());
    }

    protected static void waitForClientsToDie(Map vms) {
        int waitSec = ClientMgr.tab().intAt(Prms.maxClientShutdownWaitSec);
        ClientMgr.log().info("Waiting " + waitSec + " seconds for " + vms.size() + " client VMs to stop.");
        long timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        for (ClientVmRecord vm : vms.values()) {
            if (ClientMgr.waitForClientToDie(vm, timeoutMs)) continue;
            String s = "Failed to stop client vms within " + waitSec + " seconds, starting with " + vm;
            throw new HydraTimeoutException(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForClientToDie(ClientVmRecord vm, long timeoutMs) {
        int pid = vm.getPid();
        if (pid == ClientVmRecord.NO_PID) {
            return true;
        }
        String host = vm.getHost();
        do {
            if (!ProcessMgr.processExists(host, pid)) {
                ClientVmRecord clientVmRecord = vm;
                synchronized (clientVmRecord) {
                    HostDescription hd = vm.getClientDescription().getVmDescription().getHostDescription();
                    Nuker.getInstance().removePID(hd, pid);
                    vm.setState(3);
                    vm.setPid(ClientVmRecord.NO_PID);
                }
                return true;
            }
            MasterController.sleepForMs(250);
        } while (System.currentTimeMillis() < timeoutMs);
        return false;
    }

    protected static void waitForClientToDisconnect(ClientVmRecord vm) {
        int waitSec = ClientMgr.tab().intAt(Prms.maxClientShutdownWaitSec);
        ClientMgr.log().info("Waiting " + waitSec + " seconds for client VM " + vm + " to disconnect.");
        long timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        if (!ClientMgr.waitForClientToDisconnect(vm, timeoutMs)) {
            String s = "Failed to disconnect client vm within " + waitSec + " seconds: " + vm;
            throw new HydraTimeoutException(s);
        }
    }

    private static boolean waitForClientToDisconnect(ClientVmRecord vm, long timeoutMs) {
        int pid = vm.getPid();
        if (pid == ClientVmRecord.NO_PID) {
            return true;
        }
        do {
            if (vm.registeredDisconnect()) {
                Log.getLogWriter().info(vm + " has registered disconnect");
                return true;
            }
            MasterController.sleepForMs(250);
        } while (System.currentTimeMillis() < timeoutMs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printProcessStacks() {
        ProcessMgr.printProcessStacks(HostHelper.getLocalHost(), ProcessMgr.getProcessId());
        if (ClientVms == null) {
            return;
        }
        Iterator<ClientVmRecord> i = ClientVms.values().iterator();
        while (i.hasNext()) {
            ClientVmRecord vm;
            ClientVmRecord clientVmRecord = vm = i.next();
            synchronized (clientVmRecord) {
                if (vm.getState() == 2) {
                    ClientMgr.printProcessStacks(vm);
                }
            }
        }
    }

    protected static void printProcessStacks(ClientVmRecord vm) {
        ProcessMgr.printProcessStacks(vm.getHost(), vm.getPid());
    }

    protected static ClientVmInfo reserveClientVmForStop(String srcName, int srcVmid, int syncMode, int stopMode, ClientVmInfo target) throws ClientVmNotFoundException {
        String name = srcName + " Dynamic Client VM Stopper";
        Thread.currentThread().setName(name);
        ClientVmRecord srcVm = ClientVms.get(new Integer(srcVmid));
        if (srcVm == null) {
            throw new HydraInternalException("Missing source vm_" + srcVmid);
        }
        Set matches = ClientMgr.matchClientVm(target);
        if (matches == null) {
            throw new IllegalArgumentException("No such VM exists: " + target);
        }
        ClientMgr.preventDeadlock(srcVm, syncMode, stopMode, target, matches);
        return ClientMgr.reserveClientVm(2, srcVm, target, matches);
    }

    protected static ClientVmInfo reserveClientVmForStart(String srcName, int srcVmid, ClientVmInfo target) throws ClientVmNotFoundException {
        String name = srcName + " Dynamic Client VM Starter";
        Thread.currentThread().setName(name);
        ClientVmRecord srcVm = ClientVms.get(new Integer(srcVmid));
        if (srcVm == null) {
            throw new HydraInternalException("Missing source vm_" + srcVmid);
        }
        Set matches = ClientMgr.matchClientVm(target);
        if (matches == null) {
            throw new IllegalArgumentException("No such VM exists: " + target);
        }
        try {
            return ClientMgr.reserveClientVm(0, srcVm, target, matches);
        }
        catch (ClientVmNotFoundException e) {
            return ClientMgr.reserveClientVm(4, srcVm, target, matches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientVmInfo reserveClientVm(int state, ClientVmRecord srcVm, ClientVmInfo target, Set matches) throws ClientVmNotFoundException {
        for (ClientVmRecord trgVm : matches) {
            Object object = DynamicActionLock;
            synchronized (object) {
                ClientVmInfo info;
                ClientVmRecord clientVmRecord;
                ClientVmRecord clientVmRecord2;
                if (srcVm == trgVm) {
                    clientVmRecord2 = trgVm;
                    synchronized (clientVmRecord2) {
                        ClientVmInfo info2 = ClientMgr.reserveClientVm(state, srcVm, trgVm);
                        if (info2 != null) {
                            return info2;
                        }
                    }
                }
                if (srcVm.getVmid() < trgVm.getVmid()) {
                    clientVmRecord2 = srcVm;
                    synchronized (clientVmRecord2) {
                        clientVmRecord = trgVm;
                        synchronized (clientVmRecord) {
                            info = ClientMgr.reserveClientVm(state, srcVm, trgVm);
                            if (info != null) {
                                return info;
                            }
                        }
                    }
                }
                if (srcVm.getVmid() > trgVm.getVmid()) {
                    clientVmRecord2 = trgVm;
                    synchronized (clientVmRecord2) {
                        clientVmRecord = srcVm;
                        synchronized (clientVmRecord) {
                            info = ClientMgr.reserveClientVm(state, srcVm, trgVm);
                            if (info != null) {
                                return info;
                            }
                        }
                    }
                }
            }
        }
        String s = "All VMs matching " + target + " are unavailable to " + srcVm;
        throw new ClientVmNotFoundException(s);
    }

    private static void preventDeadlock(ClientVmRecord srcVm, int syncMode, int stopMode, ClientVmInfo target, Set matches) {
        if (syncMode == 0 && (stopMode == -23 || stopMode == -22)) {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                ClientVmRecord trgVm = (ClientVmRecord)i.next();
                if (!srcVm.getVmid().equals(trgVm.getVmid())) continue;
                i.remove();
            }
            if (matches.size() == 0) {
                String s = srcVm + " cannot stop itself synchronously using an \"exit\"" + " mode without deadlocking.  Use an asynchronous method or" + " a \"kill\" mode.";
                throw new IllegalArgumentException(s);
            }
        }
    }

    private static Set matchClientVm(ClientVmInfo target) {
        HashSet<ClientVmRecord> matches = null;
        for (ClientVmRecord vm : ClientVms.values()) {
            if (!vm.matches(target)) continue;
            if (matches == null) {
                matches = new HashSet<ClientVmRecord>();
            }
            matches.add(vm);
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientVmInfo reserveClientVm(int state, ClientVmRecord srcVm, ClientVmRecord trgVm) throws ClientVmNotFoundException {
        if (srcVm.reserved()) {
            String s = srcVm.getInfo() + " is the target of a dynamic action";
            throw new ClientVmNotFoundException(s);
        }
        if (trgVm.getState() == state && !trgVm.reserved() && !trgVm.acting()) {
            Object object = DynamicActionLock;
            synchronized (object) {
                if (RefuseDynamicActions) {
                    String s = "Dynamic action refused.  Test is terminating in failure.";
                    throw new DynamicActionException(s);
                }
                ++DynamicActionCount;
            }
            if (srcVm != trgVm) {
                srcVm.incDynamicActionCount();
            }
            trgVm.reserve();
            return trgVm.getInfo();
        }
        return null;
    }

    protected static void stopClientVm(final String srcName, final int srcVmid, final int srcActionId, final String reason, final int syncMode, final int stopMode, final int startMode, final ClientVmInfo target) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ClientMgr._stopClientVm(srcName, srcVmid, srcActionId, reason, syncMode, stopMode, startMode, target);
            }
        };
        String name = srcName + " Dynamic Client VM Stopper";
        Thread t = new Thread(action, name);
        t.start();
    }

    protected static void startClientVm(final String srcName, final int srcVmid, final int srcActionId, final String reason, final int syncMode, final ClientVmInfo target) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ClientMgr._startClientVm(srcName, srcVmid, srcActionId, reason, syncMode, target);
            }
        };
        String name = srcName + " Dynamic Client VM Starter";
        Thread t = new Thread(action, name);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _stopClientVm(String srcName, int srcVmid, int srcActionId, String reason, int syncMode, int stopMode, int startMode, ClientVmInfo target) {
        try {
            ClientVmRecord srcVm = ClientVms.get(new Integer(srcVmid));
            ClientVmRecord trgVm = ClientVms.get(target.getVmid());
            ClientVmRecord clientVmRecord = srcVm;
            synchronized (clientVmRecord) {
                srcVm.decDynamicActionCount();
            }
            ClientMgr.stopClientVm(srcName, srcVmid, srcVm, srcActionId, reason, syncMode, stopMode, startMode, target, trgVm);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            BaseTaskScheduler.processDynamicActionError(t);
        }
        finally {
            Object object = DynamicActionLock;
            synchronized (object) {
                --DynamicActionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _startClientVm(String srcName, int srcVmid, int srcActionId, String reason, int syncMode, ClientVmInfo target) {
        try {
            ClientVmRecord srcVm = ClientVms.get(new Integer(srcVmid));
            ClientVmRecord trgVm = ClientVms.get(target.getVmid());
            ClientVmRecord clientVmRecord = srcVm;
            synchronized (clientVmRecord) {
                srcVm.decDynamicActionCount();
            }
            ClientMgr.startClientVm(srcName, srcVmid, srcVm, srcActionId, reason, syncMode, target, trgVm);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            BaseTaskScheduler.processDynamicActionError(t);
        }
        finally {
            Object object = DynamicActionLock;
            synchronized (object) {
                --DynamicActionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopClientVm(String srcName, int srcVmid, ClientVmRecord srcVm, int srcActionId, String reason, int syncMode, int stopMode, int startMode, ClientVmInfo target, ClientVmRecord trgVm) {
        if (stopMode == -24) {
            ClientMgr.log().info("Disconnecting " + target + " because " + reason);
        } else {
            ClientMgr.log().info("Stopping " + target + " because " + reason);
        }
        int srcPid = srcVm.getPid();
        switch (stopMode) {
            case -21: 
            case -20: {
                ClientMgr.killClientVm(trgVm, stopMode);
                break;
            }
            case -23: 
            case -22: {
                ClientMgr.exitClientVm(trgVm, stopMode);
                break;
            }
            case -24: {
                ClientMgr.disconnectClientVm(trgVm, stopMode);
                break;
            }
            default: {
                throw new HydraInternalException("Illegal stop mode: " + stopMode);
            }
        }
        String s = "Stopped " + target + " because " + reason + ". ";
        switch (startMode) {
            case -32: {
                if (stopMode == -24) {
                    ClientMgr.log().info(s + "Never reconnecting " + trgVm + ".");
                    ClientVmRecord clientVmRecord = trgVm;
                    synchronized (clientVmRecord) {
                        trgVm.resetForDisconnect();
                        break;
                    }
                }
                ClientMgr.log().info(s + "Never restarting " + trgVm + ".");
                ClientVmRecord clientVmRecord = trgVm;
                synchronized (clientVmRecord) {
                    trgVm.reset();
                    trgVm.setState(3);
                    break;
                }
            }
            case -31: {
                if (stopMode == -24) {
                    ClientMgr.log().info(s + "Reconnecting " + trgVm + " on demand.");
                    ClientVmRecord clientVmRecord = trgVm;
                    synchronized (clientVmRecord) {
                        trgVm.resetForDisconnect();
                        break;
                    }
                }
                ClientMgr.log().info(s + "Restarting " + trgVm + " on demand.");
                ClientVmRecord clientVmRecord = trgVm;
                synchronized (clientVmRecord) {
                    trgVm.reset();
                    break;
                }
            }
            case -30: {
                if (stopMode == -24) {
                    ClientMgr.log().info(s + "Immediately reconnecting " + trgVm + ".");
                    ClientVmRecord clientVmRecord = trgVm;
                    synchronized (clientVmRecord) {
                        trgVm.resetForDisconnect();
                        trgVm.reserve();
                        break;
                    }
                }
                ClientMgr.log().info(s + "Immediately restarting " + trgVm + ".");
                ClientVmRecord clientVmRecord = trgVm;
                synchronized (clientVmRecord) {
                    trgVm.reset();
                    trgVm.reserve();
                    break;
                }
            }
            default: {
                if (stopMode == -24) {
                    ClientMgr.log().info(s + "Sleeping " + startMode + " ms before reconnecting " + trgVm + ".");
                    ClientVmRecord clientVmRecord = trgVm;
                    synchronized (clientVmRecord) {
                        trgVm.resetForDisconnect();
                        trgVm.reserve();
                        break;
                    }
                }
                ClientMgr.log().info(s + "Sleeping " + startMode + " ms before restarting " + trgVm + ".");
                ClientVmRecord clientVmRecord = trgVm;
                synchronized (clientVmRecord) {
                    trgVm.reset();
                    trgVm.reserve();
                    break;
                }
            }
        }
        if (syncMode == 0 && !srcVm.equals(trgVm)) {
            srcVm.notifyDynamicActionComplete(srcActionId, srcPid);
        }
        switch (startMode) {
            case -32: {
                break;
            }
            case -31: {
                break;
            }
            case -30: {
                ClientMgr.startClientVm(srcName, srcVmid, srcVm, srcActionId, reason, syncMode, target, trgVm);
                break;
            }
            default: {
                MasterController.sleepForMs(startMode);
                ClientMgr.startClientVm(srcName, srcVmid, srcVm, srcActionId, reason, syncMode, target, trgVm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startClientVm(String srcName, int srcVmid, ClientVmRecord srcVm, int srcActionId, String reason, int syncMode, ClientVmInfo target, ClientVmRecord trgVm) {
        boolean disconnected = trgVm.isDisconnected();
        if (disconnected) {
            ClientMgr.log().info("Reconnecting " + target + " because " + reason);
        } else {
            ClientMgr.log().info("Starting " + target + " because " + reason);
        }
        int srcPid = srcVm.getPid();
        boolean passed = ClientMgr.doDynamicInitTasks(trgVm);
        if (!passed) {
            throw new DynamicActionException("dynamic start failed");
        }
        ClientVmRecord clientVmRecord = trgVm;
        synchronized (clientVmRecord) {
            trgVm.unreserve();
        }
        if (disconnected) {
            ClientMgr.log().info("Reconnected " + target + " because " + reason);
        } else {
            ClientMgr.log().info("Started " + target + " because " + reason);
        }
        if (syncMode == 0) {
            srcVm.notifyDynamicActionComplete(srcActionId, srcPid);
        }
    }

    private static void killClientVm(ClientVmRecord vm, int stopMode) {
        switch (stopMode) {
            case -20: {
                ProcessMgr.shutdownProcess(vm.getHost(), vm.getPid());
                break;
            }
            case -21: {
                ProcessMgr.killProcess(vm.getHost(), vm.getPid());
            }
        }
        int waitSec = ClientMgr.tab().intAt(Prms.maxClientShutdownWaitSec);
        long timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        ClientMgr.log().info("Waiting " + waitSec + " seconds for " + vm + " to die");
        if (!ClientMgr.waitForClientToDie(vm, timeoutMs)) {
            String s = "Failed to stop " + vm + " within " + waitSec + " seconds";
            throw new HydraTimeoutException(s);
        }
        ClientMgr.log().info("Client " + vm + " has died");
        BaseTaskScheduler.fakeKillResults(vm);
    }

    private static void exitClientVm(ClientVmRecord vm, int stopMode) {
        boolean passed = false;
        switch (stopMode) {
            case -22: {
                passed = ClientMgr.doDynamicCloseTasks(vm, true, true);
                break;
            }
            case -23: {
                passed = ClientMgr.doDynamicCloseTasks(vm, false, true);
            }
        }
        if (!passed) {
            throw new DynamicActionException("dynamic stop failed");
        }
    }

    private static void disconnectClientVm(ClientVmRecord vm, int stopMode) {
        boolean passed = false;
        switch (stopMode) {
            case -24: {
                passed = ClientMgr.doDynamicCloseTasks(vm, true, false);
            }
        }
        if (!passed) {
            throw new DynamicActionException("dynamic disconnect failed");
        }
    }

    protected static ClientVmRecord bounceUnitTestVm(int pid) throws RemoteException {
        try {
            return ClientMgr._bounceUnitTestVm(pid);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RemoteException("While bouncing unit test VM", t);
        }
    }

    private static ClientVmRecord _bounceUnitTestVm(int pid) {
        Integer vmid = ClientMgr.getVmid(pid);
        if (vmid == null) {
            String s = "No VM found with PID " + pid;
            throw new HydraInternalException(s);
        }
        ClientVmRecord vm = ClientMgr.getClientVm(vmid);
        ClientMgr.log().info("Bouncing " + vm.toInfoString());
        ProcessMgr.killProcess(vm.getHost(), vm.getPid());
        int waitSec = ClientMgr.tab().intAt(Prms.maxClientShutdownWaitSec);
        long timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        ClientMgr.log().info("Waiting " + waitSec + " seconds for " + vm + " to die");
        if (!ClientMgr.waitForClientToDie(vm, timeoutMs)) {
            String s = "Failed to stop " + vm + " within " + waitSec + " seconds";
            throw new HydraTimeoutException(s);
        }
        vm.reset();
        ClientMgr.log().info("Client " + vm + " has died...restarting");
        ClientMgr.startClient(vm, null);
        waitSec = ClientMgr.tab().intAt(Prms.maxClientStartupWaitSec);
        timeoutMs = System.currentTimeMillis() + (long)(waitSec * 1000);
        ClientMgr.waitForPendingClient(vm, timeoutMs);
        ClientMgr.log().info("Client " + vm + " has registered and is ready for use");
        ClientMgr.log().info("Bounced " + vm.toInfoString());
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doDynamicInitTasks(ClientVmRecord vm) {
        Vector tasks = TestConfig.getInstance().getDynamicInitTasksClone();
        SimpleTaskScheduler ts = null;
        boolean halt = TestConfig.tab().booleanAt(Prms.haltIfBadResult);
        ts = TestConfig.tab().booleanAt(Prms.doInitTasksSequentially) ? new DynamicSerialTaskScheduler("DynamicInitTasks", tasks, null, vm, true) : new DynamicConcurrentTaskScheduler("DynamicInitTasks", tasks, null, vm, true);
        if (vm.isDisconnected()) {
            ClientVmRecord clientVmRecord = vm;
            synchronized (clientVmRecord) {
                vm.setState(2);
            }
        } else {
            ts.startClients();
        }
        boolean passed = ts.executeTasks(ClientMgr.tab().booleanAt(Prms.haltIfBadResult), ClientMgr.tab().longAt(Prms.maxResultWaitSec));
        ts.printReport();
        return passed;
    }

    private static boolean doDynamicCloseTasks(ClientVmRecord vm, boolean disconnect, boolean stop) {
        Vector tasks = TestConfig.getInstance().getDynamicCloseTasksClone();
        DynamicConcurrentTaskScheduler ts = new DynamicConcurrentTaskScheduler("DynamicCloseTasks", tasks, null, vm, disconnect);
        boolean passed = ts.executeTasks(ClientMgr.tab().booleanAt(Prms.haltIfBadResult), ClientMgr.tab().longAt(Prms.maxResultWaitSec));
        if (stop) {
            ts.stopClients();
        } else {
            ClientMgr.disconnectClient(vm);
            ClientMgr.waitForClientToDisconnect(vm);
        }
        ts.printReport();
        return passed;
    }

    protected static Vector getClientVmids() {
        Vector<Integer> vmids = new Vector<Integer>();
        for (ClientVmRecord vm : ClientVms.values()) {
            vmids.add(vm.getVmid());
        }
        return vmids;
    }

    protected static Vector getOtherClientVmids(int vmid) {
        Vector<Integer> vmids = new Vector<Integer>();
        for (ClientVmRecord vm : ClientVms.values()) {
            if (vm.getVmid() == vmid) continue;
            vmids.add(vm.getVmid());
        }
        return vmids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean clientVmsPermanentlyStopped() {
        Object object = DynamicActionLock;
        synchronized (object) {
            if (ClientMgr.hasDynamicActions()) {
                return false;
            }
            Iterator<ClientVmRecord> i = ClientVms.values().iterator();
            while (i.hasNext()) {
                ClientVmRecord vm;
                ClientVmRecord clientVmRecord = vm = i.next();
                synchronized (clientVmRecord) {
                    if (vm.getPid() != ClientVmRecord.NO_PID) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void refuseDynamicActions() {
        Object object = DynamicActionLock;
        synchronized (object) {
            RefuseDynamicActions = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean hasDynamicActions() {
        Object object = DynamicActionLock;
        synchronized (object) {
            return DynamicActionCount != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RebootInfo reserveForReboot(String srcName, int srcVmid, String target, boolean liveOnly) throws RebootHostNotFoundException {
        String name = srcName + " Dynamic Rebooter";
        Thread.currentThread().setName(name);
        RebootInfo result = null;
        ClientVmRecord srcVm = ClientVms.get(srcVmid);
        if (srcVm == null) {
            throw new HydraInternalException("Missing source vm_" + srcVmid);
        }
        String srcHost = srcVm.getHost();
        if (HostHelper.isLocalHost(target)) {
            String s = "Master controller is running on " + target;
            throw new RebootHostNotFoundException(s);
        }
        if (srcHost.equals(target)) {
            String s = "Hydra client " + srcName + " cannot reboot its own host: " + target;
            throw new RebootHostNotFoundException(s);
        }
        String baseHost = RebootPrms.getBaseHost(target);
        HostDescription hd = TestConfig.getInstance().getAnyPhysicalHostDescription(baseHost);
        if (hd.getOSType() != HostHelper.OSType.unix) {
            String s = "Host " + target + " is running on an unsupported " + "operating system: " + (Object)((Object)hd.getOSType());
            throw new RebootHostNotFoundException(s);
        }
        if (!RebootUtil.isAlive(target)) {
            String s = "Host " + target + " is either not a virtual machine " + "or is not running on " + RebootPrms.getBaseHost(target);
            throw new RebootHostNotFoundException(s);
        }
        ArrayList<ClientInfo> reservedClients = new ArrayList<ClientInfo>();
        List<Object> reservedHadoops = new ArrayList();
        Object object = DynamicActionLock;
        synchronized (object) {
            ClientVmRecord vm;
            RebootInfo rebootInfo = (RebootInfo)RebootBlackboard.getInstance().getSharedMap().get(target);
            if (rebootInfo != null) {
                String s = "RebootInfo for " + target + " has not been cleared";
                throw new RebootHostNotFoundException(s);
            }
            TreeSet<Integer> vmids = new TreeSet<Integer>();
            vmids.addAll(ClientVms.keySet());
            for (Integer vmid : vmids) {
                ClientInfo clientInfo;
                String s;
                vm = ClientVms.get(vmid);
                if (!vm.getHost().equals(target)) continue;
                if (vm.acting()) {
                    s = "At least one hydra client on " + target + " is already the source of a dynamic action: " + vm;
                    throw new RebootHostNotFoundException(s);
                }
                if (vm.reserved()) {
                    s = "At least one hydra client on " + target + " is already the target of a dynamic action: " + vm;
                    throw new RebootHostNotFoundException(s);
                }
                if (liveOnly && vm.isLive()) {
                    ClientMgr.log().info("Reserving live hydra client: " + vm.toStateString());
                    clientInfo = new ClientInfo(vm.getVmid(), vm.getClientDescription());
                    reservedClients.add(clientInfo);
                    continue;
                }
                if (!vm.isDead()) {
                    ClientMgr.log().info("Reserving temporarily stopped hydra client: " + vm.toStateString());
                    clientInfo = new ClientInfo(vm.getVmid(), vm.getClientDescription());
                    reservedClients.add(clientInfo);
                    continue;
                }
                ClientMgr.log().info("Not reserving permanently dead hydra client: " + vm.toStateString());
            }
            for (ClientInfo reservedClient : reservedClients) {
                vm = ClientVms.get(reservedClient.getVmid());
                vm.reserve();
                ClientMgr.log().info("Reserved " + vm.toStateString() + " on " + target + " for reboot");
            }
            reservedHadoops = HadoopMgr.getHadoopInfos(target, liveOnly);
            if (reservedClients.size() + reservedHadoops.size() == 0) {
                String s;
                if (liveOnly) {
                    s = "No live hydra-managed processes found on " + target;
                    throw new RebootHostNotFoundException(s);
                }
                s = "Only permanently dead hydra-managed processes found on " + target;
                throw new RebootHostNotFoundException(s);
            }
            srcVm.incDynamicActionCount();
            ++DynamicActionCount;
            ClientMgr.log().info("Reserved hydra client processes: " + reservedClients);
            ClientMgr.log().info("Reserved hydra hadoop processes: " + reservedHadoops);
            result = new RebootInfo(target, reservedClients, reservedHadoops);
            RebootBlackboard.getInstance().getSharedMap().put(target, result);
            ClientMgr.log().info("Put " + target + " with " + result + " on reboot blackboard");
        }
        return result;
    }

    protected static void reboot(final String srcName, final int srcVmid, final int srcActionId, final String reason, final RebootInfo target) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ClientMgr._reboot(srcName, srcVmid, srcActionId, reason, target);
            }
        };
        String name = srcName + " Dynamic Rebooter";
        Thread t = new Thread(action, name);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _reboot(String srcName, int srcVmid, int srcActionId, String reason, RebootInfo target) {
        try {
            ClientVmRecord srcVm = ClientVms.get(srcVmid);
            ClientVmRecord clientVmRecord = srcVm;
            synchronized (clientVmRecord) {
                srcVm.decDynamicActionCount();
            }
            ClientMgr.reboot(srcVm, srcActionId, reason, target);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            BaseTaskScheduler.processDynamicActionError(t);
        }
        finally {
            Object object = DynamicActionLock;
            synchronized (object) {
                --DynamicActionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reboot(ClientVmRecord srcVm, int srcActionId, String reason, RebootInfo target) throws RemoteException {
        String host = target.getHost();
        ClientMgr.log().info("Rebooting " + host + " because " + reason);
        int srcPid = srcVm.getPid();
        ClientMgr.reboot(target);
        String s = "Rebooted " + host + " because " + reason + ". ";
        ClientMgr.log().info(s + "Restarting" + target.toProcessList() + " on demand.");
        for (ClientInfo client : target.getClients()) {
            ClientVmRecord trgVm;
            ClientVmInfo info = client.getClientVmInfo();
            ClientVmRecord clientVmRecord = trgVm = ClientVms.get(info.getVmid());
            synchronized (clientVmRecord) {
                trgVm.reset();
            }
        }
        ClientMgr.log().info("Notifying " + srcVm + " with PID " + srcPid + " that reboot is complete");
        srcVm.notifyDynamicActionComplete(srcActionId, srcPid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reboot(RebootInfo target) throws RemoteException {
        String host = target.getHost();
        String nukeCommand = HostAgentMgr.getNukePIDCommand(host);
        RebootUtil.reboot(host);
        Nuker.getInstance().removePIDNoDumps(nukeCommand);
        HostAgentMgr.restartHostAgent(host);
        for (ClientInfo client : target.getClients()) {
            ClientVmRecord vm;
            ClientVmInfo info = client.getClientVmInfo();
            ClientVmRecord clientVmRecord = vm = ClientVms.get(info.getVmid());
            synchronized (clientVmRecord) {
                int pid = vm.getPid();
                if (pid != ClientVmRecord.NO_PID) {
                    HostDescription hd = vm.getClientDescription().getVmDescription().getHostDescription();
                    Nuker.getInstance().removePID(hd, pid);
                }
                BaseTaskScheduler.fakeKillResults(vm);
                vm.reset();
            }
        }
        for (HadoopInfo hadoop : target.getHadoops()) {
            HadoopMgr.removeHadoop(hadoop);
        }
        ClientMgr.log().info("Host " + host + " has rebooted");
    }

    private static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    static {
        nextVmid = -1;
        nextBaseThreadId = 0;
        DynamicActionLock = new Object();
        RefuseDynamicActions = false;
        DynamicActionCount = 0;
    }
}

