/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BaseTaskScheduler;
import hydra.ClientDescription;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.TestTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ClientNameTaskScheduler
extends BaseTaskScheduler {
    public ClientNameTaskScheduler(String name, Vector tasks, String purpose) {
        super(name, tasks, purpose);
    }

    @Override
    public void createClients(Map cds, Map tgs) {
        HashMap tmpcds = new HashMap();
        for (TestTask tt : this.tasks) {
            Vector clientNames = tt.getClientNames();
            for (String clientName : clientNames) {
                tmpcds.put(clientName, cds.get(clientName));
            }
        }
        HashMap<String, ClientDescription> newcds = new HashMap<String, ClientDescription>();
        for (ClientDescription tmpcd : tmpcds.values()) {
            ClientDescription newcd = tmpcd.copy();
            newcd.setVmQuantity(1);
            newcd.setVmThreads(1);
            newcds.put(newcd.getName(), newcd);
        }
        super.createClients(newcds, tgs);
    }

    @Override
    protected boolean executeTasks() {
        int count = 0;
        long now = 0L;
        do {
            count = 0;
            now = System.currentTimeMillis();
            for (ClientVmRecord vm : this.vms.values()) {
                for (ClientRecord client : vm.getClients().values()) {
                    if (!this.schedule(client, now)) continue;
                    ++count;
                }
            }
        } while (!this.terminateScheduling(count, now));
        return this.schedulerResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule(ClientRecord client, long now) {
        ClientRecord clientRecord = client;
        synchronized (clientRecord) {
            if (!client.isBusy()) {
                if (client.getTaskIndex() == this.tasks.size()) {
                    return false;
                }
                for (int i = client.getTaskIndex() + 1; i < this.tasks.size(); ++i) {
                    TestTask task = (TestTask)this.tasks.get(i);
                    if (!task.getClientNames().contains(client.vm().getClientName())) continue;
                    client.setBusy(true);
                    client.setTask(task);
                    client.setStartTime(now);
                    TestTask testTask = task;
                    synchronized (testTask) {
                        task.incrementNumTimesInUse();
                    }
                    this.assignTask(client, task);
                    return true;
                }
                client.setTaskIndex(this.tasks.size());
                return false;
            }
            return false;
        }
    }

    private boolean terminateScheduling(int count, long now) {
        if (!(this.exceededMaxResultWaitSec(now) || this.hadFatalTaskErrorAndHaltOrder() || this.hadStatMonitorError() || this.executedAllTasks())) {
            if (count == 0) {
                this.printSchedulingReport(now);
                this.pauseScheduling();
            }
            return false;
        }
        return true;
    }

    private boolean executedAllTasks() {
        for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                if (client.getTaskIndex() == this.tasks.size()) continue;
                return false;
            }
        }
        return true;
    }
}

