/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientVmRecord;
import hydra.HydraInternalException;
import hydra.HydraThreadGroup;
import hydra.MasterController;
import hydra.RemoteTestModuleIF;
import hydra.TestTask;
import java.io.Serializable;

public class ClientRecord
implements Comparable,
Serializable {
    private int tid = -1;
    private RemoteTestModuleIF mod;
    private transient ClientVmRecord vm;
    private transient HydraThreadGroup tg;
    private String tgname;
    private int tgid = -1;
    private String cstr;
    private volatile boolean busy;
    private boolean hadError;
    private TestTask task;
    private volatile int taskIndex;
    private volatile long startTime;

    protected ClientRecord(int tid, ClientVmRecord vm) {
        this.tid = tid;
        this.vm = vm;
        this.initCachedString();
    }

    protected void initRuntime() {
        this.busy = false;
        this.hadError = false;
        this.taskIndex = -1;
        this.task = null;
        this.startTime = 999999L;
    }

    public ClientVmRecord vm() {
        return this.vm;
    }

    public int getTid() {
        return this.tid;
    }

    public RemoteTestModuleIF getTestModule() {
        return this.mod;
    }

    protected void setTestModule(RemoteTestModuleIF mod) {
        this.mod = mod;
    }

    public HydraThreadGroup getThreadGroup() {
        return this.tg;
    }

    protected void setThreadGroup(HydraThreadGroup tg) {
        this.tg = tg;
    }

    public String getThreadGroupName() {
        return this.tgname;
    }

    protected void setThreadGroupName(String tgname) {
        this.tgname = tgname;
    }

    public int getThreadGroupId() {
        return this.tgid;
    }

    protected void setThreadGroupId(int tgid) {
        this.tgid = tgid;
    }

    protected boolean isBusy() {
        return this.busy;
    }

    protected void setBusy(boolean aBusy) {
        if (this.busy == aBusy) {
            throw new HydraInternalException(this + " already has busy set " + this.busy);
        }
        this.busy = aBusy;
    }

    protected boolean hadError() {
        return this.hadError;
    }

    protected void setError() {
        if (this.hadError) {
            throw new HydraInternalException(this + " already has error set");
        }
        this.hadError = true;
    }

    protected TestTask getTask() {
        return this.task;
    }

    protected void setTask(TestTask t) {
        this.task = t;
        this.taskIndex = t.getTaskIndex();
    }

    protected int getTaskIndex() {
        return this.taskIndex;
    }

    protected void setTaskIndex(int i) {
        this.taskIndex = i;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long t) {
        this.startTime = t;
    }

    public int compareTo(Object o) {
        int you;
        int me = this.getTid();
        if (me == (you = ((ClientRecord)o).getTid())) {
            return 0;
        }
        if (me > you) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.cstr;
    }

    protected void initCachedString() {
        this.cstr = MasterController.getNameFor(this.vm().getVmid(), this.getTid(), this.vm().getClientName(), this.vm().getHost(), this.vm().getPid());
    }
}

