/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ClientRegionPrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraVector;
import hydra.PoolDescription;
import hydra.PoolPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class ClientRegionDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private static Map cacheListenerInstanceMaps = new HashMap();
    private List cacheListeners;
    private Boolean cacheListenersSingleton;
    private ClientRegionShortcut clientRegionShortcut;
    private Boolean cloningEnabled;
    private Integer concurrencyLevel;
    private String customEntryIdleTimeout;
    private String customEntryTimeToLive;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private EvictionAttributes evictionAttributes;
    private Integer initialCapacity;
    private Class keyConstraint;
    private Float loadFactor;
    private PoolDescription poolDescription;
    private String poolDescriptionName;
    private ExpirationAttributes regionIdleTimeout;
    private String regionName;
    private ExpirationAttributes regionTimeToLive;
    private Boolean statisticsEnabled;
    private Class valueConstraint;
    private static final int NONE = 0;
    private static final int LRU_ENTRY = 1;
    private static final int LRU_HEAP = 2;
    private static final int LRU_MEMORY = 3;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private List getCacheListeners() {
        return this.cacheListeners;
    }

    private void setCacheListeners(List classnames) {
        this.cacheListeners = classnames;
    }

    private Boolean getCacheListenersSingleton() {
        return this.cacheListenersSingleton;
    }

    private void setCacheListenersSingleton(Boolean bool) {
        this.cacheListenersSingleton = bool;
    }

    public ClientRegionShortcut getClientRegionShortcut() {
        return this.clientRegionShortcut;
    }

    private void setClientRegionShortcut(ClientRegionShortcut shortcut) {
        this.clientRegionShortcut = shortcut;
    }

    private Boolean getCloningEnabled() {
        return this.cloningEnabled;
    }

    private void setCloningEnabled(Boolean bool) {
        this.cloningEnabled = bool;
    }

    private Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    private void setConcurrencyLevel(Integer i) {
        this.concurrencyLevel = i;
    }

    private String getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    private void setCustomEntryIdleTimeout(String str) {
        this.customEntryIdleTimeout = str;
    }

    private String getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    private void setCustomEntryTimeToLive(String str) {
        this.customEntryTimeToLive = str;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    private ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    private void setEntryIdleTimeout(ExpirationAttributes attributes) {
        this.entryIdleTimeout = attributes;
    }

    private ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    private void setEntryTimeToLive(ExpirationAttributes attributes) {
        this.entryTimeToLive = attributes;
    }

    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    private void setEvictionAttributes(EvictionAttributes attributes) {
        this.evictionAttributes = attributes;
    }

    private Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    private void setInitialCapacity(Integer i) {
        this.initialCapacity = i;
    }

    private Class getKeyConstraint() {
        return this.keyConstraint;
    }

    private void setKeyConstraint(Class cls) {
        this.keyConstraint = cls;
    }

    private Float getLoadFactor() {
        return this.loadFactor;
    }

    private void setLoadFactor(Float f) {
        this.loadFactor = f;
    }

    private String getPoolDescriptionName() {
        return this.poolDescriptionName;
    }

    private void setPoolDescriptionName(String str) {
        this.poolDescriptionName = str;
    }

    public PoolDescription getPoolDescription() {
        return this.poolDescription;
    }

    private void setPoolDescription(PoolDescription pd) {
        this.poolDescription = pd;
    }

    private ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    private void setRegionIdleTimeout(ExpirationAttributes attributes) {
        this.regionIdleTimeout = attributes;
    }

    public String getRegionName() {
        return this.regionName;
    }

    private void setRegionName(String str) {
        this.regionName = str;
    }

    private ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    private void setRegionTimeToLive(ExpirationAttributes attributes) {
        this.regionTimeToLive = attributes;
    }

    private Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    private void setStatisticsEnabled(Boolean bool) {
        this.statisticsEnabled = bool;
    }

    private Class getValueConstraint() {
        return this.valueConstraint;
    }

    private void setValueConstraint(Class cls) {
        this.valueConstraint = cls;
    }

    protected void configure(ClientRegionFactory f, boolean instantiate) {
        f.initCacheListeners(this.getCacheListenerInstances(instantiate));
        if (this.cloningEnabled != null) {
            f.setCloningEnabled(this.cloningEnabled.booleanValue());
        }
        if (this.concurrencyLevel != null) {
            f.setConcurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.customEntryIdleTimeout != null) {
            f.setCustomEntryIdleTimeout(this.getCustomEntryIdleTimeoutInstance());
        }
        if (this.customEntryTimeToLive != null) {
            f.setCustomEntryTimeToLive(this.getCustomEntryTimeToLiveInstance());
        }
        if (this.diskStoreDescription != null) {
            f.setDiskStoreName(this.diskStoreDescription.getName());
        }
        if (this.diskSynchronous != null) {
            f.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.entryIdleTimeout != null) {
            f.setEntryIdleTimeout(this.entryIdleTimeout);
        }
        if (this.entryTimeToLive != null) {
            f.setEntryTimeToLive(this.entryTimeToLive);
        }
        if (this.evictionAttributes != null) {
            f.setEvictionAttributes(this.evictionAttributes);
        }
        if (this.initialCapacity != null) {
            f.setInitialCapacity(this.initialCapacity.intValue());
        }
        if (this.keyConstraint != null) {
            f.setKeyConstraint(this.keyConstraint);
        }
        if (this.loadFactor != null) {
            f.setLoadFactor(this.loadFactor.floatValue());
        }
        if (this.poolDescription != null) {
            f.setPoolName(this.poolDescription.getName());
        }
        if (this.regionIdleTimeout != null) {
            f.setRegionIdleTimeout(this.regionIdleTimeout);
        }
        if (this.regionTimeToLive != null) {
            f.setRegionTimeToLive(this.regionTimeToLive);
        }
        if (this.statisticsEnabled != null) {
            f.setStatisticsEnabled(this.statisticsEnabled.booleanValue());
        }
        if (this.valueConstraint != null) {
            f.setValueConstraint(this.valueConstraint);
        }
    }

    public void configure(RegionAttributesCreation attrs, boolean instantiate) {
        if (this.cacheListeners != null) {
            attrs.initCacheListeners(this.getCacheListenerInstances(instantiate));
        }
        if (this.cloningEnabled != null) {
            attrs.setCloningEnable(this.cloningEnabled.booleanValue());
        }
        if (this.concurrencyLevel != null) {
            attrs.setConcurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.customEntryIdleTimeout != null) {
            attrs.setCustomEntryIdleTimeout(this.getCustomEntryIdleTimeoutInstance());
        }
        if (this.customEntryTimeToLive != null) {
            attrs.setCustomEntryTimeToLive(this.getCustomEntryTimeToLiveInstance());
        }
        if (this.diskStoreDescription != null) {
            attrs.setDiskStoreName(this.diskStoreDescription.getName());
        }
        if (this.diskSynchronous != null) {
            attrs.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.entryIdleTimeout != null) {
            attrs.setEntryIdleTimeout(this.entryIdleTimeout);
        }
        if (this.entryTimeToLive != null) {
            attrs.setEntryTimeToLive(this.entryTimeToLive);
        }
        if (this.evictionAttributes != null) {
            attrs.setEvictionAttributes(this.evictionAttributes);
        }
        if (this.initialCapacity != null) {
            attrs.setInitialCapacity(this.initialCapacity.intValue());
        }
        if (this.keyConstraint != null) {
            attrs.setKeyConstraint(this.keyConstraint);
        }
        if (this.loadFactor != null) {
            attrs.setLoadFactor(this.loadFactor.floatValue());
        }
        if (this.poolDescription != null) {
            attrs.setPoolName(this.poolDescription.getName());
        }
        if (this.regionIdleTimeout != null) {
            attrs.setRegionIdleTimeout(this.regionIdleTimeout);
        }
        if (this.regionTimeToLive != null) {
            attrs.setRegionTimeToLive(this.regionTimeToLive);
        }
        if (this.statisticsEnabled != null) {
            attrs.setStatisticsEnabled(this.statisticsEnabled.booleanValue());
        }
        if (this.valueConstraint != null) {
            attrs.setValueConstraint(this.valueConstraint);
        }
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "cacheListeners", this.getCacheListeners());
        map.put(header + "cacheListenersSingleton", this.getCacheListenersSingleton());
        map.put(header + "clientRegionShortcut", this.getClientRegionShortcut());
        map.put(header + "cloningEnabled", this.getCloningEnabled());
        map.put(header + "concurrencyLevel", this.getConcurrencyLevel());
        map.put(header + "customEntryIdleTimeout", this.getCustomEntryIdleTimeout());
        map.put(header + "customEntryTimeToLive", this.getCustomEntryTimeToLive());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "entryIdleTimeout", this.getEntryIdleTimeout());
        map.put(header + "entryTimeToLive", this.getEntryTimeToLive());
        map.put(header + "evictionAttributes", this.getEvictionAttributes());
        map.put(header + "initialCapacity", this.getInitialCapacity());
        map.put(header + "keyConstraint", this.getKeyConstraint());
        map.put(header + "loadFactor", this.getLoadFactor());
        map.put(header + "poolName", this.getPoolDescriptionName());
        map.put(header + "regionIdleTimeout", this.getRegionIdleTimeout());
        map.put(header + "regionName", this.getRegionName());
        map.put(header + "regionTimeToLive", this.getRegionTimeToLive());
        map.put(header + "statisticsEnabled", this.getStatisticsEnabled());
        map.put(header + "valueConstraint", this.getValueConstraint());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(ClientRegionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            ClientRegionDescription rd = ClientRegionDescription.createClientRegionDescription(name, config, i);
            config.addClientRegionDescription(rd);
        }
    }

    private static ClientRegionDescription createClientRegionDescription(String name, TestConfig config, int index) {
        Double d;
        ExpirationAttributes attributes;
        Integer i;
        Boolean bool;
        ConfigHashtable tab = config.getParameters();
        ClientRegionDescription rd = new ClientRegionDescription();
        rd.setName(name);
        Long key = ClientRegionPrms.cacheListeners;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                rd.setCacheListeners(new ArrayList(strs));
            }
        }
        if ((bool = tab.getBoolean(key = ClientRegionPrms.cacheListenersSingleton, tab.getWild(key, index, null))) == null) {
            rd.setCacheListenersSingleton(Boolean.FALSE);
        } else {
            rd.setCacheListenersSingleton(bool);
        }
        key = ClientRegionPrms.clientRegionShortcut;
        String str = tab.getString(key, tab.getWild(key, index, null));
        rd.setClientRegionShortcut(ClientRegionDescription.getClientRegionShortcut(str, key));
        key = ClientRegionPrms.cloningEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool != null) {
            rd.setCloningEnabled(bool);
        }
        if ((i = tab.getInteger(key = ClientRegionPrms.concurrencyLevel, tab.getWild(key, index, null))) != null) {
            rd.setConcurrencyLevel(i);
        }
        if ((str = tab.getString(key = ClientRegionPrms.customEntryIdleTimeout, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setCustomEntryIdleTimeout(str);
        }
        if ((str = tab.getString(key = ClientRegionPrms.customEntryTimeToLive, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setCustomEntryTimeToLive(str);
        }
        if ((str = tab.getString(key = ClientRegionPrms.diskStoreName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setDiskStoreDescription(ClientRegionDescription.getDiskStoreDescription(str, key, config));
            rd.setDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = ClientRegionPrms.diskSynchronous, tab.getWild(key, index, null))) != null) {
            rd.setDiskSynchronous(bool);
        }
        if ((attributes = ClientRegionDescription.getExpirationAttributes(key = ClientRegionPrms.entryIdleTimeout, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEntryIdleTimeout(attributes);
        }
        if ((attributes = ClientRegionDescription.getExpirationAttributes(key = ClientRegionPrms.entryTimeToLive, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEntryTimeToLive(attributes);
        }
        if ((attributes = ClientRegionDescription.getEvictionAttributes(key = ClientRegionPrms.evictionAttributes, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEvictionAttributes((EvictionAttributes)attributes);
        }
        if ((i = tab.getInteger(key = ClientRegionPrms.initialCapacity, tab.getWild(key, index, null))) != null) {
            rd.setInitialCapacity(i);
        }
        if ((str = tab.getString(key = ClientRegionPrms.keyConstraint, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setKeyConstraint(ClientRegionDescription.getClass(key, str));
        }
        if ((d = tab.getDouble(key = ClientRegionPrms.loadFactor, tab.getWild(key, index, null))) != null) {
            rd.setLoadFactor(Float.valueOf(d.floatValue()));
        }
        if ((str = tab.getString(key = ClientRegionPrms.poolName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setPoolDescription(ClientRegionDescription.getPoolDescription(str, key, config));
            rd.setPoolDescriptionName("PoolDescription." + str);
        }
        if ((attributes = ClientRegionDescription.getExpirationAttributes(key = ClientRegionPrms.regionIdleTimeout, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setRegionIdleTimeout(attributes);
        }
        if ((str = tab.getString(key = ClientRegionPrms.regionName, tab.getWild(key, index, null))) == null) {
            rd.setRegionName("DefaultRegion");
        } else {
            rd.setRegionName(str);
        }
        key = ClientRegionPrms.regionTimeToLive;
        attributes = ClientRegionDescription.getExpirationAttributes(key, tab.vecAtWild(key, index, null), tab);
        if (attributes != null) {
            rd.setRegionTimeToLive(attributes);
        }
        if ((bool = tab.getBoolean(key = ClientRegionPrms.statisticsEnabled, tab.getWild(key, index, null))) != null) {
            rd.setStatisticsEnabled(bool);
        }
        if ((str = tab.getString(key = ClientRegionPrms.valueConstraint, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            rd.setValueConstraint(ClientRegionDescription.getClass(key, str));
        }
        return rd;
    }

    private synchronized CacheListener[] getCacheListenerInstances(boolean instantiate) {
        List classnames = this.getCacheListeners();
        if (classnames == null) {
            return null;
        }
        HashMap<String, CacheListener> instanceMap = (HashMap<String, CacheListener>)cacheListenerInstanceMaps.get(this.getName());
        Long key = ClientRegionPrms.cacheListeners;
        ArrayList<Object> listeners = new ArrayList<Object>();
        for (String classname : classnames) {
            if (instantiate && this.getCacheListenersSingleton().booleanValue()) {
                Object instance;
                if (instanceMap == null) {
                    instanceMap = new HashMap<String, CacheListener>();
                }
                if ((instance = instanceMap.get(classname)) == null) {
                    CacheListener listener = ClientRegionDescription.getAppCacheListenerInstance(classname);
                    instanceMap.put(classname, listener);
                    listeners.add(listener);
                    continue;
                }
                listeners.add(instance);
                continue;
            }
            listeners.add(ClientRegionDescription.getAppCacheListenerInstance(classname));
        }
        CacheListener[] result = new CacheListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            result[i] = (CacheListener)listeners.get(i);
        }
        return result;
    }

    private static CacheListener getAppCacheListenerInstance(String classname) {
        Long key = ClientRegionPrms.cacheListeners;
        Object obj = ClientRegionDescription.getInstance(key, classname);
        try {
            return (CacheListener)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CacheListener: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static ClientRegionShortcut getClientRegionShortcut(String str, Long key) {
        try {
            return ClientRegionShortcut.valueOf((String)str);
        }
        catch (IllegalArgumentException e) {
            String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
            throw new HydraConfigException(s, e);
        }
        catch (NullPointerException e) {
            String s = BasePrms.nameForKey(key) + " is a required parameter";
            throw new HydraConfigException(s, e);
        }
    }

    private synchronized CustomExpiry getCustomEntryIdleTimeoutInstance() {
        String classname = this.getCustomEntryIdleTimeout();
        if (classname == null) {
            return null;
        }
        return ClientRegionDescription.getCustomExpiry(classname, ClientRegionPrms.customEntryIdleTimeout);
    }

    private synchronized CustomExpiry getCustomEntryTimeToLiveInstance() {
        String classname = this.getCustomEntryTimeToLive();
        if (classname == null) {
            return null;
        }
        return ClientRegionDescription.getCustomExpiry(classname, ClientRegionPrms.customEntryTimeToLive);
    }

    private static CustomExpiry getCustomExpiry(String classname, Long key) {
        if (classname.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            return (CustomExpiry)ClientRegionDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CustomExpiry: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static EvictionAttributes getEvictionAttributes(Long key, Vector val, ConfigHashtable tab) {
        if (val == null) {
            return null;
        }
        String algorithmStr = tab.getString(key, val.get(0));
        if (algorithmStr == null) {
            return null;
        }
        int algorithm = ClientRegionDescription.getEvictionAlgorithm(algorithmStr, key);
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return ClientRegionDescription.getLRUEntryAttributes(key, val, tab);
            }
            case 2: {
                return ClientRegionDescription.getLRUHeapAttributes(key, val, tab);
            }
            case 3: {
                return ClientRegionDescription.getLRUMemoryAttributes(key, val, tab);
            }
        }
        String s = "Should not happen: " + algorithmStr;
        throw new HydraInternalException(s);
    }

    private static EvictionAttributes getLRUEntryAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        Integer maximum = null;
        EvictionAction action = null;
        if (val.size() > 1) {
            maximum = tab.getInteger(key, val.get(1));
        }
        if (val.size() > 2 && (actionStr = tab.getString(key, val.get(2))) != null) {
            action = ClientRegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 3) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (maximum == null && action != null) {
            maximum = EvictionAttributes.createLRUEntryAttributes().getMaximum();
        }
        if (action != null) {
            return EvictionAttributes.createLRUEntryAttributes((int)maximum, action);
        }
        if (maximum != null) {
            return EvictionAttributes.createLRUEntryAttributes((int)maximum);
        }
        return EvictionAttributes.createLRUEntryAttributes();
    }

    private static EvictionAttributes getLRUHeapAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        String sizerStr;
        EvictionAction action = null;
        ObjectSizer sizer = null;
        if (val.size() > 1 && (sizerStr = tab.getString(key, val.get(1))) != null) {
            sizer = ClientRegionDescription.getObjectSizer(sizerStr, key);
        }
        if (val.size() > 2 && (actionStr = tab.getString(key, val.get(2))) != null) {
            action = ClientRegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 3) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (action != null) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)sizer, action);
        }
        if (sizer != null) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)sizer);
        }
        return EvictionAttributes.createLRUHeapAttributes();
    }

    private static EvictionAttributes getLRUMemoryAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        String sizerStr;
        Integer maximum = null;
        ObjectSizer sizer = null;
        EvictionAction action = null;
        if (val.size() > 1) {
            maximum = tab.getInteger(key, val.get(1));
        }
        if (val.size() > 2 && (sizerStr = tab.getString(key, val.get(2))) != null) {
            sizer = ClientRegionDescription.getObjectSizer(sizerStr, key);
        }
        if (val.size() > 3 && (actionStr = tab.getString(key, val.get(3))) != null) {
            action = ClientRegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 4) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (maximum == null && (sizer != null || action != null)) {
            maximum = EvictionAttributes.createLRUMemoryAttributes().getMaximum();
        }
        if (sizer == null && action != null) {
            sizer = EvictionAttributes.createLRUMemoryAttributes().getObjectSizer();
        }
        if (action != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum, (ObjectSizer)sizer, (EvictionAction)action);
        }
        if (sizer != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum, (ObjectSizer)sizer);
        }
        if (maximum != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum);
        }
        return EvictionAttributes.createLRUMemoryAttributes();
    }

    private static int getEvictionAlgorithm(String str, Long key) {
        if (str.equalsIgnoreCase("none")) {
            return 0;
        }
        if (str.equalsIgnoreCase("lru_entry_count") || str.equalsIgnoreCase("lruEntryCount")) {
            return 1;
        }
        if (str.equalsIgnoreCase("lru_heap_percentage") || str.equalsIgnoreCase("lruHeapPercentage")) {
            return 2;
        }
        if (str.equalsIgnoreCase("lru_memory_size") || str.equalsIgnoreCase("lruMemorySize")) {
            return 3;
        }
        String s = BasePrms.nameForKey(key) + " has illegal algorithm: " + str;
        throw new HydraConfigException(s);
    }

    private static EvictionAction getEvictionAction(String str, Long key) {
        if (str.equalsIgnoreCase("local_destroy") || str.equalsIgnoreCase("localDestroy")) {
            return EvictionAction.LOCAL_DESTROY;
        }
        if (str.equalsIgnoreCase("overflow_to_disk") || str.equalsIgnoreCase("overflowToDisk")) {
            return EvictionAction.OVERFLOW_TO_DISK;
        }
        String s = BasePrms.nameForKey(key) + " has illegal action: " + str;
        throw new HydraConfigException(s);
    }

    private static ObjectSizer getObjectSizer(String classname, Long key) {
        if (classname.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            return (ObjectSizer)ClientRegionDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " object sizer does not implement ObjectSizer: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static ExpirationAttributes getExpirationAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        if (val == null) {
            return null;
        }
        Integer timeout = null;
        ExpirationAction action = null;
        if (val.size() > 0) {
            if (val.get(0) instanceof String) {
                String timeoutStr = tab.getString(key, val.get(0));
                if (timeoutStr != null) {
                    timeout = ClientRegionDescription.getExpirationTimeout(timeoutStr, key);
                }
            } else {
                timeout = tab.getInteger(key, val.get(0));
            }
        }
        if (val.size() > 1 && (actionStr = tab.getString(key, val.get(1))) != null) {
            action = ClientRegionDescription.getExpirationAction(actionStr, key);
        }
        if (val.size() > 2) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (timeout == null && action != null) {
            timeout = ExpirationAttributes.DEFAULT.getTimeout();
        }
        if (action != null) {
            return new ExpirationAttributes(timeout.intValue(), action);
        }
        if (timeout != null) {
            return new ExpirationAttributes(timeout.intValue());
        }
        return ExpirationAttributes.DEFAULT;
    }

    private static Integer getExpirationTimeout(String timeout, Long key) {
        if (timeout.equalsIgnoreCase("none")) {
            return 0;
        }
        try {
            return Integer.valueOf(timeout);
        }
        catch (NumberFormatException e) {
            String s = BasePrms.nameForKey(key) + " has illegal type: " + timeout;
            throw new HydraConfigException(s);
        }
    }

    private static ExpirationAction getExpirationAction(String str, Long key) {
        if (str.equalsIgnoreCase("destroy")) {
            return ExpirationAction.DESTROY;
        }
        if (str.equalsIgnoreCase("local_destroy") || str.equalsIgnoreCase("localDestroy")) {
            return ExpirationAction.LOCAL_DESTROY;
        }
        if (str.equalsIgnoreCase("invalidate")) {
            return ExpirationAction.INVALIDATE;
        }
        if (str.equalsIgnoreCase("local_invalidate") || str.equalsIgnoreCase("localInvalidate")) {
            return ExpirationAction.LOCAL_INVALIDATE;
        }
        String s = BasePrms.nameForKey(key) + " has illegal action: " + str;
        throw new HydraConfigException(s);
    }

    private static PoolDescription getPoolDescription(String str, Long key, TestConfig config) {
        PoolDescription pd = config.getPoolDescription(str);
        if (pd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(PoolPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return pd;
    }
}

