/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import hydra.BasePrms;
import hydra.ClientCacheHelper;
import hydra.ClientRegionDescription;
import hydra.ClientRegionPrms;
import hydra.DiskStoreDescription;
import hydra.DiskStoreHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;

public class ClientRegionHelper {
    private static LogWriter log;

    public static synchronized Region createRegion(String regionConfig) {
        ClientRegionDescription rd = ClientRegionHelper.getClientRegionDescription(regionConfig);
        String regionName = rd.getRegionName();
        return ClientRegionHelper.createRegion(regionName, regionConfig);
    }

    public static synchronized Region createRegion(String regionName, String regionConfig) {
        if (regionName == null) {
            throw new IllegalArgumentException("regionName cannot be null");
        }
        if (regionConfig == null) {
            throw new IllegalArgumentException("regionConfig cannot be null");
        }
        ClientCache cache = ClientCacheHelper.getCache();
        Region region = cache.getRegion(regionName);
        if (region == null) {
            PoolDescription pd;
            ClientRegionHelper.log("Creating client region named: " + regionName);
            ClientRegionDescription crd = ClientRegionHelper.getClientRegionDescription(regionConfig);
            DiskStoreDescription dsd = crd.getDiskStoreDescription();
            if (dsd != null) {
                DiskStoreHelper.createDiskStore(dsd.getName());
            }
            if ((pd = crd.getPoolDescription()) != null) {
                PoolHelper.createPool(pd.getName());
            }
            ClientRegionShortcut shortcut = crd.getClientRegionShortcut();
            ClientRegionFactory factory = cache.createClientRegionFactory(shortcut);
            crd.configure(factory, true);
            region = factory.create(regionName);
            ClientRegionHelper.log("Created region named " + regionName + " with attributes " + RegionHelper.regionAttributesToString(region.getAttributes()));
        }
        return region;
    }

    public static synchronized Region getRegion(String regionName) {
        if (regionName == null) {
            throw new IllegalArgumentException("regionName cannot be null");
        }
        return ClientCacheHelper.getCache().getRegion(regionName);
    }

    public static ClientRegionDescription getClientRegionDescription(String regionConfig) {
        if (regionConfig == null) {
            throw new IllegalArgumentException("regionConfig cannot be null");
        }
        ClientRegionHelper.log("Looking up client region config: " + regionConfig);
        ClientRegionDescription crd = TestConfig.getInstance().getClientRegionDescription(regionConfig);
        if (crd == null) {
            String s = regionConfig + " not found in " + BasePrms.nameForKey(ClientRegionPrms.names);
            throw new HydraRuntimeException(s);
        }
        ClientRegionHelper.log("Looked up client region config:\n" + crd);
        return crd;
    }

    public static String regionAttributesToString(RegionAttributes attributes) {
        return RegionHelper.regionAttributesToString(attributes);
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

