/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientVmInfo;
import hydra.ClientVmNotFoundException;
import hydra.DynamicActionUtil;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestTask;
import java.rmi.RemoteException;
import java.util.Vector;

public class ClientVmMgr {
    protected static final int SYNC = 0;
    private static final String Sync = "synchronous";
    protected static final int ASYNC = 1;
    private static final String Async = "asynchronous";
    public static final int NICE_KILL = -20;
    public static final String NiceKill = "nice_kill";
    public static final int MEAN_KILL = -21;
    public static final String MeanKill = "mean_kill";
    public static final int NICE_EXIT = -22;
    public static final String NiceExit = "nice_exit";
    public static final int MEAN_EXIT = -23;
    public static final String MeanExit = "mean_exit";
    public static final int NICE_DISCONNECT = -24;
    public static final String NiceDisconnect = "nice_disconnect";
    public static final int DEFAULT_STOP_MODE = -21;
    public static final int IMMEDIATE = -30;
    public static final String Immediate = "immediate";
    public static final int ON_DEMAND = -31;
    public static final String OnDemand = "on_demand";
    public static final int NEVER = -32;
    public static final String Never = "never";
    public static final int DEFAULT_START_MODE = -31;

    private static String toSyncModeString(int syncMode) {
        switch (syncMode) {
            case 0: {
                return Sync;
            }
            case 1: {
                return Async;
            }
        }
        throw new HydraInternalException("Unhandled sync mode");
    }

    public static String toStopModeString(int stopMode) {
        switch (stopMode) {
            case -20: {
                return NiceKill;
            }
            case -21: {
                return MeanKill;
            }
            case -22: {
                return NiceExit;
            }
            case -23: {
                return MeanExit;
            }
            case -24: {
                return NiceDisconnect;
            }
        }
        throw new HydraInternalException("Unhandled stop mode");
    }

    public static int toStopMode(String stopMode) {
        if (stopMode.equalsIgnoreCase(NiceExit)) {
            return -22;
        }
        if (stopMode.equalsIgnoreCase(MeanExit)) {
            return -23;
        }
        if (stopMode.equalsIgnoreCase(NiceKill)) {
            return -20;
        }
        if (stopMode.equalsIgnoreCase(MeanKill)) {
            return -21;
        }
        if (stopMode.equalsIgnoreCase(NiceDisconnect)) {
            return -24;
        }
        throw new HydraConfigException("Illegal stop mode: " + stopMode);
    }

    private static String toStartModeString(int startMode) {
        if (startMode > 0) {
            return "after " + startMode + " ms";
        }
        switch (startMode) {
            case -30: {
                return Immediate;
            }
            case -31: {
                return OnDemand;
            }
            case -32: {
                return Never;
            }
        }
        throw new HydraInternalException("Unhandled start mode");
    }

    public static int toStartMode(String startMode) {
        if (startMode.equalsIgnoreCase(Immediate)) {
            return -30;
        }
        if (startMode.equalsIgnoreCase(OnDemand)) {
            return -31;
        }
        if (startMode.equalsIgnoreCase(Never)) {
            return -32;
        }
        try {
            int delay = Integer.parseInt(startMode);
            if (delay > 0) {
                return delay;
            }
            throw new HydraConfigException("Illegal start mode: " + startMode);
        }
        catch (NumberFormatException e) {
            throw new HydraConfigException("Illegal start mode: " + startMode);
        }
    }

    public static ClientVmInfo stop(String reason) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 0, -21, -31, new ClientVmInfo());
    }

    public static ClientVmInfo stopAsync(String reason) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 1, -21, -31, new ClientVmInfo());
    }

    public static ClientVmInfo stop(String reason, int stopMode, int startMode) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 0, stopMode, startMode, new ClientVmInfo());
    }

    public static ClientVmInfo stopAsync(String reason, int stopMode, int startMode) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 1, stopMode, startMode, new ClientVmInfo());
    }

    public static ClientVmInfo stop(String reason, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 0, -21, -31, target);
    }

    public static ClientVmInfo stopAsync(String reason, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 1, -21, -31, target);
    }

    public static ClientVmInfo stop(String reason, int stopMode, int startMode, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 0, stopMode, startMode, target);
    }

    public static ClientVmInfo stopAsync(String reason, int stopMode, int startMode, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.stop(reason, 1, stopMode, startMode, target);
    }

    public static ClientVmInfo start(String reason) throws ClientVmNotFoundException {
        ClientVmInfo target = new ClientVmInfo(null, null, null);
        return ClientVmMgr.start(reason, 0, target);
    }

    public static ClientVmInfo startAsync(String reason) throws ClientVmNotFoundException {
        ClientVmInfo target = new ClientVmInfo(null, null, null);
        return ClientVmMgr.start(reason, 1, target);
    }

    public static ClientVmInfo start(String reason, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.start(reason, 0, target);
    }

    public static ClientVmInfo startAsync(String reason, ClientVmInfo target) throws ClientVmNotFoundException {
        return ClientVmMgr.start(reason, 1, target);
    }

    public static int getPid(int vmid) {
        try {
            return RemoteTestModule.Master.getPid(vmid);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    public static Vector getClientVmids() {
        try {
            return RemoteTestModule.Master.getClientVmids();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    public static Vector getOtherClientVmids() {
        int myVmid = RemoteTestModule.getMyVmid();
        try {
            return RemoteTestModule.Master.getOtherClientVmids(myVmid);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    private static ClientVmInfo stop(String reason, int syncMode, int stopMode, int startMode, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmMgr.validate(syncMode, stopMode, startMode);
        return ClientVmMgr.reserveAndStop(reason, syncMode, stopMode, startMode, target);
    }

    private static ClientVmInfo start(String reason, int syncMode, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmMgr.validate(syncMode, -21, -31);
        return ClientVmMgr.reserveAndStart(reason, syncMode, target);
    }

    private static ClientVmInfo reserveAndStop(final String reason, final int syncMode, final int stopMode, final int startMode, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmMgr.log().info("Reserving " + target + " for dynamic stop");
        final String srcName = Thread.currentThread().getName();
        final int srcVmid = RemoteTestModule.MyVmid;
        final ClientVmInfo match = ClientVmMgr.reserveToStopRemote(srcName, srcVmid, syncMode, stopMode, target);
        String act = "dynamic stop (" + ClientVmMgr.toSyncModeString(syncMode) + ":" + ClientVmMgr.toStopModeString(stopMode) + ":" + ClientVmMgr.toStartModeString(startMode) + ") " + match + " because " + reason;
        ClientVmMgr.log().info("Reserved " + match + " for " + act);
        final int actionId = DynamicActionUtil.nextActionId();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ClientVmMgr.stopRemote(srcName, srcVmid, actionId, reason, syncMode, stopMode, startMode, match);
            }
        };
        boolean synchronous = syncMode == 0;
        DynamicActionUtil.runActionThread(actionId, act, action, srcName, synchronous);
        return match;
    }

    private static ClientVmInfo reserveAndStart(final String reason, final int syncMode, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmMgr.log().info("Reserving " + target + " for dynamic start");
        final String srcName = Thread.currentThread().getName();
        final int srcVmid = RemoteTestModule.MyVmid;
        final ClientVmInfo match = ClientVmMgr.reserveToStartRemote(srcName, srcVmid, target);
        String act = "dynamic start (" + ClientVmMgr.toSyncModeString(syncMode) + ") " + match + " because " + reason;
        ClientVmMgr.log().info("Reserved " + match + " for " + act);
        final int actionId = DynamicActionUtil.nextActionId();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ClientVmMgr.startRemote(srcName, srcVmid, actionId, reason, syncMode, match);
            }
        };
        boolean synchronous = syncMode == 0;
        DynamicActionUtil.runActionThread(actionId, act, action, srcName, synchronous);
        return match;
    }

    private static ClientVmInfo reserveToStopRemote(String srcName, int srcVmid, int syncMode, int stopMode, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmInfo match = null;
        try {
            match = RemoteTestModule.Master.reserveClientVmForStop(srcName, srcVmid, syncMode, stopMode, target);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
        return match;
    }

    private static ClientVmInfo reserveToStartRemote(String srcName, int srcVmid, ClientVmInfo target) throws ClientVmNotFoundException {
        ClientVmInfo match = null;
        try {
            match = RemoteTestModule.Master.reserveClientVmForStart(srcName, srcVmid, target);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
        return match;
    }

    protected static void stopRemote(String srcName, int srcVmid, int actionId, String reason, int syncMode, int stopMode, int startMode, ClientVmInfo match) {
        try {
            RemoteTestModule.Master.stopClientVm(srcName, srcVmid, actionId, reason, syncMode, stopMode, startMode, match);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    protected static void startRemote(String srcName, int srcVmid, int actionId, String reason, int syncMode, ClientVmInfo match) {
        try {
            RemoteTestModule.Master.startClientVm(srcName, srcVmid, actionId, reason, syncMode, match);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    private static void validate(int syncMode, int stopMode, int startMode) {
        if (RemoteTestModule.getCurrentThread() == null) {
            String s = "The ClientVmMgr API can only be used from hydra threads -- use HydraSubthread when creating threads that use the API";
            throw new UnsupportedOperationException(s);
        }
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (task.getTaskType() != 3) {
            String s = "The ClientVmMgr API can only be used from tasks of type TASK";
            throw new UnsupportedOperationException(s);
        }
        switch (syncMode) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new HydraInternalException("Invalid sync mode: " + ClientVmMgr.toSyncModeString(syncMode));
            }
        }
        switch (stopMode) {
            case -24: 
            case -23: 
            case -22: 
            case -21: 
            case -20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid stop mode: " + ClientVmMgr.toStopModeString(stopMode));
            }
        }
        if (startMode <= 0) {
            switch (startMode) {
                case -32: 
                case -31: 
                case -30: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid start mode: " + ClientVmMgr.toStartModeString(startMode));
                }
            }
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

