/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientDescription;
import hydra.ClientRecord;
import hydra.ClientVmInfo;
import hydra.DynamicActionException;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.JDKVersionDescription;
import hydra.Log;
import hydra.RemoteTestModuleIF;
import hydra.VersionDescription;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClientVmRecord
implements Serializable {
    protected static int NO_PID = -1;
    protected static final int POTENTIAL = 0;
    protected static final int PENDING = 1;
    protected static final int LIVE = 2;
    protected static final int DEAD = 3;
    protected static final int DISCONNECTED = 4;
    private Integer vmid;
    private int basetid;
    private ClientDescription cd;
    private HashMap<Integer, ClientRecord> crs = new HashMap();
    private String cstr;
    private volatile int state;
    private volatile int pid;
    private volatile List<String> javaHomes;
    private volatile Map<String, String> versionMapping;
    private int numClientsRegistered;
    private int actionCount;
    private volatile boolean reserved;
    private volatile boolean disconnected;

    public ClientVmRecord(int vmid, int basetid, ClientDescription cd) {
        VersionDescription vd;
        List<String> j;
        this.vmid = new Integer(vmid);
        this.basetid = basetid;
        this.cd = cd;
        this.cstr = "vm_" + vmid;
        JDKVersionDescription jvd = cd.getJDKVersionDescription();
        if (jvd != null && (j = jvd.getJavaHomes()) != null) {
            Object jcopy = ((ArrayList)j).clone();
            this.javaHomes = (List)jcopy;
        }
        if ((vd = cd.getVersionDescription()) != null) {
            Map<String, String> m = vd.getVersionMapping();
            Object mcopy = ((LinkedHashMap)m).clone();
            this.versionMapping = (Map)mcopy;
        }
        this.reset();
    }

    public Integer getVmid() {
        return this.vmid;
    }

    protected int getBaseThreadId() {
        return this.basetid;
    }

    protected Map<Integer, ClientRecord> getClients() {
        return this.crs;
    }

    public ClientRecord getClient(int tid) {
        ClientRecord cr = this.crs.get(new Integer(tid));
        if (cr == null) {
            throw new HydraInternalException(this + " missing client #" + tid);
        }
        return cr;
    }

    public ClientRecord getRepresentativeClient() {
        Iterator<ClientRecord> i = this.crs.values().iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    protected void addClient(ClientRecord cr) {
        this.crs.put(new Integer(cr.getTid()), cr);
    }

    protected Collection getCopyOfClientCollection() {
        return ((Map)this.crs.clone()).values();
    }

    public ClientDescription getClientDescription() {
        return this.cd;
    }

    public String getClientName() {
        return this.cd.getName();
    }

    protected String getLogicalHost() {
        return this.cd.getVmDescription().getHostDescription().getName();
    }

    protected String getHost() {
        return this.cd.getVmDescription().getHostDescription().getHostName();
    }

    protected HostHelper.OSType getOSType() {
        return this.cd.getVmDescription().getHostDescription().getOSType();
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        if (this.state == state) {
            throw new HydraInternalException("state already set: " + this);
        }
        this.state = state;
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "potential";
            }
            case 1: {
                return "pending";
            }
            case 2: {
                return "live";
            }
            case 3: {
                return "dead";
            }
            case 4: {
                return "disconnected";
            }
        }
        throw new HydraInternalException("Unknown state: " + this.state);
    }

    public String getStateAsString(int state) {
        switch (state) {
            case 0: {
                return "potential";
            }
            case 1: {
                return "pending";
            }
            case 2: {
                return "live";
            }
            case 3: {
                return "dead";
            }
            case 4: {
                return "disconnected";
            }
        }
        throw new HydraInternalException("Unknown state: " + state);
    }

    protected String getJavaHome() {
        if (this.javaHomes == null) {
            return this.cd.getVmDescription().getHostDescription().getJavaHome();
        }
        String val = this.javaHomes.get(0);
        if (val.equals("default")) {
            return this.cd.getVmDescription().getHostDescription().getJavaHome();
        }
        return val;
    }

    protected void bumpJavaHome() {
        if (this.javaHomes != null) {
            String first = this.javaHomes.get(0);
            if (this.javaHomes.size() > 1) {
                this.javaHomes.remove(first);
                Log.getLogWriter().info("Bumped Java home from " + first + " to " + this.javaHomes.get(0) + " for next startup for VM " + this.vmid);
            } else {
                Log.getLogWriter().info("Sticking with Java home " + first + " for VM " + this.vmid);
            }
        }
    }

    protected String getVersion() {
        return this.versionMapping.keySet().iterator().next();
    }

    protected void bumpVersion() {
        if (this.versionMapping != null) {
            String first = this.versionMapping.keySet().iterator().next();
            if (this.versionMapping.size() > 1) {
                this.versionMapping.remove(first);
                Log.getLogWriter().info("Bumped version from " + first + " to " + this.versionMapping.keySet().iterator().next() + " for next startup for VM " + this.vmid);
            } else {
                Log.getLogWriter().info("Sticking with version " + first + " for VM " + this.vmid);
            }
        }
    }

    public int getPid() {
        return this.pid;
    }

    protected void setPid(int pid) {
        if (this.pid == pid) {
            throw new HydraInternalException("pid already set: " + this);
        }
        this.pid = pid;
        for (ClientRecord cr : this.getClients().values()) {
            cr.initCachedString();
        }
    }

    protected void registerClient() {
        ++this.numClientsRegistered;
    }

    protected boolean fullyRegistered() {
        return this.numClientsRegistered == this.crs.size();
    }

    protected void incDynamicActionCount() {
        if (this.reserved) {
            String s = "attempt to initiate dynamic action from reserved vm";
            throw new HydraInternalException(s);
        }
        ++this.actionCount;
    }

    protected void decDynamicActionCount() {
        --this.actionCount;
    }

    protected boolean acting() {
        return this.actionCount != 0;
    }

    protected void reserve() {
        if (this.reserved) {
            throw new HydraInternalException("already reserved: " + this);
        }
        if (this.actionCount != 0) {
            String s = "attempt to reserve vm that is initiating dynamic action";
            throw new HydraInternalException(s);
        }
        this.reserved = true;
    }

    protected void unreserve() {
        if (!this.reserved) {
            throw new HydraInternalException("already unreserved: " + this);
        }
        this.reserved = false;
    }

    protected boolean reserved() {
        return this.reserved;
    }

    protected boolean isDynamic() {
        return this.state != 2 || this.reserved;
    }

    protected void registerDisconnect() {
        if (this.disconnected) {
            throw new HydraInternalException("already disconnected");
        }
        this.disconnected = true;
    }

    protected boolean registeredDisconnect() {
        return this.disconnected;
    }

    protected boolean isDisconnected() {
        return this.state == 4;
    }

    protected boolean isLive() {
        return this.state == 2;
    }

    protected boolean isDead() {
        return this.state == 3;
    }

    protected void reset() {
        this.state = 0;
        this.pid = NO_PID;
        this.numClientsRegistered = 0;
        this.actionCount = 0;
        this.reserved = false;
        this.disconnected = false;
    }

    protected void resetForDisconnect() {
        this.state = 4;
        this.actionCount = 0;
        this.reserved = false;
        this.disconnected = false;
    }

    protected boolean matches(ClientVmInfo info) {
        return !(info.getVmid() != null && !info.getVmid().equals(this.getVmid()) || info.getClientName() != null && !info.clientNameMatches(this.getClientName()) || info.getLogicalHost() != null && !info.getLogicalHost().equals(this.getLogicalHost()));
    }

    public void notifyDynamicActionComplete(int actionId, int lastKnownPid) {
        block2: {
            ClientRecord cr = this.getRepresentativeClient();
            RemoteTestModuleIF rem = cr.getTestModule();
            try {
                rem.notifyDynamicActionComplete(actionId);
            }
            catch (RemoteException e) {
                if (this.getPid() != lastKnownPid) break block2;
                throw new DynamicActionException("Unable to reach " + cr, e);
            }
        }
    }

    protected ClientVmInfo getInfo() {
        return new ClientVmInfo(this.getVmid(), this.getClientName(), this.getLogicalHost());
    }

    public String toString() {
        return this.cstr;
    }

    public String toInfoString() {
        int maxtid = this.getBaseThreadId() + this.getClients().size() - 1;
        return this + "_thr_" + this.getBaseThreadId() + "_to_" + maxtid + "_" + this.getClientName() + "_" + this.getHost() + "_" + this.getPid() + "_" + this.getStateString();
    }

    public String toStateString() {
        return this.cstr + "_" + this.getClientName() + "_" + this.getHost() + "_" + this.getPid() + "_" + this.getStateString();
    }

    public String toClientString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toInfoString());
        for (ClientRecord cr : this.crs.values()) {
            buf.append(" ").append(cr);
        }
        return buf.toString();
    }
}

