/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.ComplexTaskScheduler;
import java.util.Vector;

public class ComplexConcurrentTaskScheduler
extends ComplexTaskScheduler {
    public ComplexConcurrentTaskScheduler(String name, Vector tasks, String purpose, long totalTaskTimeSec) {
        super(name, tasks, purpose, totalTaskTimeSec);
    }

    @Override
    protected boolean executeTasks() {
        long now;
        int count;
        this.initializeTaskTimes();
        do {
            count = 0;
            now = System.currentTimeMillis();
            for (ClientVmRecord vm : this.vms.values()) {
                if (vm.isDynamic()) continue;
                for (ClientRecord client : vm.getClients().values()) {
                    if (!this.schedule(client, now, this)) continue;
                    ++count;
                }
            }
        } while (!this.terminateScheduling(count, now));
        this.log.info(this.name + " terminating scheduling because " + this.termination);
        if (this.executedNormally()) {
            this.waitForClientsToFinish();
        }
        this.waitForDynamicThreadsToFinish();
        return this.schedulerResult();
    }
}

