/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.ComplexTaskScheduler;
import java.util.TreeSet;
import java.util.Vector;

public class ComplexRoundRobinTaskScheduler
extends ComplexTaskScheduler {
    public ComplexRoundRobinTaskScheduler(String name, Vector tasks, String purpose, long totalTaskTimeSec) {
        super(name, tasks, purpose, totalTaskTimeSec);
    }

    @Override
    protected boolean executeTasks() {
        TreeSet<ClientRecord> tmp = new TreeSet<ClientRecord>();
        for (ClientVmRecord vm : this.vms.values()) {
            tmp.addAll(vm.getClients().values());
        }
        Object[] clients = tmp.toArray();
        if (this.log.fineEnabled()) {
            this.log.fine("Sorted array of clients: " + clients);
        }
        this.initializeTaskTimes();
        int index = 0;
        int count = 0;
        int lastCount = 1;
        long now = 0L;
        do {
            ClientRecord client = (ClientRecord)clients[index];
            index = (index + 1) % clients.length;
            if (!client.vm().isDynamic() && this.schedule(client, now = System.currentTimeMillis(), this)) {
                ++count;
                now = this.waitForClientToFinish(client);
            }
            if (index != 0) continue;
            lastCount = count;
            count = 0;
        } while (!this.terminateScheduling(lastCount, now));
        this.log.info(this.name + " terminating scheduling because " + this.termination);
        this.waitForDynamicThreadsToFinish();
        return this.schedulerResult();
    }
}

