/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BaseTaskScheduler;
import hydra.ClientMgr;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.HydraInternalException;
import hydra.TestConfig;
import hydra.TestTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class ComplexTaskScheduler
extends BaseTaskScheduler {
    private int[] status;
    private volatile boolean receivedStopSchedulingOrder;
    private long totalTaskTimeSec;
    private long totalTaskTimeMs;
    private long birthTime;
    private static final int OK = 0;
    private static final int MAX_TIMES_TO_RUN = 1;
    private static final int MAX_THREADS = 2;
    private static final int START_INTERVAL = 3;
    private static final int END_INTERVAL = 4;
    private static final int THREAD_GROUP = 5;
    private static final int STOP_SCHEDULING_ORDER = 6;

    public ComplexTaskScheduler(String name, Vector tasks, String purpose, long totalTaskTimeSec) {
        super(name, tasks, purpose);
        this.totalTaskTimeSec = totalTaskTimeSec;
        this.totalTaskTimeMs = totalTaskTimeSec * 1000L;
        this.status = new int[tasks.size()];
        this.receivedStopSchedulingOrder = false;
    }

    protected void initializeTaskTimes() {
        this.birthTime = System.currentTimeMillis();
        for (TestTask task : this.tasks) {
            task.setStartTimes(this.birthTime);
            task.setEndTimes(this.birthTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean schedule(ClientRecord client, long now, ComplexTaskScheduler ts) {
        ClientVmRecord vm;
        ClientVmRecord clientVmRecord = vm = client.vm();
        synchronized (clientVmRecord) {
            if (!vm.isDynamic()) {
                ClientRecord clientRecord = client;
                synchronized (clientRecord) {
                    TestTask task;
                    if (!(ts.receivedStopSchedulingOrder() || client.isBusy() || client.hadError() && this.haltIfBadResult || (task = this.selectTask(client, now)) == null)) {
                        client.setBusy(true);
                        client.setTask(task);
                        client.setStartTime(now);
                        TestTask testTask = task;
                        synchronized (testTask) {
                            task.incrementNumTimesInUse();
                            task.updateStartTimes(now);
                        }
                        this.assignTask(client, task);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean hasTask(ClientRecord client, long now) {
        this.filterTasks(client, now);
        for (int i = 0; i < this.status.length; ++i) {
            if (this.status[i] != 0) continue;
            return true;
        }
        return false;
    }

    protected TestTask selectTask(ClientRecord client, long now) {
        if (this.hasTask(client, now)) {
            if (client.getThreadGroup().usesCustomWeights().booleanValue()) {
                return this.selectTaskByWeight();
            }
            return this.selectTaskRandom();
        }
        return null;
    }

    private void filterTasks(ClientRecord client, long now) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TestTask task = (TestTask)this.tasks.elementAt(i);
            this.filterTask(i, task, client, now);
        }
    }

    private void filterTask(int i, TestTask task, ClientRecord client, long now) {
        this.status[i] = task.getNumTimesRun() + task.getNumTimesInUse() < task.getMaxTimesToRun() ? (task.getNumTimesInUse() < task.getMaxThreads() ? (task.usesThreadGroup(client.getThreadGroupName()) ? (!task.receivedStopSchedulingTaskOnClientOrder(client) ? (task.satisfiesStartInterval(now) ? (task.satisfiesEndInterval(now) ? 0 : 4) : 3) : 6) : 5) : 2) : 1;
        this.printFilterStatus();
    }

    private TestTask selectTaskByWeight() {
        int minindex = -1;
        double minratio = -1.0;
        for (int i = 0; i < this.status.length; ++i) {
            if (this.status[i] != 0) continue;
            TestTask task = (TestTask)this.tasks.elementAt(i);
            if (minindex == -1) {
                minratio = this.computeRatio(task);
                minindex = i;
                continue;
            }
            double ratio = this.computeRatio(task);
            if (!(ratio < minratio)) continue;
            minratio = ratio;
            minindex = i;
        }
        if (minindex == -1) {
            throw new HydraInternalException("Unexpected failure to find task");
        }
        TestTask task = (TestTask)this.tasks.elementAt(minindex);
        if (this.log.finestEnabled()) {
            this.log.finest("highest priority " + task.toShortString());
        }
        return task;
    }

    private TestTask selectTaskRandom() {
        int numEligible = 0;
        for (int i = 0; i < this.status.length; ++i) {
            if (this.status[i] != 0) continue;
            ++numEligible;
        }
        this.printFilterStatus();
        int whichEligible = TestConfig.tab().getRandGen().nextInt(0, numEligible - 1);
        if (this.log.finestEnabled()) {
            this.log.finest("NUMELIGIBLE: " + numEligible + " WHICHELIGIBLE: " + whichEligible);
        }
        int count = 0;
        for (int i = 0; i < this.status.length; ++i) {
            if (this.status[i] != 0) continue;
            if (this.log.finestEnabled()) {
                this.log.finest("COUNT: " + count);
            }
            if (count == whichEligible) {
                return (TestTask)this.tasks.elementAt(i);
            }
            ++count;
        }
        throw new HydraInternalException("Unexpected failure to find task");
    }

    private double computeRatio(TestTask task) {
        double ratio = (double)(1 + task.getNumTimesInUse() + task.getNumTimesRun()) / (double)task.getWeight();
        if (this.log.finestEnabled()) {
            this.log.finest("RATIO " + ratio + " for " + task.toShortString());
        }
        return ratio;
    }

    private void printFilterStatus() {
        if (this.log.finerEnabled()) {
            StringBuffer buf = new StringBuffer(10);
            buf.append("STATUS: ");
            for (int i = 0; i < this.status.length; ++i) {
                buf.append(this.status[i]).append(" ");
            }
            this.log.finer(buf.toString());
        }
    }

    protected boolean terminateScheduling(int count, long now) {
        boolean terminate = this.terminate(now);
        if (!terminate && count == 0) {
            this.printSchedulingReport(now);
            this.pauseScheduling();
        }
        return terminate;
    }

    protected void waitForDynamicThreadsToFinish() {
        ClientMgr.refuseDynamicActions();
        while (true) {
            long now = System.currentTimeMillis();
            if (!ClientMgr.hasDynamicActions()) break;
            this.printBlockingReport(now);
            this.pauseBlocking();
        }
    }

    private boolean terminate(long now) {
        return this.hadFatalTaskErrorAndHaltOrder() || this.hadStatMonitorError() || this.hadDynamicActionError() || this.hadDynamicActionHang() || this.exceededMaxResultWaitSec(now) || this.exceededTotalTaskTimeSec(now) || this.completedAllTasks() || this.clientVmsPermanentlyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exceededMaxResultWaitSec(long now) {
        Iterator i = this.vms.values().iterator();
        while (i.hasNext()) {
            ClientVmRecord vm;
            ClientVmRecord clientVmRecord = vm = (ClientVmRecord)i.next();
            synchronized (clientVmRecord) {
                Collection<ClientRecord> clients;
                if (!vm.isDynamic() && super.exceededMaxResultWaitSec(clients = vm.getClients().values(), now)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean exceededTotalTaskTimeSec(long now) {
        if (now - this.birthTime <= this.totalTaskTimeMs) {
            return false;
        }
        this.setTermination("they exceeded the total task time sec: " + this.totalTaskTimeSec);
        return true;
    }

    private boolean completedAllTasks() {
        if (this.receivedStopSchedulingOrder) {
            this.setTermination("a client threw a StopSchedulingOrder");
            return true;
        }
        int limits = 0;
        int orders = 0;
        for (int i = 0; i < this.status.length; ++i) {
            TestTask task = (TestTask)this.tasks.get(i);
            if (this.status[i] == 1) {
                ++limits;
                continue;
            }
            if (task.receivedAllStopSchedulingTaskOnClientOrders()) {
                ++orders;
                continue;
            }
            return false;
        }
        if (limits == this.tasks.size()) {
            this.setTermination("all tasks exceeded max times to run");
        } else if (orders == this.tasks.size()) {
            this.setTermination("all tasks were thrown StopSchedulingTaskOnClientOrders from all of their eligible clients");
        } else {
            this.setTermination("all tasks either exceeded max times to run or were thrown StopSchedulingTaskOnClientOrders from all of their eligible clients");
        }
        return true;
    }

    private boolean clientVmsPermanentlyStopped() {
        if (ClientMgr.clientVmsPermanentlyStopped()) {
            this.setTermination("all client VMs have been dynamically stopped and there is no hope of restarting them");
            return true;
        }
        return false;
    }

    protected void receiveStopSchedulingOrder() {
        this.receivedStopSchedulingOrder = true;
    }

    protected boolean receivedStopSchedulingOrder() {
        return this.receivedStopSchedulingOrder;
    }
}

