/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HydraConfigException;
import java.text.StringCharacterIterator;
import java.util.Vector;

public class ConfigLexer {
    private static final char PLUS = '+';
    private static final char EQUALS = '=';
    private static final char COMMA = ',';
    private static final char SEMI = ';';
    private static final char ESC = '\\';
    private static final char POUND = '#';
    private static final char SLASH = '/';
    private static final char STAR = '*';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char FORMFEED = '\f';
    private static final char EOF = '\uffff';
    private StringBuffer token = new StringBuffer(100);

    public static Vector tokenize(String text) {
        ConfigLexer lex = new ConfigLexer();
        Vector tokens = lex.getTokens(text);
        return tokens;
    }

    private Vector getTokens(String text) {
        if (text == null) {
            return null;
        }
        Vector<String> tokens = new Vector<String>();
        StringCharacterIterator sci = new StringCharacterIterator(text);
        while (sci.current() != '\uffff') {
            String token = this.nextToken(sci);
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private String nextToken(StringCharacterIterator sci) {
        this.token.setLength(0);
        switch (sci.current()) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.gobbleWhiteSpace(sci);
                break;
            }
            case '+': 
            case ',': 
            case ';': 
            case '=': {
                this.matchDelimiter(sci, this.token);
                break;
            }
            case '\"': {
                this.matchString(sci, this.token);
                break;
            }
            case '#': {
                this.matchComment(sci);
                break;
            }
            case '/': {
                this.matchCommentOrValue(sci, this.token);
                break;
            }
            default: {
                this.matchValue(sci, this.token);
            }
        }
        return this.token.length() > 0 ? this.token.toString() : null;
    }

    private void gobbleWhiteSpace(StringCharacterIterator sci) {
        char c = sci.current();
        while (c != '\uffff') {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return;
                }
            }
            c = sci.next();
        }
    }

    private void matchDelimiter(StringCharacterIterator sci, StringBuffer token) {
        char c = sci.current();
        block0 : switch (c) {
            case '+': {
                char cnext = sci.next();
                switch (cnext) {
                    case '=': {
                        token.append(c);
                        token.append(cnext);
                        sci.next();
                        break block0;
                    }
                }
                sci.previous();
                this.matchValue(sci, token);
                break;
            }
            default: {
                token.append(c);
                sci.next();
            }
        }
    }

    private void matchString(StringCharacterIterator sci, StringBuffer token) {
        char c = sci.next();
        while (c != '\uffff') {
            switch (c) {
                case '\\': {
                    char cnext = sci.next();
                    if (cnext == '\uffff') break;
                    token.append(cnext);
                    break;
                }
                case '\"': {
                    sci.next();
                    return;
                }
                default: {
                    token.append(c);
                }
            }
            c = sci.next();
        }
        throw new HydraConfigException("Premature end of file in string");
    }

    private void matchComment(StringCharacterIterator sci) {
        this.gobbleSingleLineComment(sci);
    }

    private void matchCommentOrValue(StringCharacterIterator sci, StringBuffer token) {
        char cnext = sci.next();
        if (cnext == '\uffff') {
            throw new HydraConfigException("Premature end of file in comment or value");
        }
        if (cnext == '/') {
            sci.next();
            this.gobbleSingleLineComment(sci);
        } else if (cnext == '*') {
            sci.next();
            this.gobbleMultiLineComment(sci);
        } else {
            sci.previous();
            this.matchValue(sci, token);
        }
    }

    private void gobbleSingleLineComment(StringCharacterIterator sci) {
        char c = sci.current();
        while (c != '\uffff') {
            switch (c) {
                case '\n': {
                    return;
                }
            }
            c = sci.next();
        }
    }

    private void gobbleMultiLineComment(StringCharacterIterator sci) {
        char c = sci.current();
        while (c != '\uffff') {
            switch (c) {
                case '*': {
                    char cnext = sci.next();
                    if (cnext == '\uffff') {
                        throw new HydraConfigException("Premature end of file in multi-line comment");
                    }
                    if (cnext != '/') break;
                    sci.next();
                    return;
                }
            }
            c = sci.next();
        }
        throw new HydraConfigException("Premature end of file in multi-line comment");
    }

    private void matchValue(StringCharacterIterator sci, StringBuffer token) {
        char c = sci.current();
        while (c != '\uffff') {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    sci.next();
                    return;
                }
                case ',': 
                case ';': 
                case '=': {
                    return;
                }
            }
            token.append(c);
            c = sci.next();
        }
    }
}

