/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.distributed.internal.deadlock.DeadlockDetector;
import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyGraph;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitorManager;
import com.gemstone.gemfire.distributed.internal.deadlock.ThreadReference;
import hydra.ClientMgr;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.FileUtil;
import hydra.HydraThread;
import hydra.MasterController;
import hydra.MethExecutorResult;
import hydra.RemoteTestModule;
import hydra.ResultLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DeadlockDetection {
    private static final File DEADLOCK_FILE = new File("deadlock.txt");
    private static final File DEPENDENCY_FILE = new File("thread_dependency_graph.ser");
    private static final File DEPENDENCY_FILE_TEXT = new File("thread_dependency_graph.text");

    public static void detectDeadlocks() {
        DeadlockDetection.detectDeadlocks(null);
    }

    public static synchronized void detectDeadlocks(ClientRecord failedClient) {
        block12: {
            try {
                if (RemoteTestModule.log != null) {
                    RemoteTestModule.log.info("Searching for deadlocks. Hung thread " + failedClient);
                } else if (MasterController.log != null) {
                    MasterController.log.info("Searching for deadlocks. Hung thread " + failedClient);
                }
                Map clientVms = ClientMgr.getClientVms();
                if (clientVms == null) {
                    clientVms = RemoteTestModule.Master.getClientVms();
                }
                Collection vmRecords = clientVms.values();
                ThreadReference failedThread = DeadlockDetection.getFailedThread(failedClient);
                DeadlockDetector detector = new DeadlockDetector();
                for (ClientVmRecord record : vmRecords) {
                    ClientRecord client = record.getRepresentativeClient();
                    if (client == null) continue;
                    MethExecutorResult results = client.getTestModule().executeMethodOnClass(DeadlockDetection.class.getName(), "collectDependencies");
                    if (results.exceptionOccurred()) {
                        throw results.getException();
                    }
                    Set dependencies = (Set)results.getResult();
                    detector.addDependencies(dependencies);
                }
                DeadlockDetection.writeDependencyFile(detector.getDependencyGraph());
                LinkedList deadlock = null;
                if (failedThread != null) {
                    DependencyGraph graph = detector.findDependencyGraph(failedThread);
                    DeadlockDetection.writeDependencies(failedThread, graph);
                    deadlock = graph.findCycle();
                }
                if (deadlock == null) {
                    deadlock = detector.findDeadlock();
                }
                if (deadlock != null) {
                    DeadlockDetection.writeDeadlock(deadlock);
                }
            }
            catch (Throwable t) {
                if (RemoteTestModule.log != null) {
                    RemoteTestModule.log.error("Error collecting dependencies for deadlock detection", t);
                }
                if (MasterController.log == null) break block12;
                MasterController.log.error("Error collecting dependencies for deadlock detection", t);
            }
        }
    }

    private static ThreadReference getFailedThread(ClientRecord failedClient) throws Throwable {
        if (failedClient == null) {
            return null;
        }
        MethExecutorResult result = failedClient.getTestModule().executeMethodOnClass(DeadlockDetection.class.getCanonicalName(), "findHydraThread", new Object[]{failedClient.getTid()});
        if (result.exceptionOccurred()) {
            throw result.getException();
        }
        return (ThreadReference)result.getResult();
    }

    private static synchronized void writeDeadlock(LinkedList<Dependency> deadlock) {
        StringBuilder out = new StringBuilder();
        out.append("\n==================================================================");
        out.append("\nDeadlock detected!!!");
        out.append("\n==================================================================\n");
        out.append(DeadlockDetector.prettyFormat(deadlock));
        String text = out.toString();
        ResultLogger.writeErrorFile(text);
        FileUtil.appendToFile(DEADLOCK_FILE.getName(), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeDependencyFile(DependencyGraph dependencyGraph) throws IOException {
        if (!DEPENDENCY_FILE.exists()) {
            FileOutputStream fos = new FileOutputStream(DEPENDENCY_FILE);
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));){
                oos.writeObject(dependencyGraph);
            }
            try (PrintStream ps = new PrintStream(DEPENDENCY_FILE_TEXT);){
                ps.print(DeadlockDetector.prettyFormat((DependencyGraph)dependencyGraph));
            }
        }
    }

    private static void writeDependencies(ThreadReference failedThread, DependencyGraph graph) {
        if (!DEADLOCK_FILE.exists()) {
            StringBuilder out = new StringBuilder();
            out.append("\n==================================================================");
            out.append("\nDependencies of hung hydra thread " + failedThread);
            out.append("\n==================================================================\n");
            out.append(DeadlockDetector.prettyFormat((DependencyGraph)graph));
            String text = out.toString();
            ResultLogger.writeErrorFile(text);
        }
    }

    public static ThreadReference findHydraThread(int hydraThreadId) {
        Thread[] allThreads;
        String locality = DeadlockDetection.getLocality();
        for (Thread thread : allThreads = DependencyMonitorManager.getAllThreads()) {
            if (!(thread instanceof HydraThread) || ((HydraThread)thread).getRemoteMod().getThreadId() != hydraThreadId) continue;
            return DeadlockDetector.getThreadReference((String)locality, (Thread)thread);
        }
        return null;
    }

    public static Set<Dependency> collectDependencies() {
        String locality = DeadlockDetection.getLocality();
        return DeadlockDetector.collectAllDependencies((Serializable)((Object)locality));
    }

    private static String getLocality() {
        String locality = MasterController.getNameFor(RemoteTestModule.getMyVmid(), -1, RemoteTestModule.getMyClientName(), RemoteTestModule.getMyHost(), RemoteTestModule.getMyPid());
        return locality;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException {
        if (args.length != 1) {
            System.err.println("Usage: java hydra.DeadlockDetection dependency_file.ser");
            System.err.println("Dumps the list of dependencies in human readable format");
        }
        File file = new File(args[0]);
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        DependencyGraph graph = (DependencyGraph)ois.readObject();
        System.out.println(DeadlockDetector.prettyFormat((DependencyGraph)graph));
    }
}

