/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.DerbyServerHelper;
import hydra.EnvHelper;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.Nuker;
import hydra.PortHelper;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.ProductVersionHelper;
import hydra.TestConfig;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class DerbyServerMgr {
    private static String defaultDerbyNetJarPath;
    private static final String cpSep;
    private static final String JAVA_CMD;
    private static final int MAX_WAIT_SEC = 300;
    private static int Port;
    private static int PID;
    private static DerbyServerHelper.Endpoint DerbyServerEndpoint;

    protected static String getDerbyCmd(HostDescription hd) {
        String derbyNetJarPath = defaultDerbyNetJarPath;
        Long key = null;
        Vector paths = TestConfig.tab().vecAt(key, null);
        if (paths != null) {
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                String path = TestConfig.tab().getString(key, it.next());
                if (path != null && !path.equalsIgnoreCase("none")) continue;
                it.remove();
            }
            if (paths.size() > 0) {
                paths = EnvHelper.expandEnvVars(paths, hd);
                derbyNetJarPath = EnvHelper.asPath(paths, hd);
            }
        }
        Log.getLogWriter().fine("derbynet.jar path: " + derbyNetJarPath);
        String derbyCmd = "-classpath " + derbyNetJarPath + cpSep + System.getProperty("JTESTS") + " " + "org.apache.derby.drda.NetworkServerControl ";
        return derbyCmd;
    }

    protected static void startDerbyServer() {
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        String host = hd.getHostName();
        Port = PortHelper.getRandomPort();
        Log.getLogWriter().info("Starting derby server at " + host + ":" + Port + "...");
        String args = DerbyServerMgr.getExtraDerbyServerVMArgs();
        if (args.length() > 0) {
            args = args + " ";
        }
        String cmd = JAVA_CMD + args + DerbyServerMgr.getDerbyCmd(hd) + "start -noSecurityManager -h " + host + " -p " + Port;
        PID = ProcessMgr.bgexec(cmd);
        Nuker.getInstance().recordPID(hd, PID);
        DerbyServerEndpoint = new DerbyServerHelper.Endpoint(host, Port, PID);
        ProcessMgr.waitForLife(host, PID, 300);
        Log.getLogWriter().info("Started derby server with pid=" + PID + " at " + host + ":" + Port);
    }

    protected static void stopDerbyServer() {
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        String host = hd.getHostName();
        Log.getLogWriter().info("Stopping derby server at " + host + ":" + Port + "...");
        String cmd = JAVA_CMD + DerbyServerMgr.getDerbyCmd(hd) + "shutdown -h " + host + " -p " + Port;
        if (TestConfig.tab().booleanAt(Prms.testSecurity, false)) {
            cmd = cmd + " -user superUser -password superUser ";
        }
        ProcessMgr.fgexec(cmd, 300);
        ProcessMgr.waitForDeath(host, PID, 300);
        DerbyServerEndpoint = null;
        Nuker.getInstance().removePID(hd, PID);
        Log.getLogWriter().info("Stopped derby server with pid=" + PID + " at " + host + ":" + Port);
    }

    protected static DerbyServerHelper.Endpoint getEndpoint() {
        return DerbyServerEndpoint;
    }

    protected static String getExtraDerbyServerVMArgs() {
        HydraVector args = TestConfig.tab().vecAt(Prms.extraDerbyServerVMArgs, null);
        if (args == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        Iterator it = args.iterator();
        while (it.hasNext()) {
            str.append(it.next());
        }
        return str.toString();
    }

    static {
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        if (HostHelper.getLocalHostOS() == HostHelper.OSType.windows) {
            defaultDerbyNetJarPath = hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "libs" + hd.getFileSep() + "snappydata-store-hydra-tests-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + "-all.jar";
            cpSep = ";";
        } else {
            defaultDerbyNetJarPath = hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "libs" + hd.getFileSep() + "snappydata-store-hydra-tests-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + "-all.jar";
            cpSep = ":";
        }
        JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java ";
    }
}

