/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.MasterProxy;
import hydra.MasterProxyIF;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.rmi.RemoteException;
import java.util.Properties;

public class DistributedConnectionMgr {
    private static DistributedSystem vmConnection = null;
    private static MasterProxyIF Master;

    public static DistributedSystem getConnection() {
        return vmConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DistributedSystem connect(String cacheXmlFile) {
        if (vmConnection == null) {
            String gemfireName = System.getProperty("gemfireName");
            if (gemfireName == null) {
                throw new HydraConfigException("No gemfire name has been specified");
            }
            GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
            if (!HostHelper.isLocalHost(gfd.getHostDescription().getHostName())) throw new HydraConfigException(gemfireName + " is on remote system " + gfd.getHostDescription().getHostName());
            DistributedConnectionMgr._connect(gfd, cacheXmlFile);
            return vmConnection;
        } else {
            if (cacheXmlFile == null) return vmConnection;
            throw new HydraRuntimeException("Cannot honor " + cacheXmlFile + " because there is already a connection to the distributed system");
        }
    }

    public static DistributedSystem connect() {
        return DistributedConnectionMgr.connect(null);
    }

    public static DistributedSystem connect(String name, Properties props) {
        if (vmConnection == null) {
            GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(name);
            if (HostHelper.isLocalHost(gfd.getHostDescription().getHostName())) {
                DistributedConnectionMgr._connectWithProps(gfd, props);
            } else {
                throw new HydraConfigException(name + " is on remote system " + gfd.getHostDescription().getHostName());
            }
        }
        return vmConnection;
    }

    public static synchronized void disconnect() {
        if (vmConnection != null) {
            vmConnection.disconnect();
            vmConnection = null;
        }
    }

    public static boolean isConnected() {
        if (vmConnection == null) {
            return false;
        }
        return vmConnection.isConnected();
    }

    private static synchronized void _connectWithProps(GemFireDescription gfd, Properties props) {
        if (HostHelper.isLocalHost(gfd.getHostDescription().getHostName())) {
            if (vmConnection == null) {
                if (!gfd.getUseLocator().booleanValue()) {
                    DistributedConnectionMgr.lock();
                }
                vmConnection = DistributedSystem.connect((Properties)props);
                if (!gfd.getUseLocator().booleanValue()) {
                    DistributedConnectionMgr.unlock();
                }
            }
        } else {
            throw new HydraRuntimeException("Cannot connect VM on host " + HostHelper.getLocalHost() + " to GemFire " + gfd.getName() + " on remote host " + gfd.getHostDescription().getHostName());
        }
    }

    private static synchronized void _connect(GemFireDescription gfd, String cacheXmlFile) {
        if (HostHelper.isLocalHost(gfd.getHostDescription().getHostName())) {
            if (vmConnection == null) {
                Properties p = gfd.getDistributedSystemProperties();
                if (cacheXmlFile != null) {
                    p.setProperty("cache-xml-file", cacheXmlFile);
                }
                if (!gfd.getUseLocator().booleanValue()) {
                    DistributedConnectionMgr.lock();
                }
                vmConnection = DistributedSystem.connect((Properties)p);
                if (!gfd.getUseLocator().booleanValue()) {
                    DistributedConnectionMgr.unlock();
                }
            }
        } else {
            throw new HydraRuntimeException("Cannot connect VM on host " + HostHelper.getLocalHost() + " to GemFire " + gfd.getName() + " on remote host " + gfd.getHostDescription().getHostName());
        }
    }

    private static void lock() {
    }

    private static void unlock() {
    }

    private static MasterProxyIF master() throws RemoteException {
        if (Master == null) {
            Master = RemoteTestModule.Master == null ? new MasterProxy() : RemoteTestModule.Master;
        }
        return Master;
    }
}

