/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.JoinerThread;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.HashMap;
import java.util.Map;

public class DynamicActionUtil {
    private static Map DynamicActions = new HashMap();
    private static int actionId = 0;

    protected static synchronized int nextActionId() {
        return ++actionId;
    }

    protected static void runActionThread(int actionId, String act, Runnable action, String name, boolean synchronous) {
        DynamicActionUtil.log().info("Issuing " + act);
        PidSignal signal = null;
        if (synchronous) {
            signal = DynamicActionUtil.setUpDynamicActionCompleteSignal(actionId);
        }
        JoinerThread t = new JoinerThread(action, name);
        t.start();
        if (synchronous) {
            try {
                DynamicActionUtil.log().info("Waiting for completion of " + act);
                t.join();
            }
            catch (InterruptedException e) {
                DynamicActionUtil.log().severe("Thread was interrupted");
            }
            DynamicActionUtil.waitForDynamicActionToComplete(actionId, signal);
            DynamicActionUtil.log().info("Completed " + act);
        } else {
            DynamicActionUtil.log().info("Not waiting for completion of " + act);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PidSignal setUpDynamicActionCompleteSignal(int actionId) {
        int mypid = RemoteTestModule.getMyPid();
        PidSignal signal = new PidSignal(mypid);
        Map map = DynamicActions;
        synchronized (map) {
            DynamicActions.put(actionId, signal);
        }
        return signal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForDynamicActionToComplete(int actionId, PidSignal signal) {
        Object object = signal;
        synchronized (object) {
            try {
                while (!signal.notified()) {
                    signal.wait();
                }
            }
            catch (InterruptedException e) {
                DynamicActionUtil.log().severe("Thread was interrupted");
            }
        }
        object = DynamicActions;
        synchronized (object) {
            DynamicActions.remove(actionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyDynamicActionComplete(int actionId) {
        PidSignal signal = (PidSignal)DynamicActions.get(actionId);
        if (signal != null && RemoteTestModule.getMyPid() == signal.getPid()) {
            PidSignal pidSignal = signal;
            synchronized (pidSignal) {
                signal.signal();
                signal.notify();
            }
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    private static class PidSignal {
        int pid = -1;

        protected PidSignal(int pid) {
            this.pid = pid;
        }

        protected int getPid() {
            return this.pid;
        }

        protected void signal() {
            this.pid = -1;
        }

        protected boolean notified() {
            return this.pid == -1;
        }

        public String toString() {
            return String.valueOf(this.pid);
        }
    }
}

