/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HydraRuntimeException;
import hydra.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class FileUtil {
    private static final char NEWLINE = '\n';

    public static boolean isAbsoluteFilename(String name) {
        File f = new File(name);
        return name.equals(f.getAbsolutePath());
    }

    public static File fileForName(String name) {
        if (name == null) {
            return null;
        }
        File f = new File(name);
        return f;
    }

    public static String pathFor(String fullname) {
        File f = new File(fullname);
        return f.getParent();
    }

    public static String absoluteFilenameFor(String name) {
        File f = new File(name);
        return f.getAbsolutePath();
    }

    public static String filenameFor(String fullname) {
        File f = new File(fullname);
        return f.getName();
    }

    public static Vector makeAbsolute(Vector fns, String defaultPath) {
        if (fns == null) {
            return null;
        }
        for (int i = 0; i < fns.size(); ++i) {
            String fn = (String)fns.elementAt(i);
            String fullfn = FileUtil.makeAbsolute(fn, defaultPath);
            fns.setElementAt(fullfn, i);
        }
        return fns;
    }

    public static String makeAbsolute(String fn, String defaultPath) {
        return FileUtil.isAbsoluteFilename(fn) ? fn : defaultPath + fn;
    }

    public static File getFile(File dir, String fn) {
        if (!dir.isAbsolute()) {
            throw new HydraRuntimeException(dir + " is not an absolute path");
        }
        File f = new File(dir.getAbsolutePath() + File.separator + fn);
        return f.exists() ? f : null;
    }

    public static List getFiles(File dir, FileFilter filter, boolean recursive) {
        File[] files;
        if (!dir.isAbsolute()) {
            throw new HydraRuntimeException(dir + " is not an absolute path");
        }
        File[] tmpfiles = dir.listFiles(filter);
        ArrayList<Object> matches = tmpfiles == null ? new ArrayList() : new ArrayList<File>(Arrays.asList(tmpfiles));
        if (recursive && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory()) continue;
                matches.addAll(FileUtil.getFiles(file, filter, recursive));
            }
        }
        return matches;
    }

    public static boolean exists(File f) {
        return f.exists();
    }

    public static boolean exists(String name) {
        return FileUtil.exists(new File(name));
    }

    public static boolean fileExists(String name) {
        File f = new File(name);
        if (f.exists()) {
            if (f.isFile()) {
                return true;
            }
            throw new HydraRuntimeException(name + " exists and is not a file");
        }
        return false;
    }

    public static String tmpNameFor(String name) {
        File f = new File(name);
        return f.getName() + ".tmp";
    }

    public static void mkdir(String dirname) {
        FileUtil.mkdir(new File(dirname));
    }

    public static void mkdir(File dir) {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Error("Error: " + dir + " already exists but is not a directory");
            }
        } else if (!dir.mkdirs() && !dir.mkdir()) {
            throw new Error("Error: Unable to make directory " + dir);
        }
    }

    public static void createNewFile(String name) throws IOException {
        File f = new File(name);
        f.createNewFile();
    }

    public static void deleteFile(String name) {
        File f = new File(name);
        if (f.exists()) {
            if (f.isFile()) {
                if (!f.delete()) {
                    throw new Error("Error: Unable to delete file " + name);
                }
            } else {
                throw new Error("Error: " + name + " exists and is not a file");
            }
        }
    }

    public static boolean rmdir(String name, boolean throwOnFailure) {
        boolean result = true;
        File f = new File(name);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    result = FileUtil.rmdir(files[i].getPath(), throwOnFailure) & result;
                }
            }
            if (!f.delete()) {
                if (throwOnFailure) {
                    throw new HydraRuntimeException("Unable to delete " + f);
                }
                result = false;
            }
        } else {
            if (throwOnFailure) {
                throw new HydraRuntimeException("Not found: " + f);
            }
            result = false;
        }
        return result;
    }

    public static void deleteDirAndContents(String name) {
        FileUtil.deleteFilesFromDir(name);
        FileUtil.deleteDir(name);
    }

    public static void deleteFilesFromDir(String name) {
        File dir = new File(name);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].delete()) continue;
                        throw new Error("Error: Unable to delete file " + files[i].getName());
                    }
                }
            } else {
                throw new Error("Error: " + name + " exists but is not a directory");
            }
        }
    }

    public static void deleteFilesFromDirRecursive(String name) {
        File dir = new File(name);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].delete()) continue;
                        if (files[i].isDirectory()) {
                            FileUtil.deleteFilesFromDirRecursive(files[i].getAbsolutePath());
                            continue;
                        }
                        throw new Error("Error: Unable to delete file " + files[i].getName());
                    }
                }
            } else {
                throw new Error("Error: " + name + " exists but is not a directory");
            }
        }
    }

    public static void deleteDir(String name) {
        File dir = new File(name);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                if (!dir.delete()) {
                    throw new Error("Error: Unable to delete directory " + name);
                }
            } else {
                throw new Error("Error: " + name + " exists and is not a directory");
            }
        }
    }

    public static void moveFile(String src, String dst) {
        if (FileUtil.fileExists(src)) {
            boolean moved = new File(src).renameTo(new File(dst));
            if (!moved) {
                throw new HydraRuntimeException("Failed to copy " + src + " to " + dst);
            }
        } else {
            throw new HydraRuntimeException(src + " does not exist");
        }
    }

    public static void copyFileOverTop(String src, String dst) {
        try {
            if (FileUtil.fileExists(dst)) {
                FileUtil.deleteFile(dst);
            }
            FileUtil.copyFile(new File(src), new File(dst));
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Failed to copy " + src + " to " + dst, e);
        }
    }

    public static void copyBytesToFile(byte[] src, String dst) {
        try {
            FileUtil.copyBytesToFile(src, new File(dst));
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Failed to copy src to " + dst, e);
        }
    }

    public static void copyFile(String src, String dst) {
        try {
            FileUtil.copyFile(new File(src), new File(dst));
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Failed to copy " + src + " to " + dst, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytesToFile(byte[] src, File dst) throws IOException {
        if (dst.exists()) {
            throw new IOException("The destination file \"" + dst.getPath() + "\" already exists.");
        }
        File dstParent = (dst = dst.getAbsoluteFile()).getParentFile();
        if (dstParent != null) {
            if (!dstParent.exists()) {
                throw new IOException("The destination directory \"" + dstParent.getPath() + "\" does not exist.");
            }
            if (!dstParent.canWrite()) {
                throw new IOException("The destination directory \"" + dstParent.getPath() + "\" is not writable.");
            }
        }
        ByteArrayInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new ByteArrayInputStream(src);
            try {
                out = new FileOutputStream(dst);
            }
            catch (IOException io) {
                throw new IOException("Failed to create \"" + dst.getPath() + "\" because: " + io.toString());
            }
            try {
                int bytesRead;
                byte[] buffer = new byte[16184];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException io) {
                throw new IOException("Copying src to \"" + dst.getPath() + "\" failed because: " + io.toString());
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new IOException("The source file \"" + src.getPath() + "\" does not exist.");
        }
        if (dst.exists()) {
            throw new IOException("The destination file \"" + dst.getPath() + "\" already exists.");
        }
        if (!src.isFile()) {
            throw new IOException("The source file \"" + src.getPath() + "\" is not a file.");
        }
        if (!src.canRead()) {
            throw new IOException("The source file \"" + src.getPath() + "\" is not readable.");
        }
        File dstParent = (dst = dst.getAbsoluteFile()).getParentFile();
        if (dstParent != null) {
            if (!dstParent.exists()) {
                throw new IOException("The destination directory \"" + dstParent.getPath() + "\" does not exist.");
            }
            if (!dstParent.canWrite()) {
                throw new IOException("The destination directory \"" + dstParent.getPath() + "\" is not writable.");
            }
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(src);
            }
            catch (IOException io) {
                throw new IOException("Failed to open \"" + src.getPath() + "\" because: " + io.toString());
            }
            try {
                out = new FileOutputStream(dst);
            }
            catch (IOException io) {
                throw new IOException("Failed to create \"" + dst.getPath() + "\" because: " + io.toString());
            }
            try {
                int bytesRead;
                byte[] buffer = new byte[16184];
                while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException io) {
                throw new IOException("Copying \"" + src.getPath() + "\" to \"" + dst.getPath() + "\" failed because: " + io.toString());
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeToFile(String fn, String txt) {
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            fos.write(txt.getBytes());
            fos.close();
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to write to file: " + fn, e);
        }
    }

    public static void appendToFile(String fn, String txt) {
        try {
            boolean append = true;
            FileOutputStream fos = new FileOutputStream(fn, append);
            fos.write(txt.getBytes());
            fos.close();
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to append to file: " + fn, e);
        }
    }

    public static boolean hasLinesContaining(String fn, String substring) {
        try {
            boolean result = false;
            BufferedReader br = new BufferedReader(new FileReader(fn));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(substring) == -1) continue;
                result = true;
                break;
            }
            br.close();
            return result;
        }
        catch (FileNotFoundException e) {
            throw new HydraRuntimeException("Unable to find file: " + fn, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to search file: " + fn, e);
        }
    }

    public static String readInFile(String fn, String prefix) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fn));
            String line = null;
            while ((line = br.readLine()) != null && !line.startsWith(prefix)) {
            }
            br.close();
            return line;
        }
        catch (FileNotFoundException e) {
            throw new HydraRuntimeException("Unable to find file: " + fn, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to read file: " + fn, e);
        }
    }

    public static void replaceInFile(String fn, String prefix, String newtxt) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fn));
            Vector<String> lines = new Vector<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(prefix)) {
                    line = newtxt;
                }
                lines.add(line);
            }
            br.close();
            File tf = File.createTempFile(FileUtil.filenameFor(fn), ".tmp");
            String tfn = tf.getAbsolutePath();
            if (Log.getLogWriter().finestEnabled()) {
                Log.getLogWriter().finest("Writing to " + tfn);
            }
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(tf)));
            Iterator i = lines.iterator();
            while (i.hasNext()) {
                pw.println((String)i.next());
            }
            pw.close();
            FileUtil.copyFileOverTop(tfn, fn);
            FileUtil.deleteFile(tfn);
        }
        catch (FileNotFoundException e) {
            throw new HydraRuntimeException("Unable to find file: " + fn, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to modify file: " + fn, e);
        }
    }

    public static String getContents(String fn) throws FileNotFoundException, IOException {
        String s;
        StringBuffer buf = new StringBuffer(1000);
        BufferedReader br = new BufferedReader(new FileReader(fn));
        while ((s = br.readLine()) != null) {
            buf.append(s);
        }
        br.close();
        return buf.toString();
    }

    public static String getContentsWithSpace(String fn) throws FileNotFoundException, IOException {
        String s;
        StringBuffer buf = new StringBuffer(1000);
        BufferedReader br = new BufferedReader(new FileReader(fn));
        boolean firstLine = true;
        while ((s = br.readLine()) != null) {
            if (!firstLine) {
                buf.append(" ");
            }
            buf.append(s);
            firstLine = false;
        }
        br.close();
        return buf.toString();
    }

    public static String getText(String fn) throws FileNotFoundException, IOException {
        String s;
        StringBuffer buf = new StringBuffer(1000);
        BufferedReader br = new BufferedReader(new FileReader(fn));
        while ((s = br.readLine()) != null) {
            buf.append(s);
            buf.append('\n');
        }
        br.close();
        return buf.toString();
    }

    public static List<String> getTextAsList(String fn) throws FileNotFoundException, IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(fn));
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    public static SortedSet<String> getTextAsSet(String fn) throws FileNotFoundException, IOException {
        String line;
        TreeSet<String> lines = new TreeSet<String>();
        BufferedReader br = new BufferedReader(new FileReader(fn));
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    public static List<String> getTextAsTokens(String fn) throws FileNotFoundException, IOException {
        String text = FileUtil.getContentsWithSpace(fn);
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, " ", false);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken().trim());
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, String> getPropertiesAsMap(String fn) throws FileNotFoundException, IOException {
        try (FileInputStream propFile = new FileInputStream(fn);){
            Properties p = new Properties();
            p.load(propFile);
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.putAll(p);
            TreeMap<String, String> treeMap = map;
            return treeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fn) throws FileNotFoundException, IOException {
        try (FileInputStream propFile = new FileInputStream(fn);){
            Properties p = new Properties();
            p.load(propFile);
            Properties properties = p;
            return properties;
        }
    }

    public static Properties getPropertiesFromResource(String fn) throws IOException {
        InputStream is = FileUtil.class.getClassLoader().getResourceAsStream(fn);
        if (is == null) {
            return null;
        }
        Properties p = new Properties();
        p.load(is);
        return p;
    }

    public static void serialize(Object obj, String fn) {
        try {
            ObjectOutputStream f = new ObjectOutputStream(new FileOutputStream(fn));
            f.writeObject(obj);
            f.flush();
            f.close();
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Failed to serialize to: " + fn, e);
        }
    }

    public static Object deserialize(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            ObjectInputStream f = new ObjectInputStream(fis);
            Object obj = f.readObject();
            f.close();
            return obj;
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Failed to deserialize from: " + fn, e);
        }
    }

    public static byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Failed to serialize a " + obj.getClass().getName(), e);
        }
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bais);
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Failed to deserialize", e);
        }
    }
}

