/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.FixedPartitionPrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class FixedPartitionDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private Integer datastores;
    private String mappingClass;
    private String mappingMethod;
    private List<String> partitionNames;
    private List<Integer> partitionBuckets;
    private transient List<FixedPartitionAttributes> fixedPartitionAttributes;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public Integer getDatastores() {
        return this.datastores;
    }

    private void setDatastores(Integer i) {
        this.datastores = i;
    }

    private String getMappingAlgorithm() {
        return this.getMappingClass() + "." + this.getMappingMethod() + "()";
    }

    private String getMappingClass() {
        return this.mappingClass;
    }

    private void setMappingClass(String str) {
        this.mappingClass = str;
    }

    private String getMappingMethod() {
        return this.mappingMethod;
    }

    private void setMappingMethod(String str) {
        this.mappingMethod = str;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    private void setPartitionNames(List<String> strs) {
        this.partitionNames = strs;
    }

    public List<Integer> getPartitionBuckets() {
        return this.partitionBuckets;
    }

    private void setPartitionBuckets(List<Integer> ints) {
        this.partitionBuckets = ints;
    }

    protected synchronized List<FixedPartitionAttributes> getFixedPartitionAttributes(String regionName, int redundantCopies) {
        if (this.fixedPartitionAttributes == null) {
            Object[] args = new Object[]{regionName, this, redundantCopies};
            MethExecutorResult result = MethExecutor.execute(this.getMappingClass(), this.getMappingMethod(), args);
            if (result.getStackTrace() != null) {
                throw new HydraRuntimeException(result.toString());
            }
            List fpas = (List)result.getResult();
            if (fpas != null && fpas.size() != 0) {
                this.fixedPartitionAttributes = fpas;
            }
        }
        return this.fixedPartitionAttributes;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "datastores", this.getDatastores());
        map.put(header + "mappingAlgorithm", this.getMappingAlgorithm());
        map.put(header + "partitionNames", this.getPartitionNames());
        map.put(header + "partitionBuckets", this.getPartitionBuckets());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(FixedPartitionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            FixedPartitionDescription fpd = FixedPartitionDescription.createFixedPartitionDescription(name, config, i);
            config.addFixedPartitionDescription(fpd);
        }
    }

    private static FixedPartitionDescription createFixedPartitionDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        FixedPartitionDescription fpd = new FixedPartitionDescription();
        fpd.setName(name);
        Long key = FixedPartitionPrms.datastores;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            String s = BasePrms.nameForKey(key) + " is a required field";
            throw new HydraConfigException(s);
        }
        fpd.setDatastores(i);
        key = FixedPartitionPrms.mappingAlgorithm;
        HydraVector strs = tab.vecAtWild(key, index, null);
        fpd.setMappingClass(FixedPartitionDescription.getMappingClass(strs, key));
        fpd.setMappingMethod(FixedPartitionDescription.getMappingMethod(strs, key));
        key = FixedPartitionPrms.partitionNames;
        strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
        }
        if (strs == null || strs.size() == 0) {
            String s = BasePrms.nameForKey(key) + " is a required field";
            throw new HydraConfigException(s);
        }
        fpd.setPartitionNames(new ArrayList<String>(strs));
        List<String> fpnames = fpd.getPartitionNames();
        if (fpnames != null) {
            Long key2 = FixedPartitionPrms.partitionBuckets;
            HydraVector strs2 = tab.vecAtWild(key2, index, null);
            ArrayList<Integer> fpsizes = new ArrayList<Integer>();
            Integer defaultBuckets = 1;
            for (int i3 = 0; i3 < fpnames.size(); ++i3) {
                if (strs2 == null || strs2.size() == 0) {
                    fpsizes.add(defaultBuckets);
                    continue;
                }
                if (i3 < strs2.size()) {
                    String str = tab.getString(key2, strs2.get(i3));
                    if (str == null) {
                        fpsizes.add(defaultBuckets);
                        continue;
                    }
                    fpsizes.add(FixedPartitionDescription.getIntegerFor(str, key2));
                    continue;
                }
                fpsizes.add((Integer)fpsizes.get(i3 - 1));
            }
            fpd.setPartitionBuckets(fpsizes);
        }
        return fpd;
    }

    private static String getMappingClass(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "hydra.FixedPartitionHelper";
        }
        if (strs.size() == 2) {
            return (String)strs.get(0);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static String getMappingMethod(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "assignRoundRobin";
        }
        if (strs.size() == 2) {
            return (String)strs.get(1);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }
}

