/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.GFMonPrms;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Java;
import hydra.Log;
import hydra.Nuker;
import hydra.ProcessMgr;
import hydra.ResultLogger;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GFMonMgr {
    protected static final String GFMON_DIR = "gfmon";
    private static int PID = -1;

    protected static void start() {
        if (GFMonPrms.getTestClassName() != null) {
            GFMonMgr.log().info("Setting preferences for GFMon/WindowTester VM...");
            try {
                GFMonMgr.setCurrentPreferences();
            }
            catch (BackingStoreException e) {
                throw new HydraRuntimeException("While setting preferences", e);
            }
            GFMonMgr.log().info("Set preferences for GFMon/WindowTester VM...");
            GFMonMgr.log().info("Starting GFMon/WindowTester VM...");
            PID = Java.javaGFMon();
            int maxWaitSec = GFMonPrms.getMaxStartupWaitSec();
            GFMonMgr.log().info("Waiting " + maxWaitSec + " seconds for process with pid=" + PID + " to start...");
            if (ProcessMgr.waitForLife(HostHelper.getLocalHost(), PID, maxWaitSec)) {
                GFMonMgr.log().info("Started GFMon/WindowTester VM with pid=" + PID);
            } else {
                String s = "Failed to start GFMon/WindowTester VM with pid=" + PID + " within " + maxWaitSec + " seconds.";
                throw new HydraTimeoutException(s);
            }
        }
    }

    protected static void waitForStop() {
        if (PID != -1) {
            GFMonMgr.log().info("Waiting for GFMon/WindowTester VM pid=" + PID + " to stop...");
            int maxWaitSec = GFMonPrms.getMaxShutdownWaitSec();
            GFMonMgr.log().info("Waiting " + maxWaitSec + " seconds for process with pid=" + PID + " to stop...");
            if (ProcessMgr.waitForDeath(HostHelper.getLocalHost(), PID, maxWaitSec)) {
                GFMonMgr.log().info("GFMon/WindowTester VM with pid=" + PID + " has stopped");
                HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
                Nuker.getInstance().removePID(hd, PID);
                String resultFileName = System.getProperty("user.dir") + File.separator + "wintest/" + GFMonPrms.getTestClassName() + "-result.xml";
                GFMonMgr.parseXml(resultFileName, PID);
                PID = -1;
            } else {
                String s = "GFMon/WindowTester VM with pid=" + PID + " failed to stop within " + maxWaitSec + " seconds.";
                throw new HydraTimeoutException(s);
            }
        }
    }

    private static void setCurrentPreferences() throws BackingStoreException {
        String currDir = System.getProperty("user.dir");
        String modDir = currDir.replace('\\', '/');
        Preferences currentUser = Preferences.userRoot().node("GemFire Monitor 2.0").node(modDir);
        currentUser.put("prefs_dir", currDir + File.separator + GFMON_DIR);
        currentUser.flush();
        currentUser.sync();
        GFMonMgr.log().info("Set current preferences: " + GFMonMgr.preferencesToString(currentUser));
    }

    private static String preferencesToString(Preferences prefs) throws BackingStoreException {
        StringBuffer buf = new StringBuffer();
        buf.append(prefs);
        String[] keys = prefs.keys();
        for (int i = 0; i < keys.length; ++i) {
            buf.append("\n" + keys[i] + "=" + prefs.get(keys[i], null));
        }
        return buf.toString();
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    public static void parseXml(String fn, int pid) {
        File f = new File(fn);
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new HydraRuntimeException("While creating SAX parser", e);
        }
        catch (SAXException e) {
            throw new HydraRuntimeException("While creating SAX parser", e);
        }
        XMLHandler handler = new XMLHandler(pid);
        try {
            parser.parse(f, (DefaultHandler)handler);
        }
        catch (HydraRuntimeException e) {
            throw new HydraRuntimeException("While parsing " + f, (Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new HydraRuntimeException("While parsing " + f, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("While parsing " + f, e);
        }
    }

    static class XMLHandler
    extends DefaultHandler {
        private List stack = null;
        int pid = -1;

        public XMLHandler(int pid) {
            this.pid = pid;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return this.resolveEntity(publicId, systemId);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startError(Attributes attributes) {
            String s;
            String qName;
            int i;
            if (this.stack == null) {
                this.stack = new ArrayList();
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                qName = attributes.getQName(i);
                if (!qName.equals("type")) continue;
                s = attributes.getValue(i);
                this.stack.add(s + ": ");
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                qName = attributes.getQName(i);
                if (!qName.equals("message")) continue;
                s = attributes.getValue(i);
                this.stack.add(s + "\n\n");
            }
        }

        public void startFailure(Attributes attributes) {
            String s;
            String qName;
            int i;
            if (this.stack == null) {
                this.stack = new ArrayList();
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                qName = attributes.getQName(i);
                if (!qName.equals("type")) continue;
                s = attributes.getValue(i);
                this.stack.add(s + ": ");
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                qName = attributes.getQName(i);
                if (!qName.equals("message")) continue;
                s = attributes.getValue(i);
                this.stack.add(s + "\n\n");
            }
        }

        public void startTestSuite(Attributes attributes) {
            String errors = attributes.getValue("errors");
            String failures = attributes.getValue("failures");
            String name = attributes.getValue("name");
            String report = "WINDOWTESTER/GFMON REPORT for " + name + ":" + " errors=" + errors + " failures=" + failures;
            Log.getLogWriter().info(report);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("testsuite")) {
                this.startTestSuite(attributes);
            } else if (qName.equals("error")) {
                this.startError(attributes);
            } else if (qName.equals("failure")) {
                this.startFailure(attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.stack != null) {
                this.processStack(qName);
            }
        }

        private void processStack(String qName) {
            StringBuffer buf = new StringBuffer();
            if (this.stack.size() == 0) {
                buf.append("no information available");
            } else {
                Iterator i = this.stack.iterator();
                while (i.hasNext()) {
                    buf.append((String)i.next());
                }
            }
            if (qName.equals("error")) {
                ResultLogger.reportErr(this.pid, buf.toString());
            } else if (qName.equals("failure")) {
                ResultLogger.reportHang(this.pid, buf.toString());
            } else {
                ResultLogger.reportHang(this.pid, qName + ": " + buf.toString());
            }
            this.stack = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.stack != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(ch, start, length);
                this.stack.add(buf.toString());
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            Log.getLogWriter().warning("While parsing", (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

