/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Prms;
import hydra.TestConfig;
import java.util.Iterator;

public class GFMonPrms
extends BasePrms {
    public static final String DEFAULT_EXTRA_VM_ARGS = "-Xms64m -Xmx256m";
    public static final String LOG_LEVEL_PROPERTY_NAME = "logLevel";
    public static Long testClassName;
    public static Long extraVMArgs;
    public static Long maxStartupWaitSec;
    public static Long maxShutdownWaitSec;
    public static Long logLevel;

    public static String getTestClassName() {
        Long key = testClassName;
        String val = GFMonPrms.tab().stringAt(key, null);
        return val;
    }

    protected static String getExtraVMArgs() {
        Long key = extraVMArgs;
        String args = DEFAULT_EXTRA_VM_ARGS;
        HydraVector val = GFMonPrms.tab().vecAt(extraVMArgs, null);
        if (val != null) {
            Iterator it = val.iterator();
            while (it.hasNext()) {
                try {
                    String arg = (String)it.next();
                    if (arg.equals("=")) {
                        String s = "Malformed value in " + GFMonPrms.nameForKey(key) + ", use quotes to include '='";
                        throw new HydraConfigException(s);
                    }
                    args = args + " " + arg;
                }
                catch (ClassCastException e) {
                    String s = "Malformed value in " + GFMonPrms.nameForKey(key) + ", use single string or list of values";
                    throw new HydraConfigException(s, e);
                }
            }
        }
        if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
            args = args + " -Djava.net.preferIPv6Addresses=true";
        }
        return args;
    }

    public static int getMaxStartupWaitSec() {
        Long key = maxStartupWaitSec;
        int val = GFMonPrms.tab().intAt(key, 300);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " cannot be negative: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getMaxShutdownWaitSec() {
        Long key = maxShutdownWaitSec;
        int val = GFMonPrms.tab().intAt(key, 300);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " cannot be negative: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static String getLogLevel() {
        Long key = logLevel;
        return GFMonPrms.tab().stringAt(key, "info");
    }

    static {
        GFMonPrms.setValues(GFMonPrms.class);
    }
}

