/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewayDescription;
import hydra.GatewayHelper;
import hydra.GatewayHubBlackboard;
import hydra.GatewayHubDescription;
import hydra.GatewayHubPrms;
import hydra.GatewayHubVersionHelper;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GatewayHubHelper {
    private static String TheGatewayHubConfig;
    private static String TheGatewayConfig;
    private static String TheWBCLGatewayConfig;
    private static LogWriter log;

    public static synchronized GatewayHub createGatewayHub(String gatewayHubConfig) {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub == null) {
            GatewayHubDescription ghd = GatewayHubHelper.getGatewayHubDescription(gatewayHubConfig);
            ghd.setAsynchronousGatewayDistributionEnabledProperty();
            String id = GatewayHubHelper.getId(ghd);
            int port = GatewayHubHelper.getPort(ghd, id);
            GatewayHubHelper.log("Creating gateway hub with id: " + id + " and port: " + port);
            hub = CacheFactory.getAnyInstance().addGatewayHub(id, port);
            GatewayHubHelper.log("Configuring gateway hub: " + GatewayHubHelper.gatewayHubToString(hub));
            ghd.configure(hub);
            GatewayHubHelper.log("Configured gateway hub: " + GatewayHubHelper.gatewayHubToString(hub));
            TheGatewayHubConfig = gatewayHubConfig;
        } else {
            if (TheGatewayHubConfig == null) {
                String s = "Gateway hub was already created without GatewayHubHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheGatewayHubConfig.equals(gatewayHubConfig)) {
                String s = "Gateway hub already exists using logical gateway hub configuration named " + TheGatewayHubConfig + ", cannot also use " + gatewayHubConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return hub;
    }

    public static synchronized void addGateways(String gatewayConfig) {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub == null) {
            throw new HydraRuntimeException("Gateway hub not created yet");
        }
        if (hub.getGateways().size() == 0) {
            GatewayHubHelper.log("Adding gateways to hub using gateway config: " + gatewayConfig);
            GatewayDescription gd = GatewayHelper.getGatewayDescription(gatewayConfig);
            List endpoints = GatewayHubHelper.getEndpoints();
            String ownds = DistributedSystemHelper.getDistributedSystemName();
            Set dsnames = GatewayHubHelper.getDistributedSystemNames(endpoints);
            for (String dsname : dsnames) {
                if (dsname.equals(ownds)) continue;
                int vmid = RemoteTestModule.getMyVmid();
                String id = dsname;
                GatewayHubHelper.log("Configuring gateway with id: " + id);
                Gateway gateway = GatewayHubVersionHelper.addGateway(hub, id, gd);
                gd.configure(gateway, dsname, endpoints, true);
                GatewayHubHelper.log("Configured gateway: " + GatewayHelper.gatewayToString(gateway));
            }
            TheGatewayConfig = gatewayConfig;
            GatewayHubHelper.log("Added gateways to hub");
        } else {
            if (TheGatewayConfig == null) {
                String s = "Gateways were already created without GatewayHubHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheGatewayConfig.equals(gatewayConfig)) {
                String s = "Gateways already exist using logical gateway configuration named " + TheGatewayConfig + ", cannot also use " + gatewayConfig;
                throw new HydraRuntimeException(s);
            }
        }
    }

    public static synchronized void addWBCLGateway(String gatewayConfig) {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub == null) {
            throw new HydraRuntimeException("Gateway hub not created yet");
        }
        if (hub.getGateways().size() == 0) {
            GatewayHubHelper.log("Adding WBCL gateway to hub using gateway config: " + gatewayConfig);
            GatewayDescription gd = GatewayHelper.getGatewayDescription(gatewayConfig);
            String id = "wbcl";
            GatewayHubHelper.log("Configuring WBCL gateway with id: " + id);
            Gateway gateway = GatewayHubVersionHelper.addGateway(hub, id, gd);
            gd.configure(gateway, null, null, true);
            GatewayHubHelper.log("Configured WBCL gateway: " + GatewayHelper.gatewayToString(gateway));
            TheWBCLGatewayConfig = gatewayConfig;
            GatewayHubHelper.log("Added WBCL gateways to hub");
        } else {
            if (TheWBCLGatewayConfig == null) {
                String s = "WBCL gateway was already created without GatewayHubHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheWBCLGatewayConfig.equals(gatewayConfig)) {
                String s = "WBCL gateway already exists using logical gateway configuration named " + TheWBCLGatewayConfig + ", cannot also use " + gatewayConfig;
                throw new HydraRuntimeException(s);
            }
        }
    }

    public static synchronized void startGatewayHub() {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub == null) {
            String s = "Gateway hub has not been created yet";
            throw new HydraRuntimeException(s);
        }
        if (!GatewayHubVersionHelper.isRunning(hub)) {
            Set regions = CacheHelper.getCache().rootRegions();
            if (regions == null || regions.size() == 0) {
                String s = "Gateway hub cache has no regions yet";
                throw new HydraRuntimeException(s);
            }
            GatewayHubHelper.log("Starting gateway hub: " + GatewayHubHelper.gatewayHubToString(hub));
            GatewayHubVersionHelper.createDiskStores(hub);
            long startTimeMs = System.currentTimeMillis();
            while (true) {
                try {
                    hub.start();
                    GatewayHubHelper.log("Started gateway hub: " + hub);
                }
                catch (IOException e) {
                    if (PortHelper.retrySocketBind(e, startTimeMs)) continue;
                    String s = "Problem starting gateway hub" + GatewayHubHelper.gatewayHubToString(hub);
                    throw new HydraRuntimeException(s, e);
                }
                break;
            }
        }
    }

    public static synchronized GatewayHub getGatewayHub() {
        return CacheHelper.getCache().getGatewayHub();
    }

    public static synchronized void stopGatewayHub() {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub != null && GatewayHubVersionHelper.isRunning(hub)) {
            GatewayHubHelper.log("Stopping gateway hub: " + GatewayHubHelper.gatewayHubToString(hub));
            hub.stop();
            GatewayHubHelper.log("Stopped gateway hub: " + GatewayHubHelper.gatewayHubToString(hub));
        }
    }

    public static String gatewayHubToString(GatewayHub hub) {
        return GatewayHubDescription.gatewayHubToString(hub);
    }

    public static GatewayHubDescription getGatewayHubDescription(String gatewayHubConfig) {
        if (gatewayHubConfig == null) {
            throw new IllegalArgumentException("gatewayHubConfig cannot be null");
        }
        GatewayHubHelper.log("Looking up gateway hub config: " + gatewayHubConfig);
        GatewayHubDescription ghd = TestConfig.getInstance().getGatewayHubDescription(gatewayHubConfig);
        if (ghd == null) {
            String s = gatewayHubConfig + " not found in " + BasePrms.nameForKey(GatewayHubPrms.names);
            throw new HydraRuntimeException(s);
        }
        GatewayHubHelper.log("Looked up gateway hub config:\n" + ghd);
        return ghd;
    }

    public static Set getDistributedSystemNames(List endpoints) {
        HashSet<String> names = new HashSet<String>();
        for (Endpoint endpoint : endpoints) {
            names.add(endpoint.getDistributedSystemName());
        }
        return names;
    }

    public static synchronized List getEndpoints() {
        return new ArrayList(GatewayHubBlackboard.getInstance().getSharedMap().getMap().values());
    }

    public static synchronized List getRemoteEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        int myVmid = RemoteTestModule.getMyVmid();
        for (Endpoint endpoint : GatewayHubHelper.getEndpoints()) {
            if (endpoint.getVmid() == myVmid) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    protected static synchronized Endpoint getEndpoint(String id) {
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        Endpoint endpoint = (Endpoint)GatewayHubBlackboard.getInstance().getSharedMap().get(vmid);
        if (endpoint == null) {
            String name = RemoteTestModule.getMyClientName();
            String host = HostHelper.getLocalHost();
            String addr = HostHelper.getHostAddress();
            int port = PortHelper.getRandomPort();
            String ds = DistributedSystemHelper.getDistributedSystemName();
            endpoint = new Endpoint(id, name, vmid, host, addr, port, ds);
            GatewayHubHelper.log("Generated gateway hub endpoint: " + endpoint);
            GatewayHubBlackboard.getInstance().getSharedMap().put(vmid, endpoint);
        }
        return endpoint;
    }

    protected static String getId(GatewayHubDescription ghd) {
        String dsname;
        String id = dsname = DistributedSystemHelper.getDistributedSystemName();
        if (!ghd.getHAEnabled().booleanValue()) {
            id = id + "_" + RemoteTestModule.getMyVmid();
        }
        return id;
    }

    protected static int getPort(GatewayHubDescription ghd, String id) {
        GatewayHubHelper.log("Determining gateway hub port");
        int port = -1;
        if (ghd.getAcceptGatewayConnections().booleanValue()) {
            port = GatewayHubHelper.getEndpoint(id).getPort();
        }
        return port;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    public static class Endpoint
    implements Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;

        public Endpoint(String id, String name, int vmid, String host, String addr, int port, String ds) {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.id = id;
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.ds = ds;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        public String getHost() {
            return this.host;
        }

        public String getAddress() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getId().equals(this.getId()) && endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName().equals(this.getDistributedSystemName());
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String toString() {
            return this.id + " " + this.addr + "[" + this.port + "]" + "(vm_" + this.vmid + "_" + this.name + "_" + this.host + ")";
        }
    }
}

