/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.DistributedSystemHelper;
import hydra.GatewaySenderPrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class GatewaySenderDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer alertThreshold;
    private Boolean batchConflationEnabled;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private Integer dispatcherThreads;
    private List<String> gatewayEventFilters;
    private Set<String> gatewayTransportFilters;
    private Boolean manualStart;
    private Integer maximumQueueMemory;
    private Boolean parallel;
    private Boolean persistenceEnabled;
    private String remoteDistributedSystemsClass;
    private String remoteDistributedSystemsMethod;
    private Gateway.OrderPolicy orderPolicy;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    private void setAlertThreshold(Integer i) {
        this.alertThreshold = i;
    }

    private Boolean getBatchConflationEnabled() {
        return this.batchConflationEnabled;
    }

    private void setBatchConflationEnabled(Boolean bool) {
        this.batchConflationEnabled = bool;
    }

    private Integer getBatchSize() {
        return this.batchSize;
    }

    private void setBatchSize(Integer i) {
        this.batchSize = i;
    }

    private Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    private String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    private Integer getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    private void setDispatcherThreads(Integer i) {
        this.dispatcherThreads = i;
    }

    private List<String> getGatewayEventFilters() {
        return this.gatewayEventFilters;
    }

    private void setGatewayEventFilters(List<String> classnames) {
        this.gatewayEventFilters = classnames;
    }

    private Set<String> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    private void setGatewayTransportFilters(Set<String> classnames) {
        this.gatewayTransportFilters = classnames;
    }

    public Boolean getManualStart() {
        return this.manualStart;
    }

    private void setManualStart(Boolean bool) {
        this.manualStart = bool;
    }

    private Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    private void setMaximumQueueMemory(Integer i) {
        this.maximumQueueMemory = i;
    }

    public Boolean getParallel() {
        return this.parallel;
    }

    private void setParallel(Boolean bool) {
        this.parallel = bool;
    }

    private Boolean getPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    private void setPersistenceEnabled(Boolean bool) {
        this.persistenceEnabled = bool;
    }

    private String getRemoteDistributedSystemsAlgorithm() {
        return this.getRemoteDistributedSystemsClass() + "." + this.getRemoteDistributedSystemsMethod() + "()";
    }

    private String getRemoteDistributedSystemsClass() {
        return this.remoteDistributedSystemsClass;
    }

    private void setRemoteDistributedSystemsClass(String str) {
        this.remoteDistributedSystemsClass = str;
    }

    private String getRemoteDistributedSystemsMethod() {
        return this.remoteDistributedSystemsMethod;
    }

    private void setRemoteDistributedSystemsMethod(String str) {
        this.remoteDistributedSystemsMethod = str;
    }

    private Gateway.OrderPolicy getOrderPolicy() {
        return this.orderPolicy;
    }

    private void setOrderPolicy(Gateway.OrderPolicy p) {
        this.orderPolicy = p;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    private Integer getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    private void setSocketReadTimeout(Integer i) {
        this.socketReadTimeout = i;
    }

    protected void configure(GatewaySenderFactory f) {
        List<GatewayTransportFilter> gtfs;
        f.setAlertThreshold(this.getAlertThreshold().intValue());
        f.setBatchConflationEnabled(this.getBatchConflationEnabled().booleanValue());
        f.setBatchSize(this.getBatchSize().intValue());
        f.setBatchTimeInterval(this.getBatchTimeInterval().intValue());
        if (this.getDiskStoreDescription() != null) {
            f.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        f.setDiskSynchronous(this.getDiskSynchronous().booleanValue());
        f.setDispatcherThreads(this.getDispatcherThreads().intValue());
        List<GatewayEventFilter> gefs = this.getGatewayEventFilterInstances();
        if (gefs != null) {
            for (GatewayEventFilter gef : gefs) {
                f.addGatewayEventFilter(gef);
            }
        }
        if ((gtfs = this.getGatewayTransportFilterInstances()) != null) {
            for (GatewayTransportFilter gtf : gtfs) {
                f.addGatewayTransportFilter(gtf);
            }
        }
        f.setManualStart(this.getManualStart().booleanValue());
        f.setMaximumQueueMemory(this.getMaximumQueueMemory().intValue());
        f.setParallel(this.getParallel().booleanValue());
        f.setPersistenceEnabled(this.getPersistenceEnabled().booleanValue());
        if (this.getOrderPolicy() != null) {
            f.setOrderPolicy(this.getOrderPolicy());
        }
        f.setSocketBufferSize(this.getSocketBufferSize().intValue());
        f.setSocketReadTimeout(this.getSocketReadTimeout().intValue());
    }

    protected static synchronized String gatewaySenderToString(GatewaySender gs) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  id: " + gs.getId());
        buf.append("\n  alertThreshold: " + gs.getAlertThreshold());
        buf.append("\n  batchConflationEnabled: " + gs.isBatchConflationEnabled());
        buf.append("\n  batchSize: " + gs.getBatchSize());
        buf.append("\n  batchTimeInterval: " + gs.getBatchTimeInterval());
        buf.append("\n  diskStoreName: " + gs.getDiskStoreName());
        buf.append("\n  diskSynchronous: " + gs.isDiskSynchronous());
        buf.append("\n  dispatcherThreads: " + gs.getDispatcherThreads());
        buf.append("\n  gatewayEventFilters: " + GatewaySenderDescription.gatewayEventFiltersFor(gs.getGatewayEventFilters()));
        buf.append("\n  gatewayTransportFilters: " + GatewaySenderDescription.gatewayTransportFiltersFor(gs.getGatewayTransportFilters()));
        buf.append("\n  manualStart: " + gs.isManualStart());
        buf.append("\n  maximumQueueMemory: " + gs.getMaximumQueueMemory());
        buf.append("\n  orderPolicy: " + gs.getOrderPolicy());
        buf.append("\n  parallel: " + gs.isParallel());
        buf.append("\n  persistenceEnabled: " + gs.isPersistenceEnabled());
        int dsid = gs.getRemoteDSId();
        buf.append("\n  remoteDistributedSystem: " + dsid + " (" + DistributedSystemHelper.getDistributedSystemName(dsid) + ")");
        buf.append("\n  socketBufferSize: " + gs.getSocketBufferSize());
        buf.append("\n  socketReadTimeout: " + gs.getSocketReadTimeout());
        return buf.toString();
    }

    protected Set<String> getRemoteDistributedSystems() {
        MethExecutorResult result = MethExecutor.execute(this.getRemoteDistributedSystemsClass(), this.getRemoteDistributedSystemsMethod());
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        return (Set)result.getResult();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "alertThreshold", this.getAlertThreshold());
        map.put(header + "batchConflationEnabled", this.getBatchConflationEnabled());
        map.put(header + "batchSize", this.getBatchSize());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "dispatcherThreads", this.getDispatcherThreads());
        map.put(header + "gatewayEventFilters", this.getGatewayEventFilters());
        map.put(header + "gatewayTransportFilters", this.getGatewayTransportFilters());
        map.put(header + "manualStart", this.getManualStart());
        map.put(header + "maximumQueueMemory", this.getMaximumQueueMemory());
        map.put(header + "parallel", this.getParallel());
        map.put(header + "persistenceEnabled", this.getPersistenceEnabled());
        map.put(header + "remoteDistributedSystemsAlgorithm", this.getRemoteDistributedSystemsAlgorithm());
        map.put(header + "orderPolicy", this.getOrderPolicy());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "socketReadTimeout", this.getSocketReadTimeout());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(GatewaySenderPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewaySenderDescription gsd = GatewaySenderDescription.createGatewaySenderDescription(name, config, i);
            config.addGatewaySenderDescription(gsd);
        }
    }

    private static GatewaySenderDescription createGatewaySenderDescription(String name, TestConfig config, int index) {
        String str;
        Iterator i;
        ConfigHashtable tab = config.getParameters();
        GatewaySenderDescription gsd = new GatewaySenderDescription();
        gsd.setName(name);
        Long key = GatewaySenderPrms.alertThreshold;
        Integer i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 0;
        }
        gsd.setAlertThreshold(i2);
        key = GatewaySenderPrms.batchConflationEnabled;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setBatchConflationEnabled(bool);
        key = GatewaySenderPrms.batchSize;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 100;
        }
        gsd.setBatchSize(i2);
        key = GatewaySenderPrms.batchTimeInterval;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 1000;
        }
        gsd.setBatchTimeInterval(i2);
        key = GatewaySenderPrms.diskStoreName;
        String str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            gsd.setDiskStoreDescription(GatewaySenderDescription.getDiskStoreDescription(str2, key, config));
            gsd.setDiskStoreName("DiskStoreDescription." + str2);
        }
        if ((bool = tab.getBoolean(key = GatewaySenderPrms.diskSynchronous, tab.getWild(key, index, null))) == null) {
            bool = true;
        }
        gsd.setDiskSynchronous(bool);
        key = GatewaySenderPrms.dispatcherThreads;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 1;
        }
        gsd.setDispatcherThreads(i2);
        key = GatewaySenderPrms.gatewayEventFilters;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            i = strs.iterator();
            while (i.hasNext()) {
                str = tab.getString(key, i.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i.remove();
            }
            if (strs.size() > 0) {
                gsd.setGatewayEventFilters(new ArrayList<String>(strs));
            }
        }
        if ((strs = tab.vecAtWild(key = GatewaySenderPrms.gatewayTransportFilters, index, null)) != null) {
            i = strs.iterator();
            while (i.hasNext()) {
                str = tab.getString(key, i.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i.remove();
            }
            if (strs.size() > 0) {
                gsd.setGatewayTransportFilters(new LinkedHashSet<String>(strs));
            }
        }
        if ((bool = tab.getBoolean(key = GatewaySenderPrms.manualStart, tab.getWild(key, index, null))) == null) {
            bool = false;
        }
        gsd.setManualStart(bool);
        key = GatewaySenderPrms.maximumQueueMemory;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 100;
        }
        gsd.setMaximumQueueMemory(i2);
        key = GatewaySenderPrms.parallel;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setParallel(bool);
        key = GatewaySenderPrms.persistenceEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setPersistenceEnabled(bool);
        key = GatewaySenderPrms.remoteDistributedSystemsAlgorithm;
        strs = tab.vecAtWild(key, index, null);
        gsd.setRemoteDistributedSystemsClass(GatewaySenderDescription.getRemoteDistributedSystemsClass(strs, key));
        gsd.setRemoteDistributedSystemsMethod(GatewaySenderDescription.getRemoteDistributedSystemsMethod(strs, key));
        key = GatewaySenderPrms.orderPolicy;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        gsd.setOrderPolicy(GatewaySenderDescription.getOrderPolicy(str2, key, gsd.getDispatcherThreads()));
        key = GatewaySenderPrms.socketBufferSize;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = 524288;
        }
        gsd.setSocketBufferSize(i2);
        key = GatewaySenderPrms.socketReadTimeout;
        i2 = tab.getInteger(key, tab.getWild(key, index, null));
        if (i2 == null) {
            i2 = GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT;
        }
        gsd.setSocketReadTimeout(i2);
        if (gsd.getDiskStoreName() == null) {
            String s = BasePrms.nameForKey(GatewaySenderPrms.names) + " (" + gsd.getName() + ") requires a " + BasePrms.nameForKey(GatewaySenderPrms.diskStoreName);
            throw new HydraRuntimeException(s);
        }
        return gsd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static List gatewayEventFiltersFor(List<GatewayEventFilter> gefs) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (GatewayEventFilter gef : gefs) {
            classnames.add(gef.getClass().getName());
        }
        return classnames;
    }

    private List<GatewayEventFilter> getGatewayEventFilterInstances() {
        List<String> classnames = this.getGatewayEventFilters();
        if (classnames == null) {
            return null;
        }
        Long key = GatewaySenderPrms.gatewayEventFilters;
        ArrayList<GatewayEventFilter> instances = new ArrayList<GatewayEventFilter>();
        for (String classname : classnames) {
            try {
                GatewayEventFilter gef = (GatewayEventFilter)GatewaySenderDescription.getInstance(key, classname);
                instances.add(gef);
            }
            catch (ClassCastException e) {
                String s = BasePrms.nameForKey(key) + " does not implement GatewayEventFilter: " + classname;
                throw new HydraConfigException(s);
            }
        }
        return instances;
    }

    private static List gatewayTransportFiltersFor(List<GatewayTransportFilter> gtfs) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (GatewayTransportFilter gtf : gtfs) {
            classnames.add(gtf.getClass().getName());
        }
        return classnames;
    }

    private List<GatewayTransportFilter> getGatewayTransportFilterInstances() {
        Set<String> classnames = this.getGatewayTransportFilters();
        if (classnames == null) {
            return null;
        }
        Long key = GatewaySenderPrms.gatewayTransportFilters;
        ArrayList<GatewayTransportFilter> instances = new ArrayList<GatewayTransportFilter>();
        for (String classname : classnames) {
            try {
                GatewayTransportFilter gtf = (GatewayTransportFilter)GatewaySenderDescription.getInstance(key, classname);
                instances.add(gtf);
            }
            catch (ClassCastException e) {
                String s = BasePrms.nameForKey(key) + " does not implement GatewayTransportFilter: " + classname;
                throw new HydraConfigException(s);
            }
        }
        return instances;
    }

    private static Gateway.OrderPolicy getOrderPolicy(String str, Long key, int threads) {
        if (str == null) {
            return threads <= 1 ? null : GatewaySender.DEFAULT_ORDER_POLICY;
        }
        if (str.equalsIgnoreCase("key")) {
            return Gateway.OrderPolicy.KEY;
        }
        if (str.equalsIgnoreCase("partition")) {
            return Gateway.OrderPolicy.PARTITION;
        }
        if (str.equalsIgnoreCase("thread")) {
            return Gateway.OrderPolicy.THREAD;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static String getRemoteDistributedSystemsClass(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "hydra.GatewaySenderHelper";
        }
        if (strs.size() == 2) {
            return (String)strs.get(0);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static String getRemoteDistributedSystemsMethod(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "getRemoteDistributedSystems";
        }
        if (strs.size() == 2) {
            return (String)strs.get(1);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.alertThreshold = (Integer)in.readObject();
        this.batchConflationEnabled = (Boolean)in.readObject();
        this.batchSize = (Integer)in.readObject();
        this.batchTimeInterval = (Integer)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskStoreName = (String)in.readObject();
        this.diskSynchronous = (Boolean)in.readObject();
        this.dispatcherThreads = (Integer)in.readObject();
        this.gatewayEventFilters = (List)in.readObject();
        this.gatewayTransportFilters = (Set)in.readObject();
        this.manualStart = (Boolean)in.readObject();
        this.maximumQueueMemory = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.orderPolicy = GatewaySenderDescription.getOrderPolicy((String)in.readObject(), GatewaySenderPrms.orderPolicy, this.dispatcherThreads);
        this.parallel = (Boolean)in.readObject();
        this.persistenceEnabled = (Boolean)in.readObject();
        this.remoteDistributedSystemsClass = (String)in.readObject();
        this.remoteDistributedSystemsMethod = (String)in.readObject();
        this.socketBufferSize = (Integer)in.readObject();
        this.socketReadTimeout = (Integer)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.alertThreshold);
        out.writeObject(this.batchConflationEnabled);
        out.writeObject(this.batchSize);
        out.writeObject(this.batchTimeInterval);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskStoreName);
        out.writeObject(this.diskSynchronous);
        out.writeObject(this.dispatcherThreads);
        out.writeObject(this.gatewayEventFilters);
        out.writeObject(this.gatewayTransportFilters);
        out.writeObject(this.manualStart);
        out.writeObject(this.maximumQueueMemory);
        out.writeObject(this.name);
        if (this.orderPolicy == null) {
            out.writeObject(this.orderPolicy);
        } else {
            out.writeObject(this.orderPolicy.toString());
        }
        out.writeObject(this.parallel);
        out.writeObject(this.persistenceEnabled);
        out.writeObject(this.remoteDistributedSystemsClass);
        out.writeObject(this.remoteDistributedSystemsMethod);
        out.writeObject(this.socketBufferSize);
        out.writeObject(this.socketReadTimeout);
    }
}

