/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewaySenderDescription;
import hydra.GatewaySenderPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GatewaySenderHelper {
    private static Map<String, Set<String>> SerialGatewaySenderIds = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> ParallelGatewaySenderIds = new HashMap<String, Set<String>>();
    private static Integer DistributedSystemId;
    private static String DistributedSystemName;
    private static LogWriter log;

    public static synchronized Set<GatewaySender> createAndStartGatewaySenders(String gatewaySenderConfig) {
        Set<GatewaySender> senders = GatewaySenderHelper.createGatewaySenders(gatewaySenderConfig);
        GatewaySenderHelper.startGatewaySenders(gatewaySenderConfig);
        return senders;
    }

    public static synchronized Set<GatewaySender> createGatewaySenders(String gatewaySenderConfig) {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders(gatewaySenderConfig);
        if (senders == null || senders.size() == 0) {
            Cache cache = CacheHelper.getCache();
            if (cache == null) {
                String s = "Cache has not been created yet";
                throw new HydraRuntimeException(s);
            }
            GatewaySenderDescription gsd = GatewaySenderHelper.getGatewaySenderDescription(gatewaySenderConfig);
            DiskStoreHelper.createDiskStore(gsd.getDiskStoreDescription().getName());
            String localds = GatewaySenderHelper.getDistributedSystemName();
            senders = GatewaySenderHelper.createGatewaySenders(gsd, localds, cache);
        }
        return senders;
    }

    private static Set<GatewaySender> createGatewaySenders(GatewaySenderDescription gsd, String localds, Cache cache) {
        HashSet<GatewaySender> senders = new HashSet<GatewaySender>();
        Set<String> remoteDistributedSystems = gsd.getRemoteDistributedSystems();
        if (remoteDistributedSystems.size() > 0) {
            GatewaySenderFactory f = cache.createGatewaySenderFactory();
            log.info("Configuring gateway sender factory");
            gsd.configure(f);
            log.info("Configured gateway sender factory " + f);
            String starting = gsd.getManualStart() != false ? "" : "and starting ";
            String started = gsd.getManualStart() != false ? "" : "and started ";
            log.info("Creating " + starting + "gateway senders for " + gsd.getName() + " with remote distributed systems " + remoteDistributedSystems);
            for (String remoteds : remoteDistributedSystems) {
                String id = GatewaySenderHelper.getGatewaySenderId(gsd.getName(), localds, remoteds);
                log.info("Creating " + starting + "gateway sender: " + id);
                int remoteid = DistributedSystemHelper.getDistributedSystemId(remoteds);
                GatewaySender sender = f.create(id, remoteid);
                senders.add(sender);
                GatewaySenderHelper.saveGatewaySenderId(gsd.getName(), gsd.getParallel(), id);
                log.info("Created " + started + "gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
            }
        } else {
            log.info("Created no gateway senders since there are no remote distributed systems");
        }
        return senders;
    }

    public static synchronized void startGatewaySenders() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders == null || senders.size() == 0) {
            String s = "Gateway senders have not been created yet";
            throw new HydraRuntimeException(s);
        }
        for (GatewaySender sender : senders) {
            GatewaySenderHelper.startGatewaySender(sender);
        }
    }

    public static synchronized void startGatewaySenders(String gatewaySenderConfig) {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders(gatewaySenderConfig);
        if (senders == null || senders.size() == 0) {
            String s = "Gateway senders for " + gatewaySenderConfig + " have not been created yet";
            throw new HydraRuntimeException(s);
        }
        for (GatewaySender sender : senders) {
            GatewaySenderHelper.startGatewaySender(sender);
        }
    }

    private static void startGatewaySender(GatewaySender sender) {
        if (!sender.isRunning()) {
            log.info("Starting gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
            try {
                sender.start();
            }
            catch (Exception e) {
                String s = "Problem starting gateway sender" + GatewaySenderHelper.gatewaySenderToString(sender);
                throw new HydraRuntimeException(s, e);
            }
            log.info("Started gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
        }
    }

    public static Set<GatewaySender> getGatewaySenders() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            return null;
        }
        Set senders = cache.getGatewaySenders();
        return senders == null || senders.size() == 0 ? null : senders;
    }

    public static GatewaySender getGatewaySender(String senderID) {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders != null) {
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderID)) continue;
                return s;
            }
        }
        return null;
    }

    public static Set<GatewaySender> getGatewaySenders(String gatewaySenderConfig) {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders == null || senders.size() == 0) {
            return null;
        }
        HashSet<GatewaySender> matchingSenders = new HashSet<GatewaySender>();
        GatewaySenderDescription gsd = GatewaySenderHelper.getGatewaySenderDescription(gatewaySenderConfig);
        for (GatewaySender sender : senders) {
            if (!gsd.getName().equals(GatewaySenderHelper.getGatewaySenderConfigName(sender.getId()))) continue;
            matchingSenders.add(sender);
        }
        return matchingSenders.size() == 0 ? null : matchingSenders;
    }

    public static synchronized void stopGatewaySenders() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders != null) {
            for (GatewaySender sender : senders) {
                GatewaySenderHelper.stopGatewaySender(sender);
            }
        }
    }

    public static synchronized void stopGatewaySenders(String gatewaySenderConfig) {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders(gatewaySenderConfig);
        if (senders != null) {
            for (GatewaySender sender : senders) {
                GatewaySenderHelper.stopGatewaySender(sender);
            }
        }
    }

    private static void stopGatewaySender(GatewaySender sender) {
        if (sender.isRunning()) {
            log.info("Stopping gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
            sender.stop();
            log.info("Stopped gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
        }
    }

    public static String gatewaySenderToString(GatewaySender gs) {
        return GatewaySenderDescription.gatewaySenderToString(gs);
    }

    public static GatewaySenderDescription getGatewaySenderDescription(String gatewaySenderConfig) {
        if (gatewaySenderConfig == null) {
            throw new IllegalArgumentException("gatewaySenderConfig cannot be null");
        }
        log.info("Looking up gateway sender config: " + gatewaySenderConfig);
        GatewaySenderDescription gsd = TestConfig.getInstance().getGatewaySenderDescription(gatewaySenderConfig);
        if (gsd == null) {
            String s = gatewaySenderConfig + " not found in " + BasePrms.nameForKey(GatewaySenderPrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up gateway sender config:\n" + gsd);
        return gsd;
    }

    public static SortedSet<String> getRemoteDistributedSystems() {
        SortedSet<String> remoteds = GatewaySenderHelper.getDistributedSystems();
        String localds = GatewaySenderHelper.getDistributedSystemName();
        remoteds.remove(localds);
        return remoteds;
    }

    public static SortedSet<String> getRingDistributedSystems() {
        TreeSet<String> ringds = new TreeSet<String>();
        String localds = GatewaySenderHelper.getDistributedSystemName();
        SortedSet<String> allds = GatewaySenderHelper.getDistributedSystems();
        SortedSet<String> tailds = allds.tailSet(localds + "\u0000");
        if (tailds.size() == 0 && allds.size() > 1) {
            ringds.add(allds.first());
        } else if (tailds.size() > 0) {
            ringds.add(tailds.first());
        }
        return ringds;
    }

    public static SortedSet<String> getHubAndSpokeDistributedSystems() {
        SortedSet<String> allds;
        String localds = GatewaySenderHelper.getDistributedSystemName();
        if (localds.equals((allds = GatewaySenderHelper.getDistributedSystems()).first())) {
            allds.remove(localds);
            return allds;
        }
        TreeSet<String> hubds = new TreeSet<String>();
        hubds.add(allds.first());
        return hubds;
    }

    private static SortedSet<String> getDistributedSystems() {
        TreeSet<String> allds = new TreeSet<String>();
        for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
            String ds = gfd.getDistributedSystem();
            if (ds.equals("loner")) continue;
            allds.add(ds);
        }
        return allds;
    }

    public static synchronized int getDistributedSystemId() {
        if (DistributedSystemId == null) {
            DistributedSystemId = DistributedSystemHelper.getDistributedSystemId();
        }
        return DistributedSystemId;
    }

    public static synchronized String getDistributedSystemName() {
        if (DistributedSystemName == null) {
            DistributedSystemName = DistributedSystemHelper.getDistributedSystemName();
        }
        return DistributedSystemName;
    }

    public static synchronized void createGatewaySenderIds(String gatewaySenderConfig) {
        if (GatewaySenderHelper.getGatewaySenderIds(gatewaySenderConfig).size() == 0) {
            GatewaySenderDescription gsd = GatewaySenderHelper.getGatewaySenderDescription(gatewaySenderConfig);
            Set<String> remoteDistributedSystems = gsd.getRemoteDistributedSystems();
            if (remoteDistributedSystems.size() > 0) {
                String localds = GatewaySenderHelper.getDistributedSystemName();
                log.info("Creating gateway sender ids for " + gsd.getName() + " with remote distributed systems " + remoteDistributedSystems);
                for (String remoteds : remoteDistributedSystems) {
                    String id = GatewaySenderHelper.getGatewaySenderId(gsd.getName(), localds, remoteds);
                    GatewaySenderHelper.saveGatewaySenderId(gsd.getName(), gsd.getParallel(), id);
                }
                log.info("Created gateway sender ids for " + gsd.getName() + ": " + GatewaySenderHelper.getGatewaySenderIds(gatewaySenderConfig));
            } else {
                log.info("Created no gateway sender ids since there are no remote distributed systems");
            }
        }
    }

    public static Set<String> getGatewaySenderIds(String gatewaySenderConfig) {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(GatewaySenderHelper.getSerialGatewaySenderIds(gatewaySenderConfig));
        ids.addAll(GatewaySenderHelper.getParallelGatewaySenderIds(gatewaySenderConfig));
        return ids;
    }

    public static Set<String> getSerialGatewaySenderIds(String gatewaySenderConfig) {
        HashSet<String> ids = new HashSet<String>();
        Set<String> serIds = SerialGatewaySenderIds.get(gatewaySenderConfig);
        if (serIds != null) {
            ids.addAll(serIds);
        }
        return ids;
    }

    public static Set<String> getParallelGatewaySenderIds(String gatewaySenderConfig) {
        HashSet<String> ids = new HashSet<String>();
        Set<String> parIds = ParallelGatewaySenderIds.get(gatewaySenderConfig);
        if (parIds != null) {
            ids.addAll(parIds);
        }
        return ids;
    }

    protected static synchronized void saveGatewaySenderId(String gatewaySenderConfig, boolean parallel, String id) {
        Map<String, Set<String>> allids = parallel ? ParallelGatewaySenderIds : SerialGatewaySenderIds;
        Set<String> ids = allids.get(gatewaySenderConfig);
        if (ids == null) {
            ids = new HashSet<String>();
            allids.put(gatewaySenderConfig, ids);
        }
        if (!ids.contains(id)) {
            ids.add(id);
        }
    }

    private static String getGatewaySenderId(String gatewaySenderConfig, String ds1, String ds2) {
        return gatewaySenderConfig + "_" + ds1 + "_to_" + ds2;
    }

    public static String getGatewaySenderConfigName(String id) {
        return id.substring(0, id.indexOf(95));
    }

    static {
        log = Log.getLogWriter();
    }
}

