/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.DistributedSystemBlackboard;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.GemFireLocatorAgentRecord;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Java;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GemFireLocatorAgentMgr {
    private static HashMap Agents = new HashMap();

    public static void startLocatorAgents() {
        if (TestConfig.tab().booleanAt(Prms.startLocatorAgentsBeforeTest)) {
            HashSet<String> distributedSystems = new HashSet<String>();
            Map<String, GemFireDescription> gfds = TestConfig.getInstance().getGemFireDescriptions();
            String vmArgs = null;
            String classpath = null;
            for (GemFireDescription gfd : gfds.values()) {
                if (gfd.getUseLocator().booleanValue()) {
                    distributedSystems.add(gfd.getDistributedSystem());
                }
                vmArgs = gfd.getExtraLocatorVMArgs();
                classpath = gfd.getLocatorClassPath();
            }
            if (distributedSystems.size() != 0) {
                GemFireLocatorAgentMgr.log().info("Starting " + distributedSystems.size() + " locator agents");
                for (String ds : distributedSystems) {
                    GemFireLocatorAgentMgr.startLocatorAgent(ds, vmArgs, classpath);
                }
            }
        }
    }

    public static void startLocatorAgent(String ds, String vmArgs, String classpath) {
        GemFireLocatorAgentMgr.log().info("Starting locator agent for " + ds + "...");
        Java.javaGemFireLocatorAgent(ds, vmArgs, classpath);
        GemFireLocatorAgentMgr.waitForLocatorAgentToRegister(ds);
        GemFireLocatorAgentRecord lar = (GemFireLocatorAgentRecord)Agents.get(ds);
        if (lar.getProcessId() == -1) {
            throw new HydraRuntimeException("Unable to start locator agent for " + ds);
        }
        GemFireLocatorAgentMgr.log().info("Started locator agent " + lar);
        String host = lar.getHostName();
        String addr = lar.getHostAddress();
        int port = lar.getPort();
        String data = addr + "[" + port + "]" + "," + ds + "," + host + "," + addr + "," + port;
        FileUtil.appendToFile("discovery.dat", data + "\n");
    }

    public static void registerGemFireLocatorAgent(GemFireLocatorAgentRecord lar) {
        DistributedSystemHelper.Endpoint endpoint = new DistributedSystemHelper.Endpoint(lar);
        GemFireLocatorAgentMgr.log().info("Generated locator endpoint: " + endpoint);
        DistributedSystemBlackboard.getInstance().getSharedMap().put(new Integer(lar.getProcessId()), endpoint);
        GemFireLocatorAgentMgr.log().info(lar + " registered.");
        Agents.put(lar.getDistributedSystem(), lar);
    }

    private static void waitForLocatorAgentToRegister(String ds) {
        int maxWaitSec = 300;
        GemFireLocatorAgentMgr.log().info("Waiting " + maxWaitSec + " seconds for locator agent " + ds + " to register with master.");
        long timeout = System.currentTimeMillis() + (long)(maxWaitSec * 1000);
        int count = 0;
        while (System.currentTimeMillis() < timeout) {
            ++count;
            MasterController.sleepForMs(500);
            if (Agents.get(ds) != null) {
                GemFireLocatorAgentMgr.log().info("Locator agent " + ds + " has registered.");
                return;
            }
            if (count % 15 != 0) continue;
            GemFireLocatorAgentMgr.log().info("...waiting for locator agent " + ds + "...");
        }
        throw new HydraTimeoutException("Failed to register locator agent " + ds + " within " + maxWaitSec + " seconds.");
    }

    public static void stopLocatorAgentsAfterTest() {
        if (TestConfig.tab().booleanAt(Prms.stopLocatorAgentsAfterTest)) {
            if (Agents.size() != 0) {
                GemFireLocatorAgentMgr.log().info("Stopping " + Agents.size() + " locator agents");
                for (String ds : Agents.keySet()) {
                    GemFireLocatorAgentMgr.stopLocatorAgent(ds);
                }
            }
        } else {
            GemFireLocatorAgentMgr.log().info("Leaving the locator agents running");
        }
    }

    public static void stopLocatorAgent(String ds) {
        GemFireLocatorAgentMgr.log().info("Shutting down locator agent for " + ds);
        GemFireLocatorAgentRecord lar = (GemFireLocatorAgentRecord)Agents.get(ds);
        if (lar == null) {
            GemFireLocatorAgentMgr.waitForLocatorAgentToRegister(ds);
        }
        try {
            lar.getGemFireLocatorAgent().shutDownGemFireLocatorAgent();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Unable to reach locator agent " + lar, e);
        }
    }

    public static void printProcessStacks() {
        for (GemFireLocatorAgentRecord lar : Agents.values()) {
            ProcessMgr.printProcessStacks(lar.getHostName(), lar.getProcessId());
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

