/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HadoopPrms;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraVector;
import hydra.Nuker;
import hydra.PortHelper;
import hydra.TestConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class HadoopDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private Boolean addHDFSConfigurationToClassPath;
    private String baseHDFSDirName;
    private List<String> dataNodeHosts;
    private List<String> dataNodeDataDrives;
    private List<String> dataNodeLogDrives;
    private List<DataNodeDescription> dnds = new ArrayList<DataNodeDescription>();
    private String extraClassPath;
    private String hadoopDist;
    private List<String> nameNodeHosts;
    private List<String> nameNodeDataDrives;
    private List<String> nameNodeLogDrives;
    private List<NameNodeDescription> nnds = new ArrayList<NameNodeDescription>();
    private String nameNodeURL;
    private List<String> nodeManagerDataDrives;
    private List<String> nodeManagerLogDrives;
    private List<NodeManagerDescription> nmds = new ArrayList<NodeManagerDescription>();
    private Integer replication;
    private String resourceManagerHost;
    private String resourceManagerDataDrives;
    private String resourceManagerLogDrive;
    private ResourceManagerDescription rmd;
    private String resourceManagerURL;
    private String resourceTrackerAddress;
    private String schedulerAddress;
    private String securityAuthentication;
    private boolean useExistingCluster;

    public String getName() {
        return this.name;
    }

    protected void setName(String str) {
        this.name = str;
    }

    public Boolean addHDFSConfigurationToClassPath() {
        return this.addHDFSConfigurationToClassPath;
    }

    protected void setAddHDFSConfigurationToClassPath(Boolean b) {
        this.addHDFSConfigurationToClassPath = b;
    }

    public String getBaseHDFSDirName() {
        return this.baseHDFSDirName;
    }

    protected void setBaseHDFSDirName(String str) {
        this.baseHDFSDirName = str;
    }

    public List<String> getDataNodeHosts() {
        return this.dataNodeHosts;
    }

    protected void setDataNodeHosts(List<String> s) {
        this.dataNodeHosts = s;
    }

    public List<String> getDataNodeDataDrives() {
        return this.dataNodeDataDrives;
    }

    protected void setDataNodeDataDrives(List<String> s) {
        this.dataNodeDataDrives = s;
    }

    public List<String> getDataNodeLogDrives() {
        return this.dataNodeLogDrives;
    }

    protected void setDataNodeLogDrives(List<String> s) {
        this.dataNodeLogDrives = s;
    }

    public List<DataNodeDescription> getDataNodeDescriptions() {
        return this.dnds;
    }

    protected void addDataNodeDescription(DataNodeDescription dnd) {
        this.dnds.add(dnd);
    }

    public String getHadoopDist() {
        return this.hadoopDist;
    }

    protected void setHadoopDist(String str) {
        this.hadoopDist = str;
    }

    public List<String> getNameNodeHosts() {
        return this.nameNodeHosts;
    }

    protected void setNameNodeHosts(List<String> s) {
        this.nameNodeHosts = s;
    }

    public List<String> getNameNodeDataDrives() {
        return this.nameNodeDataDrives;
    }

    protected void setNameNodeDataDrives(List<String> s) {
        this.nameNodeDataDrives = s;
    }

    public List<String> getNameNodeLogDrives() {
        return this.nameNodeLogDrives;
    }

    protected void setNameNodeLogDrives(List<String> s) {
        this.nameNodeLogDrives = s;
    }

    public List<NameNodeDescription> getNameNodeDescriptions() {
        return this.nnds;
    }

    protected void addNameNodeDescription(NameNodeDescription nnd) {
        this.nnds.add(nnd);
    }

    public String getNameNodeURL() {
        return this.nameNodeURL;
    }

    protected void setNameNodeURL(String str) {
        this.nameNodeURL = str;
    }

    public List<String> getNodeManagerDataDrives() {
        return this.nodeManagerDataDrives;
    }

    protected void setNodeManagerDataDrives(List<String> s) {
        this.nodeManagerDataDrives = s;
    }

    public List<String> getNodeManagerLogDrives() {
        return this.nodeManagerLogDrives;
    }

    protected void setNodeManagerLogDrives(List<String> s) {
        this.nodeManagerLogDrives = s;
    }

    public List<NodeManagerDescription> getNodeManagerDescriptions() {
        return this.nmds;
    }

    protected void addNodeManagerDescription(NodeManagerDescription nmd) {
        this.nmds.add(nmd);
    }

    public Integer getReplication() {
        return this.replication;
    }

    protected void setReplication(Integer i) {
        this.replication = i;
    }

    public String getResourceManagerHost() {
        return this.resourceManagerHost;
    }

    protected void setResourceManagerHost(String s) {
        this.resourceManagerHost = s;
    }

    public String getResourceManagerDataDrives() {
        return this.resourceManagerDataDrives;
    }

    protected void setResourceManagerDataDrives(String s) {
        this.resourceManagerDataDrives = s;
    }

    public String getResourceManagerLogDrive() {
        return this.resourceManagerLogDrive;
    }

    protected void setResourceManagerLogDrive(String s) {
        this.resourceManagerLogDrive = s;
    }

    public ResourceManagerDescription getResourceManagerDescription() {
        return this.rmd;
    }

    protected void setResourceManagerDescription(ResourceManagerDescription d) {
        this.rmd = d;
    }

    public String getResourceManagerURL() {
        return this.resourceManagerURL;
    }

    protected void setResourceManagerURL(String str) {
        this.resourceManagerURL = str;
    }

    public String getResourceTrackerAddress() {
        return this.resourceTrackerAddress;
    }

    protected void setResourceTrackerAddress(String str) {
        this.resourceTrackerAddress = str;
    }

    public String getSchedulerAddress() {
        return this.schedulerAddress;
    }

    protected void setSchedulerAddress(String str) {
        this.schedulerAddress = str;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String str) {
        this.securityAuthentication = str;
    }

    public boolean isSecure() {
        return this.getSecurityAuthentication().equals("kerberos") || this.getSecurityAuthentication().equals("kerberosKinit");
    }

    public boolean useExistingCluster() {
        return this.useExistingCluster;
    }

    public void setUseExistingCluster(boolean b) {
        this.useExistingCluster = b;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "addHDFSConfigurationToClassPath", this.addHDFSConfigurationToClassPath());
        map.put(header + "baseHDFSDirName", this.getBaseHDFSDirName());
        map.put(header + "dataNodeHosts", this.getDataNodeHosts());
        map.put(header + "dataNodeDataDrives", this.getDataNodeDataDrives());
        map.put(header + "dataNodeLogDrives", this.getDataNodeLogDrives());
        for (DataNodeDescription dnd : this.getDataNodeDescriptions()) {
            map.putAll(dnd.toSortedMap());
        }
        map.put(header + "hadoopDist", this.getHadoopDist());
        map.put(header + "nameNodeHosts", this.getNameNodeHosts());
        map.put(header + "nameNodeDataDrives", this.getNameNodeDataDrives());
        map.put(header + "nameNodeLogDrives", this.getNameNodeLogDrives());
        for (NameNodeDescription nnd : this.getNameNodeDescriptions()) {
            map.putAll(nnd.toSortedMap());
        }
        map.put(header + "nameNodeURL", this.getNameNodeURL());
        map.put(header + "nodeManagerDataDrives", this.getNodeManagerDataDrives());
        map.put(header + "nodeManagerLogDrives", this.getNodeManagerLogDrives());
        for (NodeManagerDescription nmd : this.getNodeManagerDescriptions()) {
            map.putAll(nmd.toSortedMap());
        }
        map.put(header + "replication", this.getReplication());
        map.put(header + "resourceManagerHost", this.getResourceManagerHost());
        map.put(header + "resourceManagerDataDrives", this.getResourceManagerDataDrives());
        map.put(header + "resourceManagerLogDrive", this.getResourceManagerLogDrive());
        if (this.getResourceManagerDescription() != null) {
            map.putAll(this.getResourceManagerDescription().toSortedMap());
        }
        map.put(header + "resourceManagerURL", this.getResourceManagerURL());
        map.put(header + "resourceTrackerAddress", this.getResourceTrackerAddress());
        map.put(header + "schedulerAddress", this.getSchedulerAddress());
        map.put(header + "securityAuthentication", this.getSecurityAuthentication());
        map.put(header + "useExistingCluster", this.useExistingCluster());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HostDescription mhd = config.getMasterDescription().getVmDescription().getHostDescription();
        HydraVector names = tab.vecAt(HadoopPrms.names, new HydraVector());
        String defaultHadoopDist = System.getProperty("HADOOP_DIST", "/export/gcm/where/java/hadoop/hdp-2.2.0.2.0.6.0-102");
        for (int i = 0; i < names.size(); ++i) {
            Integer val;
            String host;
            String s;
            ArrayList<String> drives;
            String host2;
            String str;
            int n;
            String s2;
            HadoopDescription hdd = new HadoopDescription();
            String name = (String)names.elementAt(i);
            hdd.setName(name);
            Long key = HadoopPrms.addHDFSConfigurationToClassPath;
            Boolean b = tab.getBoolean(key, tab.getWild(key, i, null));
            if (b == null) {
                b = Boolean.FALSE;
            }
            hdd.setAddHDFSConfigurationToClassPath(b);
            key = HadoopPrms.baseHDFSDirName;
            String str2 = tab.stringAtWild(key, i, "scratch");
            if (str2.length() == 0) {
                s2 = BasePrms.nameForKey(key) + " is empty";
                throw new HydraConfigException(s2);
            }
            str2 = EnvHelper.expandEnvVars(str2, mhd);
            hdd.setBaseHDFSDirName(str2);
            key = HadoopPrms.dataNodeHosts;
            HydraVector strs = tab.vecAtWild(key, i, null);
            if (strs == null) {
                strs = new HydraVector(mhd.getHostName());
            }
            ArrayList<String> hosts = new ArrayList<String>();
            for (n = 0; n < strs.size(); ++n) {
                str = (String)strs.get(n);
                host2 = EnvHelper.convertHostName(str);
                if (hosts.contains(host2)) continue;
                hosts.add(host2);
                HadoopDescription.generateHostDescription(config, host2, mhd);
            }
            hdd.setDataNodeHosts(hosts);
            key = HadoopPrms.dataNodeDataDrives;
            strs = tab.vecAtWild(key, i, null);
            if (strs != null) {
                drives = new ArrayList<String>();
                drives.addAll(strs);
                hdd.setDataNodeDataDrives(HadoopDescription.adjustSize(drives, hdd.getDataNodeHosts().size()));
            }
            if ((strs = tab.vecAtWild(key = HadoopPrms.dataNodeLogDrives, i, null)) != null) {
                drives = new ArrayList();
                drives.addAll(strs);
                for (String drive : drives) {
                    if (!drive.contains(":")) continue;
                    s = BasePrms.nameForKey(key) + " contains an illegal multi-drive entry: " + drive;
                    throw new HydraConfigException(s);
                }
                hdd.setDataNodeLogDrives(HadoopDescription.adjustSize(drives, hdd.getDataNodeHosts().size()));
            }
            key = HadoopPrms.hadoopDist;
            str2 = tab.stringAtWild(key, i, defaultHadoopDist);
            str2 = EnvHelper.expandEnvVars(str2, mhd);
            hdd.setHadoopDist(str2);
            key = HadoopPrms.nameNodeHosts;
            strs = tab.vecAtWild(key, i, null);
            if (strs == null) {
                strs = new HydraVector(mhd.getHostName());
            }
            if (strs.size() > 1) {
                s2 = BasePrms.nameForKey(key) + " does not support multiple NameNodes";
                throw new UnsupportedOperationException(s2);
            }
            hosts = new ArrayList();
            for (n = 0; n < strs.size(); ++n) {
                str = (String)strs.get(n);
                host2 = EnvHelper.convertHostName(str);
                if (hosts.contains(host2)) continue;
                hosts.add(host2);
                HadoopDescription.generateHostDescription(config, host2, mhd);
            }
            hdd.setNameNodeHosts(hosts);
            key = HadoopPrms.nameNodeDataDrives;
            strs = tab.vecAtWild(key, i, null);
            if (strs != null) {
                drives = new ArrayList();
                drives.addAll(strs);
                hdd.setNameNodeDataDrives(HadoopDescription.adjustSize(drives, hdd.getNameNodeHosts().size()));
            }
            if ((strs = tab.vecAtWild(key = HadoopPrms.nameNodeLogDrives, i, null)) != null) {
                drives = new ArrayList();
                drives.addAll(strs);
                for (String drive : drives) {
                    if (!drive.contains(":")) continue;
                    s = BasePrms.nameForKey(key) + " contains an illegal multi-drive entry: " + drive;
                    throw new HydraConfigException(s);
                }
                hdd.setNameNodeLogDrives(HadoopDescription.adjustSize(drives, hdd.getNameNodeHosts().size()));
            }
            if ((str2 = tab.stringAtWild(key = HadoopPrms.nameNodeURL, i, null)) == null) {
                host = hdd.getNameNodeHosts().iterator().next();
                str2 = "hdfs://" + HostHelper.getCanonicalHostName(host) + ":" + PortHelper.getRandomPort();
                hdd.setUseExistingCluster(false);
            } else {
                hdd.setUseExistingCluster(true);
            }
            hdd.setNameNodeURL(str2);
            key = HadoopPrms.nodeManagerDataDrives;
            strs = tab.vecAtWild(key, i, null);
            if (strs != null) {
                drives = new ArrayList();
                drives.addAll(strs);
                hdd.setNodeManagerDataDrives(HadoopDescription.adjustSize(drives, hdd.getDataNodeHosts().size()));
            }
            if ((strs = tab.vecAtWild(key = HadoopPrms.nodeManagerLogDrives, i, null)) != null) {
                drives = new ArrayList();
                drives.addAll(strs);
                for (String drive : drives) {
                    if (!drive.contains(":")) continue;
                    s = BasePrms.nameForKey(key) + " contains an illegal multi-drive entry: " + drive;
                    throw new HydraConfigException(s);
                }
                hdd.setNodeManagerLogDrives(HadoopDescription.adjustSize(drives, hdd.getDataNodeHosts().size()));
            }
            if ((val = tab.getInteger(key = HadoopPrms.replication, tab.getWild(key, i, null))) == null) {
                val = 1;
            }
            hdd.setReplication(val);
            key = HadoopPrms.resourceManagerHost;
            str2 = tab.stringAtWild(key, i, null);
            if (str2 == null) {
                str2 = mhd.getHostName();
            }
            host = EnvHelper.convertHostName(str2);
            HadoopDescription.generateHostDescription(config, host, mhd);
            hdd.setResourceManagerHost(host);
            key = HadoopPrms.resourceManagerDataDrives;
            str2 = tab.stringAtWild(key, i, null);
            if (str2 != null) {
                hdd.setResourceManagerDataDrives(str2);
            }
            if ((str2 = tab.stringAtWild(key = HadoopPrms.resourceManagerLogDrive, i, null)) != null) {
                if (str2.contains(":")) {
                    s2 = BasePrms.nameForKey(key) + " contains an illegal multi-drive entry: " + str2;
                    throw new HydraConfigException(s2);
                }
                hdd.setResourceManagerLogDrive(str2);
            }
            if ((str2 = tab.stringAtWild(key = HadoopPrms.resourceManagerURL, i, null)) != null) {
                s2 = "Connecting to an existing resource manager is not supported";
                throw new UnsupportedOperationException(s2);
            }
            ResourceManagerDescription rmd = hdd.getResourceManagerDescription();
            String host3 = hdd.getResourceManagerHost();
            str2 = "hdfs://" + HostHelper.getCanonicalHostName(host3) + ":" + PortHelper.getRandomPort();
            hdd.setResourceManagerURL(str2);
            key = HadoopPrms.resourceTrackerAddress;
            str2 = tab.stringAtWild(key, i, null);
            if (str2 != null) {
                s2 = "Connecting to an existing resource tracker is not supported";
                throw new UnsupportedOperationException(s2);
            }
            str2 = hdd.getResourceManagerHost() + ":" + PortHelper.getRandomPort();
            hdd.setResourceTrackerAddress(str2);
            key = HadoopPrms.schedulerAddress;
            str2 = tab.stringAtWild(key, i, null);
            if (str2 != null) {
                s2 = "Connecting to an existing scheduler is not supported";
                throw new UnsupportedOperationException(s2);
            }
            str2 = hdd.getResourceManagerHost() + ":" + PortHelper.getRandomPort();
            hdd.setSchedulerAddress(str2);
            key = HadoopPrms.securityAuthentication;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            hdd.setSecurityAuthentication(HadoopDescription.getSecurityAuthentication(str2, key));
            config.addHadoopDescription(hdd);
        }
        HashSet<String> clusterHosts = new HashSet<String>();
        for (HadoopDescription hdd : config.getHadoopDescriptions().values()) {
            clusterHosts.addAll(hdd.getNameNodeHosts());
            clusterHosts.addAll(hdd.getDataNodeHosts());
            if (hdd.getResourceManagerHost() == null) continue;
            clusterHosts.add(hdd.getResourceManagerHost());
        }
        for (String host : clusterHosts) {
            HadoopDescription.generateHostDescription(config, host, mhd);
        }
        for (HadoopDescription hdd : config.getHadoopDescriptions().values()) {
            int i;
            for (i = 0; i < hdd.getNameNodeHosts().size(); ++i) {
                NameNodeDescription nnd = new NameNodeDescription();
                nnd.configure(config, hdd, i);
                hdd.addNameNodeDescription(nnd);
            }
            for (i = 0; i < hdd.getDataNodeHosts().size(); ++i) {
                DataNodeDescription dnd = new DataNodeDescription();
                dnd.configure(config, hdd, i);
                hdd.addDataNodeDescription(dnd);
            }
            for (i = 0; i < hdd.getDataNodeHosts().size(); ++i) {
                NodeManagerDescription nmd = new NodeManagerDescription();
                nmd.configure(config, hdd, i);
                hdd.addNodeManagerDescription(nmd);
            }
            ResourceManagerDescription rmd = new ResourceManagerDescription();
            rmd.configure(config, hdd);
            hdd.setResourceManagerDescription(rmd);
        }
    }

    protected static String getExtraClassPath(TestConfig config) {
        String cp = "";
        for (HadoopDescription hdd : config.getHadoopDescriptions().values()) {
            String s;
            if (!hdd.addHDFSConfigurationToClassPath().booleanValue()) continue;
            if (hdd.useExistingCluster()) {
                s = "HDFS configuration is unavailable for existing cluster: " + hdd.getName() + " at " + hdd.getNameNodeURL();
                throw new UnsupportedOperationException(s);
            }
            if (hdd.getNameNodeDescriptions().size() == 0) {
                s = "No NameNode configuration found for Hadoop cluster: " + hdd.getName();
                throw new UnsupportedOperationException(s);
            }
            NameNodeDescription nnd = hdd.getNameNodeDescriptions().get(0);
            if (cp.length() > 0) {
                cp = cp + nnd.getHostDescription().getPathSep();
            }
            cp = cp + nnd.getConfDir() + nnd.getHostDescription().getFileSep();
        }
        return cp.length() > 0 ? cp : null;
    }

    private static String getSecurityAuthentication(String str, Long key) {
        if (str == null) {
            return "simple";
        }
        if (str.equalsIgnoreCase("kerberos")) {
            return "kerberos";
        }
        if (str.equalsIgnoreCase("kerberosKinit") || str.equalsIgnoreCase("kerberos_kinit")) {
            return "kerberosKinit";
        }
        if (str.equalsIgnoreCase("simple")) {
            return "simple";
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static List<String> adjustSize(List<String> list, int size) {
        if (list.size() > size) {
            list = list.subList(0, size);
        } else if (list.size() < size) {
            String last = list.get(list.size() - 1);
            while (list.size() < size) {
                list.add(last);
            }
        }
        return list;
    }

    private static void generateHostDescription(TestConfig config, String host, HostDescription mhd) {
        String logicalHost = "hydra_hadoop_" + host;
        HostDescription hd = config.getHadoopHostDescription(logicalHost);
        if (hd == null) {
            hd = mhd.copy();
            hd.setName(logicalHost);
            hd.setHostName(host);
            hd.setCanonicalHostName(HostHelper.getCanonicalHostName(host));
            config.addHadoopHostDescription(hd);
        }
    }

    public static abstract class NodeDescription
    implements Serializable {
        private String name;
        private String clusterName;
        private String confDir;
        private List<String> dataDirs;
        private HostDescription hd;
        private String hostName;
        private String logDir;
        private HadoopPrms.NodeType nodeType;
        private String pidDir;

        public String getName() {
            return this.name;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getConfDir() {
            return this.confDir;
        }

        public List<String> getDataDirs() {
            return this.dataDirs;
        }

        public String getDataDirsAsString() {
            StringBuffer sb = new StringBuffer();
            for (String dir : this.dataDirs) {
                sb.append(dir).append(",");
            }
            String s = sb.toString();
            return s.substring(0, s.length() - 1);
        }

        public HostDescription getHostDescription() {
            return this.hd;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getLogDir() {
            return this.logDir;
        }

        public HadoopPrms.NodeType getNodeType() {
            return this.nodeType;
        }

        public String getPIDDir() {
            return this.pidDir;
        }

        public SortedMap toSortedMap() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            String header = this.getClass().getName() + "." + this.getName() + ".";
            map.put(header + "clusterName", this.getClusterName());
            map.put(header + "confDir", this.getConfDir());
            map.put(header + "dataDirs", this.getDataDirs());
            map.put(header + "hostName", this.getHostName());
            map.put(header + "hostDescription", this.getHostDescription().getName());
            map.put(header + "logDir", this.getLogDir());
            map.put(header + "nodeType", (Object)this.getNodeType());
            map.put(header + "pidDir", this.getPIDDir());
            return map;
        }

        public String toString() {
            return this.name;
        }

        public void configure(HadoopPrms.NodeType type, TestConfig config, HadoopDescription hdd, String host, String dataDrives, String logDrive) {
            String locality;
            this.clusterName = hdd.getName();
            this.nodeType = type;
            this.name = this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + host;
            this.hostName = host;
            this.hd = config.getHadoopHostDescriptionForPhysicalHost(host);
            this.confDir = this.hd.getUserDir() + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + "_conf";
            this.pidDir = this.hd.getUserDir() + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + "_pids";
            if (logDrive == null) {
                locality = HostHelper.isLocalHost(this.hostName) ? "" : "_nonlocal";
                this.logDir = this.hd.getUserDir() + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + locality + "_logs";
            } else {
                this.logDir = "/export/" + this.hostName + logDrive + "/users/" + System.getProperty("user.name") + "/" + hdd.getBaseHDFSDirName() + "/" + FileUtil.filenameFor(this.hd.getUserDir()) + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + logDrive + "_logs";
            }
            this.dataDirs = new ArrayList<String>();
            if (dataDrives == null) {
                locality = HostHelper.isLocalHost(this.hostName) ? "" : "_nonlocal";
                String dataDir = this.hd.getUserDir() + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + locality + "_data";
                this.dataDirs.add(dataDir);
            } else {
                for (String drive : dataDrives.split(":")) {
                    String dataDir = "/export/" + this.hostName + drive + "/users/" + System.getProperty("user.name") + "/" + hdd.getBaseHDFSDirName() + "/" + FileUtil.filenameFor(this.hd.getUserDir()) + "/" + this.clusterName + "_" + (Object)((Object)this.nodeType) + "_" + this.hostName + drive + "_data";
                    this.dataDirs.add(dataDir);
                }
            }
            this.recordDir(this.confDir, true);
            this.recordDir(this.pidDir, true);
            this.recordDir(this.logDir, true);
            boolean moveHadoopData = Boolean.getBoolean("moveHadoopData");
            for (String dataDir : this.dataDirs) {
                this.recordDir(dataDir, moveHadoopData);
            }
        }

        private String getFileSystem(String dir) {
            String fs = dir;
            if (fs.startsWith("/export/")) {
                fs = fs.substring(8, dir.length() - 1);
            }
            return fs.substring(0, fs.indexOf("/"));
        }

        private void recordDir(String dir, boolean moveAfterTest) {
            File f = new File(dir);
            if (f.exists()) {
                String s = "Already created directory " + dir;
                throw new HydraInternalException(s);
            }
            FileUtil.mkdir(f);
            Nuker.getInstance().recordHDFSDir(this.hd, this.nodeType, dir, moveAfterTest);
        }
    }

    public static class ResourceManagerDescription
    extends NodeDescription
    implements Serializable {
        public void configure(TestConfig config, HadoopDescription hdd) {
            String host = hdd.getResourceManagerHost();
            String dataDrives = hdd.getResourceManagerDataDrives();
            String logDrive = hdd.getResourceManagerLogDrive();
            this.configure(HadoopPrms.NodeType.ResourceManager, config, hdd, host, dataDrives, logDrive);
        }
    }

    public static class NodeManagerDescription
    extends NodeDescription
    implements Serializable {
        public void configure(TestConfig config, HadoopDescription hdd, int i) {
            String host = hdd.getDataNodeHosts().get(i);
            String dataDrives = hdd.getNodeManagerDataDrives() == null ? null : hdd.getNodeManagerDataDrives().get(i);
            String logDrive = hdd.getNodeManagerLogDrives() == null ? null : hdd.getNodeManagerLogDrives().get(i);
            this.configure(HadoopPrms.NodeType.NodeManager, config, hdd, host, dataDrives, logDrive);
        }
    }

    public static class NameNodeDescription
    extends NodeDescription
    implements Serializable {
        public void configure(TestConfig config, HadoopDescription hdd, int i) {
            String host = hdd.getNameNodeHosts().get(i);
            String dataDrives = hdd.getNameNodeDataDrives() == null ? null : hdd.getNameNodeDataDrives().get(i);
            String logDrive = hdd.getNameNodeLogDrives() == null ? null : hdd.getNameNodeLogDrives().get(i);
            this.configure(HadoopPrms.NodeType.NameNode, config, hdd, host, dataDrives, logDrive);
        }
    }

    public static class DataNodeDescription
    extends NodeDescription
    implements Serializable {
        public void configure(TestConfig config, HadoopDescription hdd, int i) {
            String host = hdd.getDataNodeHosts().get(i);
            String dataDrives = hdd.getDataNodeDataDrives() == null ? null : hdd.getDataNodeDataDrives().get(i);
            String logDrive = hdd.getDataNodeLogDrives() == null ? null : hdd.getDataNodeLogDrives().get(i);
            this.configure(HadoopPrms.NodeType.DataNode, config, hdd, host, dataDrives, logDrive);
        }
    }
}

