/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HadoopDescription;
import hydra.HydraInternalException;

public class HadoopRecord {
    protected static int NO_PID = -1;
    HadoopDescription hdd;
    HadoopDescription.NodeDescription nd;
    int pid;
    boolean secure;

    public HadoopRecord(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) {
        this.hdd = hdd;
        this.nd = nd;
        this.pid = pid;
        this.secure = secure;
    }

    protected HadoopDescription getHadoopDescription() {
        return this.hdd;
    }

    protected HadoopDescription.NodeDescription getNodeDescription() {
        return this.nd;
    }

    protected int getPID() {
        return this.pid;
    }

    protected void setPID(int p) {
        if (this.pid != NO_PID) {
            String s = "HadoopRecord for " + this.nd.getName() + " already has a PID: " + this.pid + ", cannot set it to " + p;
            throw new HydraInternalException(s);
        }
        this.pid = p;
    }

    protected void unsetPID(int p) {
        if (this.pid != p) {
            String s = "HadoopRecord for " + this.nd.getName() + " has a PID: " + this.pid + ", was expecting PID: " + this.pid;
            throw new HydraInternalException(s);
        }
        this.pid = NO_PID;
    }

    protected boolean isLive() {
        return this.pid != NO_PID;
    }

    protected boolean getSecure() {
        return this.secure;
    }
}

