/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BasePrms;
import hydra.FileUtil;
import hydra.HostAgentIF;
import hydra.HostAgentRecord;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterProxyIF;
import hydra.Platform;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RmiRegistryHelper;
import hydra.StatMonitor;
import hydra.TestConfig;
import hydra.timeserver.TimeProtocolHandler;
import hydra.timeserver.TimeServerPrms;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Properties;
import util.TestHelper;

public class HostAgent
extends UnicastRemoteObject
implements HostAgentIF,
Runnable {
    private static HostDescription MyHostDescription = null;
    private static String MyHost = null;
    private static int MyPid = -1;
    private static String MyThreadName = null;
    private static MasterProxyIF Master = null;
    private Platform platform = Platform.getInstance();

    private HostAgent() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(MyThreadName);
        TestConfig tc = TestConfig.getHostAgentInstance();
        this.synchronizeWithTimeServer(tc);
        StatMonitor.start(MyHostDescription, Master, tc);
        HostAgentRecord har = new HostAgentRecord(MyHostDescription, MyPid, this);
        try {
            MasterProxyIF masterProxyIF = Master;
            synchronized (masterProxyIF) {
                Master.registerHostAgent(har);
            }
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException(MyThreadName + " unable to contact master", e);
        }
        this.logStatus();
    }

    private static String startStatArchiver() {
        Properties p = new Properties();
        String dirName = System.getProperty("user.dir") + "/" + MyThreadName;
        FileUtil.mkdir(new File(dirName));
        try {
            Master.recordDir(MyHostDescription, "hostagent", dirName);
        }
        catch (RemoteException e) {
            String s = "Unable to record system directory with master: " + dirName;
            throw new HydraRuntimeException(s, e);
        }
        p.setProperty("statistic-archive-file", dirName + "/statArchive.gfs");
        p.setProperty("statistic-sampling-enabled", "true");
        p.setProperty("locators", "");
        p.setProperty("mcast-port", String.valueOf(0));
        DistributedSystem.connect((Properties)p);
        return dirName;
    }

    @Override
    public int bgexec(String command, File workdir, File logfile) throws RemoteException {
        int pid;
        HostAgent.log().info("Executing bgexec command: " + command);
        try {
            pid = this.platform.bgexec(command, workdir, logfile);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to complete operation", e);
        }
        HostAgent.log().info("Executed bgexec command: " + command);
        return pid;
    }

    @Override
    public String fgexec(String command, int maxWaitSec) throws RemoteException {
        HostAgent.log().info("Executing fgexec command: " + command);
        String output = this.platform.fgexec(command, maxWaitSec);
        HostAgent.log().info("Executed fgexec command: " + command);
        return output;
    }

    @Override
    public String fgexec(String command, String[] envp, int maxWaitSec) throws RemoteException {
        HostAgent.log().info("Executing fgexec command: " + command + " with envp " + Arrays.asList(envp));
        String output = this.platform.fgexec(command, envp, maxWaitSec);
        HostAgent.log().info("Executed fgexec command: " + command + " with envp " + Arrays.asList(envp));
        return output;
    }

    @Override
    public String fgexec(String[] command, int maxWaitSec) throws RemoteException {
        HostAgent.log().info("Executing fgexec command: " + Platform.getString(command));
        String output = this.platform.fgexec(command, maxWaitSec);
        HostAgent.log().info("Executed fgexec command: " + Platform.getString(command));
        return output;
    }

    @Override
    public boolean exists(int pid) throws RemoteException {
        return this.platform.exists(pid);
    }

    @Override
    public void shutdown(int pid) throws RemoteException {
        HostAgent.log().info("Executing shutdown on process:" + pid);
        this.platform.shutdown(pid);
        HostAgent.log().info("Executed shutdown on process:" + pid);
    }

    @Override
    public void kill(int pid) throws RemoteException {
        HostAgent.log().info("Executing kill on process:" + pid);
        this.platform.kill(pid);
        HostAgent.log().info("Executed kill on process:" + pid);
    }

    @Override
    public void printStacks(int pid) throws RemoteException {
        HostAgent.log().info("Executing stack dump on process:" + pid);
        this.platform.printStacks(pid);
        HostAgent.log().info("Executed stack dump on process:" + pid);
    }

    @Override
    public void dumpHeap(int pid, String userDir, String options) throws RemoteException {
        HostAgent.log().info("Executing heap dump on process:" + pid);
        this.platform.dumpHeap(pid, userDir, options);
        HostAgent.log().info("Executed heap dump on process:" + pid);
    }

    @Override
    public String getShutdownCommand(int pid) throws RemoteException {
        return this.platform.getShutdownCommand(pid);
    }

    @Override
    public String getKillCommand(int pid) throws RemoteException {
        return this.platform.getKillCommand(pid);
    }

    @Override
    public String getDumpLocksCommand(int pid) throws RemoteException {
        return this.platform.getDumpLocksCommand(pid);
    }

    @Override
    public String getPrintStacksCommand(int pid) throws RemoteException {
        return this.platform.getPrintStacksCommand(pid);
    }

    @Override
    public String[] getDumpHeapCommand(int pid, String userDir, String options) throws RemoteException {
        return this.platform.getDumpHeapCommand(pid, userDir, options);
    }

    @Override
    public String getNetcontrolCommand(String target, int op) throws RemoteException {
        return this.platform.getNetcontrolCommand(target, op);
    }

    @Override
    public String getProcessStatus(int maxWaitSec) throws RemoteException {
        return this.platform.getProcessStatus(maxWaitSec);
    }

    private void logStatus() {
        HostAgent.log().info("Logging host status");
        String status = "";
        try {
            status = status + ProcessMgr.getProcessStatus(60);
        }
        catch (HydraRuntimeException e) {
            HostAgent.log().warning("Unable to log process status: " + TestHelper.getStackTrace());
        }
        catch (HydraTimeoutException e) {
            HostAgent.log().warning("Unable to log process status: " + TestHelper.getStackTrace());
        }
        try {
            status = status + ProcessMgr.getMemoryStatus(60);
        }
        catch (HydraRuntimeException e) {
            HostAgent.log().warning("Unable to log memory status: " + TestHelper.getStackTrace());
        }
        catch (HydraTimeoutException e) {
            HostAgent.log().warning("Unable to log memory status: " + TestHelper.getStackTrace());
        }
        String dir = System.getProperty("user.dir");
        String fn = dir + File.separator + "hoststats_" + MyHost + ".txt";
        FileUtil.appendToFile(fn, status);
        HostAgent.log().info("Logged host status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeWithTimeServer(TestConfig tc) {
        block19: {
            long maxSkew = TimeServerPrms.clockSkewThresholdMs(tc);
            if (maxSkew <= 0L) {
                return;
            }
            String serverHost = tc.getMasterDescription().getTimeServerHost();
            int serverPort = tc.getMasterDescription().getTimeServerPort();
            boolean throwError = TimeServerPrms.errorOnExceededClockSkewThreshold(tc);
            HostAgent.log().info("Checking clock skew...");
            try (TimeProtocolHandler handler = null;){
                handler = new TimeProtocolHandler(serverHost, serverPort, (int)maxSkew, false);
                TimeProtocolHandler.SkewData data = HostAgent.checkSkew(handler, maxSkew);
                if (data == null || data.getLatency() > maxSkew) {
                    String s = "Time server is slow or unresponsive, unable to check time";
                    if (throwError) {
                        throw new HydraRuntimeException(s);
                    }
                    HostAgent.log().warning(s);
                    return;
                }
                long currentSkew = data.getSkew();
                HostAgent.log().info("Clock skew is " + currentSkew + " +/- " + data.getLatency());
                if (currentSkew <= maxSkew) break block19;
                String maxSkewKey = BasePrms.nameForKey(TimeServerPrms.clockSkewThresholdMs);
                HostAgent.log().info("Clock skew (" + currentSkew + " ns)" + " exceeds " + maxSkewKey + " (" + maxSkew + " ns), correcting...");
                try {
                    this.platform.restartNTP();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable t) {
                    HostAgent.log().warning("Problem checking NTP\n" + TestHelper.getStackTrace(t));
                }
                data = HostAgent.checkSkew(handler, maxSkew);
                if (data == null || data.getLatency() > maxSkew) {
                    String s = "Time server is slow or unresponsive, unable to check time";
                    if (throwError) {
                        throw new HydraRuntimeException(s);
                    }
                    HostAgent.log().warning(s);
                    return;
                }
                currentSkew = data.getSkew();
                if (currentSkew > maxSkew) {
                    String s = "Clock skew (" + currentSkew + " ns)" + " exceeds " + maxSkewKey + " (" + maxSkew + " ns) " + "despite attempt at correction";
                    if (throwError) {
                        throw new HydraRuntimeException(s);
                    }
                    HostAgent.log().warning(s);
                } else {
                    HostAgent.log().info("Clock skew is within " + maxSkewKey + " (" + maxSkew + " ns)");
                }
            }
        }
    }

    private static TimeProtocolHandler.SkewData checkSkew(TimeProtocolHandler handler, long maxSkew) {
        TimeProtocolHandler.SkewData data = null;
        try {
            for (int i = 0; i < 3 && (data == null || data.getLatency() > maxSkew); ++i) {
                try {
                    data = handler.checkSkew();
                    continue;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            HostAgent.log().warning("Error communicating with time server" + TestHelper.getStackTrace(e));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDownHostAgent() throws RemoteException {
        HostAgent.log().info(MyThreadName + " shutting down at master's request.");
        try {
            Master.removePIDNoDumps(MyHostDescription, MyPid);
            this.logStatus();
        }
        catch (Throwable t) {
            HostAgent.log().severe("Unable to remove PID " + MyPid + "\n" + TestHelper.getStackTrace(t));
        }
        finally {
            this.shutdown();
        }
    }

    private void shutdown() {
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            throw new HydraRuntimeException("Could not unexport object, quiting anyway", e);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                HostAgent.log().info("Now terminating process.");
                System.exit(0);
            }
        }.start();
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    public static void main(String[] args) {
        MyHost = HostHelper.getLocalHost();
        MyPid = ProcessMgr.getProcessId();
        MyThreadName = "hostagent_" + MyHost + "_" + MyPid;
        Thread.currentThread().setName(MyThreadName);
        FileUtil.mkdir(System.getProperty("user.dir"));
        LogWriter log = Log.createLogWriter(MyThreadName, MyThreadName, "all", System.getProperty("user.dir"), true);
        Log.setLogWriterLevel(TestConfig.getHostAgentInstance().getParameters().stringAt(Prms.logLevelForHostAgent));
        log.info(ProcessMgr.processAndBuildInfoString());
        Master = RmiRegistryHelper.lookupMaster();
        log.info("Starting host agent...");
        MyHostDescription = TestConfig.getHostAgentInstance().getAnyPhysicalHostDescription(MyHost);
        HostAgent agent = null;
        try {
            agent = new HostAgent();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Unable to create HostAgent", e);
        }
        new Thread(agent).start();
        if (Boolean.getBoolean("archiveStats")) {
            String sysdir = HostAgent.startStatArchiver();
            log.info("Started host agent with statistics archive in " + sysdir);
        } else {
            log.info("Started host agent");
        }
    }
}

