/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.HostHelper;
import hydra.HostPrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.TestConfig;
import java.io.File;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class HostDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String hostName;
    private String canonicalHostName;
    private HostHelper.OSType osType;
    private char fileSep;
    private char pathSep;
    private Integer bootstrapPort;
    private String gemfireHome;
    private String userDir;
    private String resourceDir;
    private String testDir;
    private String extraTestDir;
    private String javaHome;
    private String javaVendor;
    private String jprobeHome;
    private String antHome;

    protected HostDescription copy() {
        HostDescription hd = new HostDescription();
        hd.setName(this.getName());
        hd.setHostName(this.getHostName());
        hd.setCanonicalHostName(this.getCanonicalHostName());
        hd.setOSType(this.getOSType());
        hd.setBootstrapPort(this.getBootstrapPort());
        hd.setGemFireHome(this.getGemFireHome());
        hd.setUserDir(this.getUserDir());
        hd.setResourceDir(this.getResourceDir());
        hd.setTestDir(this.getTestDir());
        hd.setExtraTestDir(this.getExtraTestDir());
        hd.setJavaHome(this.getJavaHome());
        hd.setJavaVendor(this.getJavaVendor());
        hd.setJProbeHome(this.getJProbeHome());
        hd.setAntHome(this.getAntHome());
        return hd;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    protected void setHostName(String name) {
        this.hostName = name;
    }

    protected void setCanonicalHostName(String name) {
        this.canonicalHostName = name;
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    public HostHelper.OSType getOSType() {
        return this.osType;
    }

    protected void setOSType(HostHelper.OSType os) {
        this.osType = os;
        this.fileSep = EnvHelper.getFileSep(os);
        this.pathSep = EnvHelper.getPathSep(os);
    }

    public char getFileSep() {
        return this.fileSep;
    }

    public char getPathSep() {
        return this.pathSep;
    }

    public Integer getBootstrapPort() {
        return this.bootstrapPort;
    }

    protected void setBootstrapPort(Integer i) {
        this.bootstrapPort = i;
    }

    public String getGemFireHome() {
        return this.gemfireHome;
    }

    protected void setGemFireHome(String dir) {
        this.gemfireHome = dir;
    }

    public String getUserDir() {
        return this.userDir;
    }

    protected void setUserDir(String dir) {
        this.userDir = dir;
    }

    public String getResourceDir() {
        return this.resourceDir;
    }

    protected void setResourceDir(String dir) {
        this.resourceDir = dir;
    }

    public String getTestDir() {
        return this.testDir;
    }

    protected void setTestDir(String dir) {
        this.testDir = dir;
    }

    public String getExtraTestDir() {
        return this.extraTestDir;
    }

    protected void setExtraTestDir(String dir) {
        this.extraTestDir = dir;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    protected void setJavaHome(String dir) {
        this.javaHome = dir;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    protected void setJavaVendor(String vendor) {
        this.javaVendor = vendor;
    }

    public String getJProbeHome() {
        return this.jprobeHome;
    }

    protected void setJProbeHome(String dir) {
        this.jprobeHome = dir;
    }

    public String getAntHome() {
        return this.antHome;
    }

    protected void setAntHome(String dir) {
        this.antHome = dir;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "hostName", this.getHostName());
        map.put(header + "canonicalHostName", this.getCanonicalHostName());
        map.put(header + "osType", (Object)this.getOSType());
        map.put(header + "bootstrapPort", this.getBootstrapPort());
        if (this.getGemFireHome() != null) {
            map.put(header + "gemfireHome", this.getGemFireHome());
        }
        map.put(header + "userDir", this.getUserDir());
        map.put(header + "resourceDir", this.getResourceDir());
        map.put(header + "testDir", this.getTestDir());
        if (this.getExtraTestDir() != null) {
            map.put(header + "extraTestDir", this.getExtraTestDir());
        }
        map.put(header + "javaHome", this.getJavaHome());
        map.put(header + "javaVendor", this.getJavaVendor());
        if (this.getJProbeHome() != null) {
            map.put(header + "jprobeHome", this.getJProbeHome());
        }
        if (this.getAntHome() != null) {
            map.put(header + "antHome", this.getAntHome());
        }
        return map;
    }

    @Override
    public String toString() {
        return this.toSortedMap().toString();
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        SortedMap resourceDirBaseMap = HostPrms.getResourceDirBaseMap();
        SortedMap<String, Vector<String>> hostNameMap = HostPrms.getHostNameMap();
        TreeMap<String, Integer> hostNameMapIndex = new TreeMap<String, Integer>();
        String masterDir = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription().getUserDir();
        HydraVector names = tab.vecAt(HostPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String str;
            HostDescription hd = new HostDescription();
            String name = (String)names.elementAt(i);
            hd.setName(name);
            Long key = HostPrms.hostNames;
            String defaultHostName = config.getMasterDescription().getVmDescription().getHostDescription().getHostName();
            String hostName = null;
            if (hostNameMap == null) {
                hostName = tab.stringAtWild(key, i, defaultHostName);
            } else {
                for (String namePrefix : hostNameMap.keySet()) {
                    if (!name.startsWith(namePrefix)) continue;
                    Vector physicalHosts = (Vector)hostNameMap.get(namePrefix);
                    Integer nextIndex = (Integer)hostNameMapIndex.get(namePrefix);
                    if (nextIndex == null) {
                        hostName = (String)physicalHosts.get(0);
                        hostNameMapIndex.put(namePrefix, 1);
                        break;
                    }
                    int index = nextIndex;
                    hostName = (String)physicalHosts.get(index % physicalHosts.size());
                    hostNameMapIndex.put(namePrefix, index + 1);
                    break;
                }
                if (hostName == null) {
                    String s = BasePrms.nameForKey(key) + " has no list " + "of physical host names for logical host name " + name;
                    throw new HydraConfigException(s);
                }
            }
            hd.setHostName(EnvHelper.convertHostName(hostName));
            hd.setCanonicalHostName(HostHelper.getCanonicalHostName(hostName));
            key = HostPrms.osTypes;
            String str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getRequiredProperty("os.name", key);
            }
            hd.setOSType(HostHelper.OSType.toOSType(str2, key));
            key = HostPrms.bootstrapPort;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 != null && !str2.equalsIgnoreCase("none")) {
                hd.setBootstrapPort(HostDescription.getIntegerFor(str2, key));
            }
            if ((str2 = tab.getString(key = HostPrms.gemfireHomes, tab.getWild(key, i, null))) == null) {
                str2 = HostDescription.getRequiredProperty("gemfire.home", key);
            }
            hd.setGemFireHome(str2);
            key = HostPrms.testDirs;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getRequiredProperty("JTESTS", key);
            }
            hd.setTestDir(str2);
            key = HostPrms.extraTestDirs;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getOptionalProperty("EXTRA_JTESTS");
            }
            hd.setExtraTestDir(str2);
            key = HostPrms.userDirs;
            File fn = new File(masterDir);
            String str3 = tab.getString(key, tab.getWild(key, i, null));
            if (str3 == null) {
                str3 = fn.getParent();
            }
            str3 = str3 + hd.getFileSep() + fn.getName();
            str3 = EnvHelper.expandEnvVars(str3, hd);
            hd.setUserDir(str3);
            if (resourceDirBaseMap == null) {
                key = HostPrms.resourceDirBases;
                fn = new File(masterDir);
                str3 = tab.getString(key, tab.getWild(key, i, null));
                str3 = str3 == null ? hd.getUserDir() : str3 + hd.getFileSep() + fn.getName();
                str3 = EnvHelper.expandEnvVars(str3, hd);
                hd.setResourceDir(str3);
            } else {
                str = (String)resourceDirBaseMap.get(hd.getHostName());
                if (str == null) {
                    String s = hd.getHostName() + " is missing from " + tab.stringAt(HostPrms.resourceDirBaseMapFileName);
                    throw new HydraConfigException(s);
                }
                str = str + hd.getFileSep() + new File(masterDir).getName();
                str = EnvHelper.expandEnvVars(str, hd);
                hd.setResourceDir(str);
            }
            key = HostPrms.javaHomes;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getRequiredProperty("java.home", key);
            }
            hd.setJavaHome(str2);
            str = HostPrms.getJavaVendor(i);
            hd.setJavaVendor(str);
            key = HostPrms.jprobeHomes;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getOptionalProperty("JPROBE");
            }
            hd.setJProbeHome(str2);
            key = HostPrms.antHomes;
            str2 = tab.getString(key, tab.getWild(key, i, null));
            if (str2 == null) {
                str2 = HostDescription.getOptionalProperty("ANT_HOME");
            }
            hd.setAntHome(str2);
            config.addHostDescription(hd);
        }
    }

    private static String getRequiredProperty(String propertyName, Long key) {
        String propertyVal = System.getProperty(propertyName);
        if (propertyVal == null) {
            String s = "No value found for either " + BasePrms.nameForKey(key) + " or the " + propertyName + " system property";
            throw new HydraRuntimeException(s);
        }
        return propertyVal;
    }

    protected static String getOptionalProperty(String propertyName) {
        String property = System.getProperty(propertyName);
        return property == null || property.length() == 0 ? null : property;
    }

    protected void checkEquivalent(HostDescription hd) {
        if (hd.getHostName() != null && !hd.getHostName().equals(this.getHostName()) || hd.getCanonicalHostName() != null && !hd.getCanonicalHostName().equals(this.getCanonicalHostName()) || hd.getOSType() != null && hd.getOSType() != this.getOSType() || hd.getGemFireHome() != null && !hd.getGemFireHome().equals(this.getGemFireHome()) || hd.getUserDir() != null && !hd.getUserDir().equals(this.getUserDir()) || hd.getTestDir() != null && !hd.getTestDir().equals(this.getTestDir()) || hd.getExtraTestDir() != null && !hd.getExtraTestDir().equals(this.getExtraTestDir()) || hd.getJavaHome() != null && !hd.getJavaHome().equals(this.getJavaHome()) || hd.getJavaVendor() != null && !hd.getJavaVendor().equals(this.getJavaVendor())) {
            String s = "Attempt to configure multiple logical hosts on same physical host with different characteristics";
            throw new HydraConfigException(s);
        }
    }
}

