/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.TestConfig;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class HostHelper {
    public static final String ONLY_ON_PLATFORMS_PROP = "onlyOnPlatforms";
    private static String CanonicalHost;
    private static String Host;

    public static synchronized String getLocalHost() {
        if (Host == null) {
            String suffix;
            String host = HostHelper.getIPv4Address().getHostName();
            int dot = host.indexOf(".");
            if (dot != -1 && !(suffix = host.substring(dot + 1)).equals("local")) {
                host = host.substring(0, dot);
            }
            Host = host;
        }
        return Host;
    }

    public static synchronized String getCanonicalHostName() {
        if (CanonicalHost == null) {
            CanonicalHost = HostHelper.getIPv4Address().getCanonicalHostName();
        }
        return CanonicalHost;
    }

    protected static boolean compareHosts(String host1, String host2) {
        String tmp2;
        String tmp1 = HostHelper.getNoncanonicalHostName(host1).toLowerCase();
        return tmp1.startsWith(tmp2 = HostHelper.getNoncanonicalHostName(host2).toLowerCase()) || tmp2.startsWith(tmp1);
    }

    protected static String getNoncanonicalHostName(String host) {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        int dot = host.indexOf(".");
        return dot == -1 ? host : host.substring(0, dot);
    }

    public static String getCanonicalHostName(String host) {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        try {
            for (InetAddress addr : InetAddress.getAllByName(host)) {
                if (!(addr instanceof Inet4Address)) continue;
                return addr.getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            String s = "Host not found: " + host;
            throw new HydraRuntimeException(s, e);
        }
        String s = "IPv4 address not found for host: " + host;
        throw new HydraRuntimeException(s);
    }

    public static boolean isLocalHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        return HostHelper.getCanonicalHostName(host).equals(HostHelper.getCanonicalHostName());
    }

    public static String getHostAddress() {
        return HostHelper.getHostAddress(HostHelper.getIPAddress());
    }

    public static String getHostAddress(InetAddress addr) {
        int idx;
        String address = addr.getHostAddress();
        if ((addr instanceof Inet4Address || !addr.isLinkLocalAddress() && !addr.isLoopbackAddress()) && (idx = address.indexOf(37)) >= 0) {
            address = address.substring(0, idx);
        }
        return address;
    }

    public static InetAddress getIPAddress() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses") ? HostHelper.getIPv6Address() : HostHelper.getIPv4Address();
    }

    protected static InetAddress getIPv4Address() {
        InetAddress host = null;
        try {
            host = InetAddress.getLocalHost();
            if (host instanceof Inet4Address) {
                if (host.isLoopbackAddress() && !"127.0.0.1".equals(host.getHostAddress())) {
                    return InetAddress.getByName(null);
                }
                return host;
            }
        }
        catch (UnknownHostException e) {
            String s = "Local host not found";
            throw new HydraRuntimeException(s, e);
        }
        try {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                NetworkInterface ni = i.nextElement();
                Enumeration<InetAddress> j = ni.getInetAddresses();
                while (j.hasMoreElements()) {
                    InetAddress addr = j.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr;
                }
            }
            String s = "IPv4 address not found";
            throw new HydraRuntimeException(s);
        }
        catch (SocketException e) {
            String s = "Problem reading IPv4 address";
            throw new HydraRuntimeException(s, e);
        }
    }

    public static InetAddress getIPv6Address() {
        try {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                NetworkInterface ni = i.nextElement();
                Enumeration<InetAddress> j = ni.getInetAddresses();
                while (j.hasMoreElements()) {
                    InetAddress addr = j.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet6Address) || HostHelper.isIPv6LinkLocalAddress((Inet6Address)addr)) continue;
                    return addr;
                }
            }
            String s = "IPv6 address not found";
            throw new HydraRuntimeException(s);
        }
        catch (SocketException e) {
            String s = "Problem reading IPv6 address";
            throw new HydraRuntimeException(s, e);
        }
    }

    private static boolean isIPv6LinkLocalAddress(Inet6Address addr) {
        byte[] addrBytes = addr.getAddress();
        return addrBytes[0] == -2 && addrBytes[1] == -128;
    }

    public static boolean isWindows() {
        return OSType.toLocalOSType() == OSType.windows;
    }

    public static OSType getLocalHostOS() {
        return OSType.toLocalOSType();
    }

    public static OSType getHostOS(String host) {
        return TestConfig.getInstance().getAnyPhysicalHostDescription(host).getOSType();
    }

    public static boolean shouldRun(String onlyOnPlatforms) {
        if (onlyOnPlatforms == null || "".equals(onlyOnPlatforms)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(onlyOnPlatforms, ",");
        String os = System.getProperty("os.name");
        while (st.hasMoreTokens()) {
            if (!os.startsWith(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    public static String applyRFC2732(String hostname) {
        if (hostname.indexOf(":") != -1) {
            return "[" + hostname + "]";
        }
        return hostname;
    }

    public static enum OSType {
        unix,
        windows;


        protected static OSType toLocalOSType() {
            String os = System.getProperty("os.name");
            if (os == null) {
                String s = "System property os.name is missing in this JVM";
                throw new HydraRuntimeException(s);
            }
            return OSType.toOSType(os, null);
        }

        protected static OSType toOSType(String os) {
            return OSType.toOSType(os, null);
        }

        protected static OSType toOSType(String os, Long key) {
            String str = os;
            if (str == null) {
                String s = "";
                throw new IllegalArgumentException(s);
            }
            if ((str = str.toLowerCase()).contains("windows")) {
                return windows;
            }
            if (str.contains("linux") || str.contains("unix") || str.contains("sunos") || str.contains("solaris") || str.contains("hpux") || str.contains("hp-ux") || str.contains("aix") || str.contains("darwin") || str.contains("mac")) {
                return unix;
            }
            String s = key == null ? "Illegal O/S name: " + os : "Illegal value for " + BasePrms.nameForKey(key) + ": " + os;
            throw new HydraConfigException(s);
        }
    }
}

