/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class HostPrms
extends BasePrms {
    public static final String HOST_NAME_PROPERTY = "hostName";
    public static Long names;
    public static Long bootstrapPort;
    public static Long hostNames;
    public static Long osTypes;
    public static Long gemfireHomes;
    public static Long userDirs;
    public static Long resourceDirBases;
    public static Long resourceDirBaseMapFileName;
    public static Long testDirs;
    public static Long extraTestDirs;
    public static Long javaHomes;
    public static Long javaVendors;
    public static final String SUN = "Sun";
    public static final String IBM = "IBM";
    public static final String JROCKIT = "JRockit";
    public static final String APPLE = "Apple";
    public static final String HITACHI = "Hitachi";
    public static Long jprobeHomes;
    public static Long antHomes;

    public static SortedMap<String, Vector<String>> getHostNameMap() {
        Long key = hostNames;
        HydraVector list = HostPrms.tab().vecAt(key, null);
        if (list != null) {
            if (list.get(0) instanceof HydraVector) {
                TreeMap<String, Vector<String>> map = new TreeMap<String, Vector<String>>();
                for (int i = 0; i < list.size(); ++i) {
                    Vector sublist = (Vector)list.get(i);
                    if (sublist.size() <= 1) {
                        String s = "No physical host names given for logical host name prefix " + (String)sublist.get(0);
                        throw new HydraConfigException(s);
                    }
                    String logicalPrefix = (String)sublist.get(0);
                    Vector physicalHosts = new Vector();
                    for (int j = 1; j < sublist.size(); ++j) {
                        physicalHosts.add(sublist.get(j));
                    }
                    map.put(logicalPrefix, physicalHosts);
                }
                Log.getLogWriter().info("Host mapping: " + map);
                return map;
            }
            return null;
        }
        return null;
    }

    public static SortedMap getResourceDirBaseMap() {
        Long key = resourceDirBaseMapFileName;
        String fn = HostPrms.tab().stringAt(key, null);
        if (fn != null) {
            try {
                String newfn = EnvHelper.expandEnvVars(fn);
                return FileUtil.getPropertiesAsMap(newfn);
            }
            catch (Exception e) {
                String s = "Illegal value for: " + HostPrms.nameForKey(key);
                throw new HydraConfigException(s, e);
            }
        }
        return null;
    }

    public static String getJavaVendor() {
        String vendor = System.getProperty("java.vm.vendor");
        String vmname = System.getProperty("java.vm.name");
        if (vendor.contains(SUN)) {
            vendor = SUN;
        } else if (vendor.contains(IBM)) {
            vendor = IBM;
        } else if (vendor.contains("BEA")) {
            vendor = JROCKIT;
        } else if (vendor.contains(HITACHI)) {
            vendor = HITACHI;
        } else if (vendor.contains(APPLE)) {
            vendor = APPLE;
        } else if (vendor.contains("Oracle") && vmname.contains(JROCKIT)) {
            vendor = JROCKIT;
        } else if (vendor.contains("Oracle") && vmname.contains("HotSpot")) {
            vendor = SUN;
        } else {
            String s = "Unable to classify JVM with vendor: " + vendor + " and name: " + vmname;
            throw new HydraConfigException(s);
        }
        return vendor;
    }

    public static String getJavaVendor(int i) {
        Long key = javaVendors;
        String val = HostPrms.tab().stringAtWild(key, i, HostPrms.getJavaVendor());
        if (val.equalsIgnoreCase(SUN)) {
            return SUN;
        }
        if (val.equalsIgnoreCase(IBM)) {
            return IBM;
        }
        if (val.equalsIgnoreCase(JROCKIT)) {
            return JROCKIT;
        }
        if (val.equalsIgnoreCase(HITACHI)) {
            return HITACHI;
        }
        if (val.equalsIgnoreCase(APPLE)) {
            return APPLE;
        }
        throw new HydraConfigException("Illegal value for " + HostPrms.nameForKey(key) + ": " + val);
    }

    public static void main(String[] args) {
        Log.createLogWriter("hostprms", "info");
        HostPrms.dumpKeys();
    }

    static {
        HostPrms.setValues(HostPrms.class);
    }
}

