/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HydraThreadSubgroup;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class HydraThreadGroup
implements Serializable {
    public static final String DEFAULT_NAME = "default";
    private String name;
    private Vector subgroups = new Vector();
    private Boolean weighted = null;
    private int totalThreads = -1;

    public HydraThreadGroup(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public Boolean usesCustomWeights() {
        return this.weighted;
    }

    public void usesCustomWeights(Boolean b) {
        this.weighted = b;
    }

    public Vector getSubgroups() {
        return this.subgroups;
    }

    public HydraThreadSubgroup getSubgroup(int i) {
        return (HydraThreadSubgroup)this.subgroups.elementAt(i);
    }

    public void addSubgroup(HydraThreadSubgroup subgroup) {
        this.subgroups.add(subgroup);
    }

    public int getTotalThreads() {
        if (this.totalThreads == -1) {
            this.totalThreads = 0;
            for (HydraThreadSubgroup subgroup : this.getSubgroups()) {
                this.totalThreads += subgroup.getTotalThreads();
            }
        }
        return this.totalThreads;
    }

    public SortedMap toSortedMap() {
        StringBuffer buf = new StringBuffer();
        for (HydraThreadSubgroup sg : this.subgroups) {
            buf.append(sg.toString());
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        String header = this.getClass().getName() + "." + this.getName();
        map.put(header, buf.toString());
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.toSortedMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }
}

