/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.BasePrms;
import hydra.HydraRuntimeException;
import hydra.HypericServerInstallDescription;
import hydra.HypericServerInstallPrms;
import hydra.Log;
import hydra.TestConfig;
import java.util.Collection;

public class HypericServerInstallHelper {
    private static LogWriter log = Log.getLogWriter();

    public static HypericServerInstallDescription getHypericServerInstallDescription(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName cannot be null");
        }
        log.info("Looking up hyperic server install config for host: " + hostName);
        Collection hqds = TestConfig.getInstance().getHypericServerInstallDescriptions().values();
        for (HypericServerInstallDescription hqd : hqds) {
            if (!hqd.hostDescription.getHostName().equals(hostName)) continue;
            log.info("Looked up hyperic server install config:\n" + hqd);
            return hqd;
        }
        String s = hostName + " not found in " + BasePrms.nameForKey(HypericServerInstallPrms.names);
        throw new HydraRuntimeException(s);
    }
}

