/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BootstrapperProxyIF;
import hydra.ClientDescription;
import hydra.ClientVmRecord;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GFMonPrms;
import hydra.GemFireDescription;
import hydra.HadoopDescription;
import hydra.HostAgentDescription;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.JDKVersionDescription;
import hydra.Log;
import hydra.Nuker;
import hydra.ProcessMgr;
import hydra.ProductVersionHelper;
import hydra.RemoteTestModule;
import hydra.RmiRegistryHelper;
import hydra.TestConfig;
import hydra.VersionDescription;
import hydra.VmDescription;
import hydra.log.LogPrms;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class Java {
    public static int javaMergeLogFiles(String fn, List logFiles) {
        int maxWaitSec;
        String sep = File.separator;
        String cmd = System.getProperty("java.home") + sep + "bin" + sep + "java ";
        cmd = cmd + "-classpath " + System.getProperty("java.class.path") + " ";
        cmd = cmd + "-Duser.dir=" + System.getProperty("user.dir") + " ";
        int maxHeap = TestConfig.tab().intAt(LogPrms.mergeLogFilesMaxHeapMB, 512);
        cmd = cmd + "-Xmx" + maxHeap + "m ";
        cmd = cmd + "-DrmiHost=" + System.getProperty("rmiHost") + " ";
        cmd = cmd + "-DrmiPort=" + System.getProperty("rmiPort") + " ";
        String args = TestConfig.tab().stringAt(LogPrms.mergeLogFilesArgs, "-dirCount 1");
        cmd = cmd + "com.gemstone.gemfire.internal.MergeLogFiles " + args + " -mergeFile " + fn + " ";
        for (File logFile : logFiles) {
            cmd = cmd + logFile.getAbsolutePath() + " ";
        }
        int pid = ProcessMgr.bgexec(cmd);
        String host = HostHelper.getLocalHost();
        if (!ProcessMgr.waitForDeath(host, pid, maxWaitSec = 300)) {
            String err = "Waited more than " + maxWaitSec + " seconds for logs to be merged";
            boolean killed = ProcessMgr.killProcessWait(host, pid, 10);
            if (killed) {
                throw new HydraRuntimeException(err + ", killed merge process");
            }
            throw new HydraRuntimeException(err + ", tried (and failed) to kill merge process");
        }
        return pid;
    }

    public static int javaGemFireLocatorAgent(String distributedSystemName, String vmArgs, String classpath) {
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        String sep = File.separator;
        String cmd = System.getProperty("java.home") + sep + "bin" + sep + "java ";
        cmd = cmd + "-classpath " + classpath + " ";
        cmd = cmd + "-Duser.dir=" + System.getProperty("user.dir") + " ";
        cmd = cmd + "-DdistributedSystemName=" + distributedSystemName + " ";
        cmd = cmd + "-DJTESTS=" + System.getProperty("JTESTS") + " ";
        String extraJtests = System.getProperty("EXTRA_JTESTS");
        if (extraJtests != null) {
            cmd = cmd + "-DEXTRA_JTESTS=" + extraJtests + " ";
        }
        cmd = cmd + "-DrmiHost=" + System.getProperty("rmiHost") + " ";
        cmd = cmd + "-DrmiPort=" + System.getProperty("rmiPort") + " ";
        String p = System.getProperty("gemfire.home");
        if (p != null) {
            cmd = cmd + "-Dgemfire.home=" + p + " ";
        }
        if (vmArgs != null) {
            cmd = cmd + vmArgs + " ";
        }
        cmd = cmd + "hydra.GemFireLocatorAgent";
        int pid = ProcessMgr.bgexec(cmd);
        Nuker.getInstance().recordPID(hd, pid);
        return pid;
    }

    public static int javaGFMon() {
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        String sep = File.separator;
        String cmd = System.getProperty("java.home") + sep + "bin" + sep + "java ";
        String gemfire = System.getProperty("gemfire.home");
        if (gemfire == null) {
            String s = "gemfire.home system property not set";
            throw new HydraRuntimeException(s);
        }
        Vector bootpath = new Vector();
        bootpath.add(gemfire + sep + "lib" + sep + "snappydata-store-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + ".jar");
        bootpath.add(System.getProperty("JTESTS"));
        bootpath = EnvHelper.expandEnvVars(bootpath, hd);
        String bootpathStr = EnvHelper.asPath(bootpath, hd);
        cmd = cmd + "-Xbootclasspath/a:" + bootpathStr + " ";
        cmd = cmd + GFMonPrms.getExtraVMArgs() + " ";
        String resultDir = hd.getUserDir();
        String gfmonDir = resultDir + sep + "gfmon";
        if (!FileUtil.exists(gfmonDir)) {
            FileUtil.mkdir(gfmonDir);
        }
        cmd = cmd + "-Dstats.archive-file=" + gfmonDir + sep + "statArchive.gfs ";
        cmd = cmd + "-DlogLevel=" + GFMonPrms.getLogLevel() + " ";
        if (hd.getExtraTestDir() != null) {
            cmd = cmd + "-DEXTRA_JTESTS=" + hd.getExtraTestDir() + " ";
        }
        cmd = cmd + "-DrmiHost=" + System.getProperty("rmiHost") + " ";
        cmd = cmd + "-DrmiPort=" + System.getProperty("rmiPort") + " ";
        String gfmon = System.getProperty("GFMON");
        if (gfmon == null) {
            String s = "GFMON system property not set";
            throw new HydraRuntimeException(s);
        }
        cmd = cmd + "-cp " + gfmon + sep + "eclipse" + sep + "startup.jar ";
        cmd = cmd + "org.eclipse.core.launcher.Main ";
        cmd = cmd + "-clean -noupdate -verbose -consolelog ";
        cmd = cmd + "-configuration " + gfmon + sep + "eclipse" + sep + "configuration ";
        cmd = cmd + "-data " + resultDir + sep + "wintest ";
        String testClassName = GFMonPrms.getTestClassName();
        cmd = cmd + "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter," + resultDir + sep + "wintest" + sep + testClassName + "-result.xml ";
        cmd = cmd + "-application com.windowtester.runner.application ";
        cmd = cmd + "-testPluginName gfmonIIWtPro_test ";
        cmd = cmd + "-classname " + testClassName + " ";
        cmd = cmd + "-testApplication com.gemstone.gemfire.tools.application ";
        HostHelper.OSType os = HostHelper.getLocalHostOS();
        switch (os) {
            case unix: {
                cmd = cmd + "-WS gtk";
                break;
            }
            case windows: {
                break;
            }
            default: {
                String s = "Unsupported O/S for GFMon WindowTester: " + (Object)((Object)os);
                throw new UnsupportedOperationException(s);
            }
        }
        int pid = ProcessMgr.bgexec(cmd);
        Nuker.getInstance().recordPID(hd, pid);
        return pid;
    }

    public static int javaHostAgent(HostAgentDescription had) {
        HostDescription hd = had.getHostDescription();
        char sep = hd.getFileSep();
        StringBuffer cmd = new StringBuffer();
        cmd.append(hd.getJavaHome()).append(sep).append("bin").append(sep).append("java ").append("-classpath ").append(had.getClassPath()).append(" ").append("-DJTESTS=").append(hd.getTestDir()).append(" ").append("-Duser.dir=").append(hd.getUserDir()).append(" ").append("-DrmiHost=" + System.getProperty("rmiHost")).append(" ").append("-DrmiPort=" + System.getProperty("rmiPort")).append(" ");
        if (hd.getGemFireHome() != null) {
            cmd.append("-Dgemfire.home=").append(hd.getGemFireHome()).append(" ");
        }
        cmd.append("-DarchiveStats=").append(had.getArchiveStats()).append(" ");
        cmd.append("hydra.HostAgent");
        HostHelper.OSType src = HostHelper.getLocalHostOS();
        HostHelper.OSType dst = hd.getOSType();
        Log.getLogWriter().info("Starting hostagent from " + (Object)((Object)src) + " on " + (Object)((Object)dst));
        int pid = -1;
        if (src == HostHelper.OSType.windows || dst == HostHelper.OSType.windows) {
            Log.getLogWriter().info("Using bootstrapper");
            String url = "rmi://" + hd.getHostName() + ":" + hd.getBootstrapPort() + "/" + "bootstrapper";
            Log.getLogWriter().info("Looking up bootstrapper at " + url);
            BootstrapperProxyIF bootstrapper = (BootstrapperProxyIF)RmiRegistryHelper.lookup(url);
            if (bootstrapper == null) {
                String s = "Bootstrapper is null";
                throw new HydraRuntimeException(s);
            }
            Log.getLogWriter().info("Found bootstrapper");
            try {
                String bootcmd = cmd.toString();
                Log.getLogWriter().info("Command is " + bootcmd);
                pid = bootstrapper.bgexec(bootcmd);
            }
            catch (RemoteException e) {
                String s = "Unable to run command on bootstrapper";
                throw new HydraRuntimeException(s, e);
            }
        } else if (HostHelper.isLocalHost(hd.getHostName())) {
            Log.getLogWriter().info("Not using ssh on localhost: " + hd.getHostName());
            Log.getLogWriter().info("Command is " + cmd);
            pid = ProcessMgr.bgexec(cmd.toString());
        } else {
            Log.getLogWriter().info("Using ssh");
            String sshcmd = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + " " + cmd;
            Log.getLogWriter().info("Command is " + sshcmd);
            pid = ProcessMgr.bgexec(sshcmd.toString());
        }
        return pid;
    }

    public static int javaRemoteTestModule(String masterHost, int masterPid, ClientVmRecord vm, String purpose) {
        ClientDescription cd = vm.getClientDescription();
        VmDescription vmd = cd.getVmDescription();
        JDKVersionDescription jvd = cd.getJDKVersionDescription();
        VersionDescription vd = cd.getVersionDescription();
        HostDescription hd = vmd.getHostDescription();
        String cmd = new String();
        String javaHome = vm.getJavaHome();
        if (cd.getJProbeDescription() != null) {
            cmd = cmd + cd.getJProbeDescription().getCommandLine(hd.getJProbeHome(), vmd.getType());
        } else {
            cmd = cmd + javaHome + hd.getFileSep() + "bin" + hd.getFileSep() + "java ";
            if (vmd.getType() != null) {
                cmd = cmd + "-" + vmd.getType() + " ";
            }
        }
        String extraVMArgs = vmd.getExtraVMArgs();
        if (extraVMArgs != null) {
            cmd = cmd + extraVMArgs + " ";
        }
        if (purpose != null) {
            cmd = cmd + "-Dpurpose=" + purpose + " ";
        }
        cmd = cmd + "-DmasterHost=" + masterHost + " ";
        cmd = cmd + "-DmasterPid=" + masterPid + " ";
        cmd = cmd + "-DrmiHost=" + System.getProperty("rmiHost") + " ";
        cmd = cmd + "-DrmiPort=" + System.getProperty("rmiPort") + " ";
        String hostName = hd.getName();
        cmd = cmd + "-DhostName=" + hostName + " ";
        String clientName = cd.getName();
        cmd = cmd + "-DclientName=" + clientName + " ";
        GemFireDescription gfd = cd.getGemFireDescription();
        if (gfd != null) {
            cmd = cmd + "-DgemfireName=" + gfd.getName() + " ";
        }
        cmd = cmd + "-DnumThreads=" + cd.getVmThreads() + " ";
        cmd = cmd + "-DbaseThreadId=" + vm.getBaseThreadId() + " ";
        cmd = cmd + "-Dvmid=" + vm.getVmid() + " ";
        cmd = cmd + "-DJTESTS=" + hd.getTestDir() + " ";
        if (hd.getExtraTestDir() != null) {
            cmd = cmd + "-DEXTRA_JTESTS=" + hd.getExtraTestDir() + " ";
        }
        cmd = cmd + "-Duser.dir=" + hd.getUserDir() + " ";
        String libpath = null;
        libpath = jvd == null && vd == null ? vmd.getLibPath() : (vd != null ? vd.getLibPath(vmd, vm.getVersion(), javaHome) : jvd.getLibPath(vmd, javaHome));
        if (libpath != null) {
            cmd = cmd + "-Djava.library.path=" + libpath + " ";
        }
        String classpath = null;
        classpath = jvd == null && vd == null ? vmd.getClassPath() : (vd != null ? vd.getClassPath(vmd, vm.getVersion(), javaHome) : jvd.getClassPath(vmd, javaHome));
        String path = HadoopDescription.getExtraClassPath(TestConfig.getInstance());
        if (path != null) {
            String string = classpath = classpath == null ? (classpath = path) : path + hd.getPathSep() + classpath;
        }
        if (classpath != null) {
            cmd = cmd + "-classpath " + classpath + " ";
        }
        String gemfireHome = vd == null ? hd.getGemFireHome() : vd.getGemFireHome(vmd, vm.getVersion());
        cmd = cmd + "-Dgemfire.home=" + gemfireHome + " ";
        cmd = cmd + "hydra.RemoteTestModule";
        int pid = ProcessMgr.bgexec(hd.getHostName(), cmd);
        Nuker.getInstance().recordPID(hd, pid);
        return pid;
    }

    public static int java(ClientDescription cd, String main) {
        VmDescription vmd = cd.getVmDescription();
        HostDescription hd = vmd.getHostDescription();
        String sep = File.separator;
        String cmd = new String();
        if (cd.getJProbeDescription() != null) {
            cmd = cmd + cd.getJProbeDescription().getCommandLine(hd.getJProbeHome(), vmd.getType());
        } else {
            cmd = cmd + hd.getJavaHome() + sep + "bin" + sep + "java ";
            if (vmd.getType() != null) {
                cmd = cmd + "-" + vmd.getType() + " ";
            }
        }
        String extraVMArgs = vmd.getExtraVMArgs();
        if (extraVMArgs != null) {
            cmd = cmd + extraVMArgs + " ";
        }
        String clientName = cd.getName();
        cmd = cmd + "-DclientName=" + clientName + " ";
        long randomSeed = Java.tab().getRandGen().nextLong();
        cmd = cmd + "-DrandomSeed=" + randomSeed + " ";
        cmd = cmd + "-DJTESTS=" + hd.getTestDir() + " ";
        if (hd.getExtraTestDir() != null) {
            cmd = cmd + "-DEXTRA_JTESTS=" + hd.getExtraTestDir() + " ";
        }
        cmd = cmd + "-DrmiHost=" + System.getProperty("rmiHost") + " ";
        cmd = cmd + "-DrmiPort=" + System.getProperty("rmiPort") + " ";
        cmd = cmd + "-Duser.dir=" + hd.getUserDir() + " ";
        new File(hd.getUserDir()).mkdirs();
        cmd = cmd + "-classpath " + vmd.getClassPath() + " ";
        cmd = cmd + "-Dgemfire.home=" + hd.getGemFireHome() + " ";
        cmd = cmd + main;
        int pid = ProcessMgr.bgexec(hd.getHostName(), cmd);
        if (RemoteTestModule.Master == null) {
            Nuker.getInstance().recordPIDNoDumps(hd, pid);
        } else {
            try {
                RemoteTestModule.Master.recordPIDNoDumps(hd, pid);
            }
            catch (RemoteException e) {
                String s = "Unable to record PID with master: " + pid;
                throw new HydraRuntimeException(s, e);
            }
        }
        return pid;
    }

    private static ConfigHashtable tab() {
        return TestConfig.tab();
    }
}

