/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.LogWriterImpl;
import hydra.HydraRuntimeException;
import hydra.log.AnyLogWriter;
import java.util.Hashtable;

public class Log {
    private static AnyLogWriter logWriter;
    private static String logName;
    private static Hashtable cache;

    public static synchronized LogWriter createLogWriter(String name, String levelName) {
        if (logWriter != null) {
            throw new HydraRuntimeException("Log writer has already been created");
        }
        logWriter = new AnyLogWriter(levelName);
        logName = name;
        return logWriter;
    }

    public static synchronized LogWriter createLogWriter(String name, String filePrefix, String levelName, boolean append) {
        if (logWriter != null) {
            throw new HydraRuntimeException("Log writer has already been created");
        }
        logWriter = new AnyLogWriter(filePrefix, levelName, append);
        logName = name;
        return logWriter;
    }

    public static synchronized LogWriter createLogWriter(String name, String filePrefix, String levelName, String dir, boolean append) {
        if (logWriter != null) {
            throw new HydraRuntimeException("Log writer has already been created");
        }
        logWriter = new AnyLogWriter(filePrefix, levelName, dir, append);
        logName = name;
        return logWriter;
    }

    public static synchronized LogWriter createLogWriter(String name, String filePrefix, boolean fileLogging, String fileLogLevelName, int fileMaxKBPerVM) {
        if (logWriter != null) {
            throw new HydraRuntimeException("Log writer has already been created");
        }
        logWriter = new AnyLogWriter(filePrefix, fileLogging, fileLogLevelName, fileMaxKBPerVM);
        logName = name;
        return logWriter;
    }

    public static void closeLogWriter() {
        if (logWriter == null) {
            throw new HydraRuntimeException("Log writer does not exist");
        }
        logName = null;
        logWriter = null;
    }

    public static void cacheLogWriter() {
        if (logWriter == null) {
            throw new HydraRuntimeException("Log writer has not been created");
        }
        if (cache == null) {
            cache = new Hashtable();
        }
        if (cache.get(logName) != null) {
            throw new HydraRuntimeException("Log writer " + logName + " has already been cached");
        }
        cache.put(logName, logWriter);
        logName = null;
        logWriter = null;
    }

    public static LogWriter uncacheLogWriter(String name) {
        if (cache == null) {
            throw new HydraRuntimeException("Log writer " + name + " has not been cached");
        }
        if (logWriter != null) {
            throw new HydraRuntimeException("Log writer " + name + " is still active");
        }
        AnyLogWriter lw = (AnyLogWriter)cache.get(name);
        if (lw == null) {
            throw new HydraRuntimeException("Log writer " + name + " has not been cached");
        }
        logName = name;
        logWriter = lw;
        return logWriter;
    }

    public static LogWriter getLogWriter() {
        if (logWriter == null) {
            throw new HydraRuntimeException("Attempt to getLogWriter() before createLogWriter()");
        }
        return logWriter;
    }

    public static String getLogWriterLevel() {
        return LogWriterImpl.levelToString((int)logWriter.getLevel());
    }

    public static void setLogWriterLevel(String levelName) {
        logWriter.setLevel(LogWriterImpl.levelNameToCode((String)levelName));
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("chester");
        Log.createLogWriter("test", "finer");
        Log.getLogWriter().fine("fine");
        Log.getLogWriter().finer("finer");
        Log.getLogWriter().finest("finest");
        Log.setLogWriterLevel("all");
        Log.getLogWriter().fine("fine");
        Log.getLogWriter().finer("finer");
        Log.getLogWriter().finest("finest");
    }
}

