/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HostPrms;
import hydra.PortHelper;
import hydra.Prms;
import hydra.TestConfig;
import hydra.VmDescription;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MasterDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private VmDescription vmd;
    private HashMap ports = new HashMap();
    private HashMap locators = new HashMap();
    private String timeServerHost;
    private int timeServerPort;

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public VmDescription getVmDescription() {
        return this.vmd;
    }

    private void setVmDescription(VmDescription vmd) {
        this.vmd = vmd;
    }

    protected int getLocatorPort(String dsName) {
        return (Integer)this.ports.get(dsName);
    }

    public String getLocator() {
        return this.getLocator("ds");
    }

    public String getLocator(String dsName) {
        return (String)this.locators.get(dsName);
    }

    protected void setTimeServerHost(String host) {
        this.timeServerHost = host;
    }

    protected String getTimeServerHost() {
        return this.timeServerHost;
    }

    protected void setTimeServerPort(int port) {
        this.timeServerPort = port;
    }

    protected int getTimeServerPort() {
        return this.timeServerPort;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, HashMap> map = new TreeMap<String, HashMap>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.putAll(this.getVmDescription().getHostDescription().toSortedMap());
        map.putAll(this.getVmDescription().toSortedMap());
        map.put(header + "locators", this.locators);
        return map;
    }

    public static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        MasterDescription md = new MasterDescription();
        md.setName("master");
        HostDescription hd = new HostDescription();
        hd.setName("masterHost");
        hd.setHostName(HostHelper.getLocalHost());
        hd.setCanonicalHostName(HostHelper.getCanonicalHostName());
        hd.setOSType(HostHelper.getLocalHostOS());
        hd.setGemFireHome(System.getProperty("gemfire.home"));
        hd.setTestDir(System.getProperty("JTESTS"));
        hd.setExtraTestDir(HostDescription.getOptionalProperty("EXTRA_JTESTS"));
        hd.setUserDir(System.getProperty("user.dir"));
        hd.setJavaHome(System.getProperty("java.home"));
        hd.setJavaVendor(HostPrms.getJavaVendor());
        hd.setJProbeHome("unknown");
        VmDescription vmd = new VmDescription();
        vmd.setName("masterVM");
        vmd.setHostDescription(hd);
        vmd.setClassPath(System.getProperty("java.class.path"));
        vmd.setLibPath(System.getProperty("java.library.path"));
        vmd.setExtraVMArgs("unknown");
        md.setVmDescription(vmd);
        config.setMasterDescription(md);
    }

    protected void postprocess() {
        Map<String, GemFireDescription> gfds;
        if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents) && (gfds = TestConfig.getInstance().getGemFireDescriptions()).size() != 0) {
            StringBuffer sb = new StringBuffer();
            InetAddress addr = HostHelper.getIPAddress();
            sb.append(addr.getHostName());
            sb.append("@");
            sb.append(HostHelper.getHostAddress(addr));
            for (GemFireDescription gfd : gfds.values()) {
                String ds = gfd.getDistributedSystem();
                if (this.locators.containsKey(ds)) continue;
                if (gfd.getUseLocator().booleanValue()) {
                    int port = PortHelper.getRandomPort();
                    this.ports.put(ds, new Integer(port));
                    this.locators.put(ds, sb.toString() + "[" + port + "]");
                    continue;
                }
                this.locators.put(ds, "");
            }
        }
    }
}

